;STATES.ASM
*******************************************************************************
*REVISION HISTORY:
*
*DATE			REV. NO.	DESCRIPTION
*
*August 15, 2005	1.00		Initial release
*
*
*Author: Exequiel Rarama for the Adapt9S12NE64
*******************************************************************************
;Assembled using CW
;
; ---------------------------
; Demo - State Routine
; ---------------------------

	include "NE64Regs.INC"
	include "PacketFrame.inc"

;Public Function
	XDEF ProcessCommand
	XDEF ShowAnalog
	XDEF SendDecByte		;Hex to Decimal conversion

	XDEF ShowMenu
	XDEF go_power

	XDEF HTOD


;Public Variables
	XDEF d_flag
	XDEF DBUFR

;Public Messages
	XDEF CurrentIPMsg

;External Function
	XREF SerOutput0
	XREF OutStr0	

	XREF set_audio
	XREF AudioOn

	XREF TestARP
	XREF ARPResponse
	XREF ProcessFrameBuff
	XREF DumpMACIP10
	XREF WriteBuff
	XREF BackUp

	XREF HardwareTestGo
	XREF SectorErase
	XREF WriteFlash

;External Tones
	XREF pwr_on_tone
	XREF Ftone

;External Variables
	XREF COMMAND
	XREF COMMAND_PENDING
	XREF CONTINUOUS

	XREF ad0
	XREF ad1
	XREF ad2
	XREF ad3
	XREF ad4
	XREF ad5
	XREF ad6
	XREF ad7

	XREF TIMER
	XREF TIMER1
	XREF COUNTER

	XREF audio_state
	XREF audio_delay
	XREF audio_counter

	XREF state
	XREF state_timer

	XREF RAMIPAddress		;IP Address in RAM
	XREF RAMMAC
	XREF MAC_Address
	XREF WriteFlg
	XREF RAMEeprom			;Start of DATA to be saved

	XREF testFlag

DataSec:	SECTION

H:		ds	1		;used in binary to decimal conversion
TO:		ds	1

ad_flag:	ds	1
ad_val:		ds	2
DBUFR:		ds	5
d_flag:		ds	1

temp:		ds	2
ChangeIPFlag:	ds	1
IPAddressPtr:	ds	2
IPTemp:		ds	8

* Operational Constants

TRUE:		equ	$FF
FALSE:		equ	$00
CR:		equ	$D
LF:		equ	$A
SPACE:		equ	$20

PUPAE:		equ	%00000001		;Port A pullup
PUPBE:		equ	%00000010
PUPEE:		equ	%00010000
PUPKE:		equ	%10000000

switch:		equ	%01000000	;Port A bit 6

***************************** Program *******************************

NON_BANKED:SECTION

go_power:
	movw	#goReady,state
	movw	#122*6,state_timer
	clr	ChangeIPFlag
	ldx	#MAC_Address	    	;A dummy read to force linking

	clr	WriteFlg
	rts

loop_menu:
	ldx	state_timer
	bne	loopEx

	com	PORTG
	ldx	#M_UNDLN
	jsr	OutStr0

	movw	#1,state_timer

	ldx	#Ftone
	jsr	set_audio		;Blink/Sound LED/SPEAKER

loopEx:
	rts

goReady:
	rts

goTest
	clr	testFlag
	rts

;-----------------------------
;Choose which one to process

ProcessCommand:
	ldaa	COMMAND_PENDING         ;commands received via SCI interrupt
	lbeq	PCX

	clr	COMMAND_PENDING
	clr	CONTINUOUS
	
	ldaa	testFlag
	bne	goTest

	ldaa	COMMAND
	staa	temp

	ldab	ChangeIPFlag
	lbne	goWaitIPNumber

	anda	#$df            ;simple convert to upper case (only works for alpha char)

	cmpa	#'A'
;	lbeq	PCA

	cmpa	#'B'
;	lbeq	PCB

	cmpa	#'C'
	lbeq	PCC

	cmpa	#'E'
	lbeq	PCE

	cmpa	#'F'
	lbeq	PCF

	cmpa	#'G'
	lbeq	PCG

	cmpa	#'H'
	lbeq	PCH

	cmpa	#'J'
	lbeq	PCJ

	cmpa	#'L'
;	lbeq	PCL

	cmpa	#'M'
	lbeq	SendARPRequest

	cmpa	#'N'
	beq	ChangeIPAddress

	cmpa	#'S'
	lbeq	PCS

	cmpa	#'R'
	lbeq	PXR

	cmpa	#'T'
	lbeq	PCT

	cmpa	#'Z'
	lbeq	PCZ
	
	ldaa	temp
	cmpa	#'0'
	lblo	PPCMenu
	cmpa	#'5'
	lbhi	PPCMenu

	jsr	TogglePLine
	rts


ChangeIPAddress:
	jsr	BackUp

	movb	#1,ChangeIPFlag
	movw	#IPTemp,IPAddressPtr

;	movw	#RAMEeprom+6,IPAddressPtr	;RAMEeprom+6 = Start of the IP address in RAM

	ldx	#CurrentIPMsg
	jsr	OutStr0

	ldx	#RAMIPAddress
	ldy	#4
	jsr	DumpMACIP10

	ldx	#NewIPMsg
	jsr	OutStr0
	rts

;-----------------------------------------------------------------------------------------
goWaitIPNumber:
	ldx	IPAddressPtr
	cpx	#IPTemp+7			;Check to see if end of address

	lbne	goWaitIPNumberEx
	staa	0,x

	ldx	#IPTemp
	ldy	#RAMIPAddress

	movb	#4,DBUFR

LoopCVT:
	jsr	Dec2Hex
	dec	DBUFR
	bne	LoopCVT

	bset	SWRST,MAXRST
	brset	SWRST,MAXRST,*			;REset the EMAC

	ldx	#RAMMAC				;This MAC and IP Address save into MCHASH 
	ldy	#MCHASH				; and MACAD
	ldab	#5
	jsr	WriteBuff

	clr	ChangeIPFlag

	movw	#$45EE,BUFCFG			;1536 bytes RX/TX

;	movw	#$21FF,BUFCFG			;512 bytes RX/TX
;	movb	#$1FF,BUFCFG+1			;and BREIF, BREIE is set if over 512bytes

	movb	#$08,EPHYCTL0			;Enable Link LED and clear DIS100 and DIS10
	nop
	nop
	bset	EPHYCTL0,EPHYEN			;Enable EPHY

	bset	RXCTS,PROM			;Enable Promiscuous
	bset	NETCTL,EMACE			;Enable EMAC

	ldx	#CurrentIPMsg
	jsr	OutStr0

	ldx	#RAMIPAddress
	ldy	#4
	jsr	DumpMACIP10

	ldx	#RAMMAC				;This MAC and IP Address save into MCHASH 
	ldy	#RAMEeprom			; and MACAD
	ldab	#5
	jsr	WriteBuff

;	ldx	#RAMIPAddress				;This IP Address save into  
;	ldy	#RAMEeprom+6				; RAMEeprom+6
;	ldab	#2
;	jsr	WriteBuff

	ldx	#CrlfStr
	jsr	OutStr0	

	ldx	#RAMEeprom+6
	ldy	#4
	jsr	DumpMACIP10

	jsr	SectorErase
	jsr	WriteFlash
	rts


Dec2Hex:
	ldaa	1,x+
	staa	temp
	suba	#$30
	cmpa	#$9
	bls	NoCVT

	ldaa	temp
	anda	#$df            ;simple convert to upper case (only works for alpha char)
	suba	#$37

NoCVT:
	lsla
	lsla
	lsla
	lsla
	anda	#$F0
	staa	DBUFR+1

	ldaa	1,x+
	staa	temp
	suba	#$30
	cmpa	#$9
	bls	NoCVT10

	ldaa	temp
	anda	#$df            ;simple convert to upper case (only works for alpha char)
	suba	#$37

NoCVT10:
	adda	DBUFR+1
	staa	1,y+
	rts

goWaitIPNumberEx:
	staa	1,x+
	stx	IPAddressPtr			;Save current Address
	rts

;-----------------------------------------------------------------------------------------
SendARPRequest:
	jsr	TestARP
	rts

TestingARP:
	jsr	TestARP
	rts


TestingResponse:
	jsr	ProcessFrameBuff

;	jsr	ARPResponse
	rts
;----------------------------
;X register points to routine
;----------------------------

PCA:
        ldx     #PPCA
        jsr     0,x             ;go execute routine
        bra     PCX
PCB:
        ldx     #PPCB
        jsr     0,x             ;go execute routine
        bra     PCX

PCC:
        ldx     #PPCC
        jsr     0,x             ;go execute routine
        bra     PCX

PCE:
        ldx     #PPCE
        jsr     0,x             ;go execute routine
        bra     PCX

PCF:
        ldx     #PPCF
        jsr     0,x             ;go execute routine
        bra     PCX


PCAD:
        ldx     #PPCAD
        jsr     0,x             ;go execute routine
        bra     PCX

PCG:
        ldx     #PPCG
        jsr     0,x             ;go execute routine
        bra     PCX

PCH:
        ldx     #PPCH
        jsr     0,x             ;go execute routine
        bra     PCX

PCJ:
        ldx     #PPCJ
        jsr     0,x             ;go execute routine
        bra     PCX

PCL:
        ldx     #PPCL
        jsr     0,x             ;go execute routine
        bra     PCX

PCS:
        ldx     #PPCS
        jsr     0,x             ;go execute routine
        bra     PCX
PCT:
        ldx     #PPCT
        jsr     0,x             ;go execute routine
        bra     PCX

PCZ
        ldx     #HardwareTestGo
        jsr     0,x             ;go execute routine
        bra     PCX


PXR:
        ldx     #PPCR
        jsr     0,x             ;go execute routine
        bra     PCX

PCX:
PCXX:
        RTS
;----------------------------------------------

PPCA:
	ldx	#CrlfStr
	jsr	OutStr0	

        ldx     #M_PORTA
        jsr     OutStr0

        ldab    PORTA
        clra
        jsr     SendDecByte	;Display PORTA value

	lbra	PCXX

PPCB:
	ldx	#CrlfStr
	jsr	OutStr0	

        ldx     #M_PORTB
        jsr     OutStr0

        ldab    PORTB
        clra
        jsr     SendDecByte

	lbra	PCXX

PPCC:
	ldx	#CrlfStr
	jsr	OutStr0	

	clr	PORTG
	ldx	#M_POFF
	jsr	OutStr0

	lbra	PPCX

PPCE:
	ldx	#CrlfStr
	jsr	OutStr0	

        ldx     #M_PORTE
        jsr     OutStr0

        ldab    PORTE
        clra
        jsr     SendDecByte

	lbra	PCXX

PPCAD:
	ldx	#CrlfStr
	jsr	OutStr0	

        ldx     #M_PORTAD
        jsr     OutStr0

        ldab    PORTAD
        clra
        jsr     SendDecByte

	lbra	PCXX

PPCG:
	ldx	#CrlfStr
	jsr	OutStr0	

        ldx     #M_PORTG
        jsr     OutStr0

        ldab    PTIG
        clra
        jsr     SendDecByte

	lbra	PCXX

PPCH:
	ldx	#CrlfStr
	jsr	OutStr0	

        ldx     #M_PORTH
        jsr     OutStr0

        ldab    PTIH
        clra
        jsr     SendDecByte

	lbra	PCXX

PPCJ:
	ldx	#CrlfStr
	jsr	OutStr0	

        ldx     #M_PORTJ
        jsr     OutStr0

        ldab    PTIJ
        clra
        jsr     SendDecByte

	bra	PPCX

PPCL:
	ldx	#CrlfStr
	jsr	OutStr0	

        ldx     #M_PORTL
        jsr     OutStr0

        ldab    PTIL
        clra
        jsr     SendDecByte

	bra	PPCX

PPCS:
	ldx	#CrlfStr
	jsr	OutStr0	

        ldx     #M_PORTS
        jsr     OutStr0
        ldab    PTIS
        clra
        jsr     SendDecByte

	bra	PPCX

PPCT:
	ldx	#CrlfStr
	jsr	OutStr0	

        ldx     #M_PORTT
        jsr     OutStr0
        ldab    PTIT

        clra
        jsr     SendDecByte

	bra	PPCX

PPCMenu:
        jsr     ShowMenu
        bra     PPCX

PPCR:
        staa    CONTINUOUS      ;set continuous a/d display flag
        bra     PPCX

PPCX:
        rts


;------------------------------------------------------------------------------
PPCF:
        ldx     #M_BEEP         ;beep speaker (if connected to PP0)
        jsr     OutStr0

	ldx	#CrlfStr
	jsr	OutStr0	

        ldx	#Ftone
        jsr     set_audio

	movw	#AudioOn,audio_state
	movb	#2,audio_counter	;Flash 2 times

        rts

TogglePLine:
        ldab    #1              ;number is between 0 and 7
        suba    #'0'            ;convert ASCII digit to binary number
        beq     TBL1

TBL0:
        aslb                    ;set the appropriate mask bit
        dbne    a,TBL0

TBL1:
        bitb    PORTG           ;if designated port bit is 1
        beq     TBM1            ;  then make it 0
        comb
        bra     TBM0

TBM1:
        orab    PORTG
        stab    PORTG
        rts

TBM0:
        andb    PORTG
        stab    PORTG
        rts

;Reg y contain the port address to toggle
;Reg b contain the the toggle bit

toggle_port:
        movb    #6,COUNTER
        ldab    #%01

toggle:
        stab    0,y
        stab    0,x

        movw    #120,TIMER
        jsr     wait

        lslb
        dec     COUNTER
        bne     toggle
        rts

wait:
        pshx
        pshy

wt:
        ldx     TIMER
        bne     wt
        puly
        pulx
        rts

;-----------------------------------------------------------------------------
ShowMenu:
        ldx     #M_UNDLN
        jsr     OutStr0

Show_Prompt:
        ldx     #M_PROMPT
        jsr     OutStr0
        rts

ShowAnalog:
	inc	d_flag
	sei

	ldaa	#SPACE
	jsr	SerOutput0

	ldx	#M_AD0
	jsr	OutStr0
	ldx	#ad0
	jsr	HTOD
	jsr	P1K
	ldaa	#SPACE
	jsr	SerOutput0
	ldx	#M_AD1
	jsr	OutStr0
	ldx	#ad1
	jsr	HTOD
	jsr	P1K
	ldaa	#SPACE
	jsr	SerOutput0
	ldaa	#SPACE
	jsr	SerOutput0

	ldx	#M_AD2
	jsr	OutStr0
	ldx	#ad2
	jsr	HTOD
	jsr	P1K
	ldaa	#SPACE
	jsr	SerOutput0
	ldaa	#SPACE
	jsr	SerOutput0

	ldx	#M_AD3
	jsr	OutStr0
	ldx	#ad3
	jsr	HTOD
	jsr	P1K
	ldaa	#SPACE
	jsr	SerOutput0
	ldaa	#SPACE
	jsr	SerOutput0

	ldx	#M_AD4
	jsr	OutStr0
	ldx	#ad4
	jsr	HTOD
	jsr	P1K
	ldaa	#SPACE
	jsr	SerOutput0
	ldaa	#SPACE
	jsr	SerOutput0

	ldx	#M_AD5
	jsr	OutStr0
	ldx	#ad5
	jsr	HTOD
	jsr	P1K
	ldaa	#SPACE
	jsr	SerOutput0

	ldaa	#SPACE
	jsr	SerOutput0

	ldx	#M_AD6
	jsr	OutStr0
	ldx	#ad6
	jsr	HTOD
	jsr	P1K
	ldaa	#SPACE
	jsr	SerOutput0

	ldaa	#SPACE
	jsr	SerOutput0

	ldx	#M_AD7
	jsr	OutStr0
	ldx	#ad7
	jsr	HTOD
	jsr	P1K
	ldaa	#SPACE
	jsr	SerOutput0

	cli
	clr	d_flag

	ldaa	#CR
	jsr	SerOutput0
	rts

;------------------------------------------------------------------------------
HexByte2Dec:

*               Supply hex value to be converted in B register
        clra
        ldx     #100    ;numerator in D, denominator in X
        idiv
*               remainder in D, quotient in X
*               B is lo-order byte
        xgdx
        stab    H       ;8 bit quotient in B
        xgdx
        ldx     #10     ;H=0X  TO=packed BCD
        idiv
        stab    TO
        xgdx
        aslb
        aslb
        aslb
        aslb
        orab    TO
        stab    TO
        rts

SendDecByte:

* value is in B

        clra
        jsr     HexByte2Dec
        ldaa    H
        adda    #'0'
        jsr     SerOutput0
        ldaa    TO
        jsr     SendASCIIHex
        rts

SendASCIIHex:
*       value in A

        psha
        anda    #$F0
        lsra
        lsra
        lsra
        lsra
        cmpa    #$A
        blt     SAH1
        suba    #$A
        adda    #'A'
        bra     SAH2

SAH1:
        adda    #'0'

SAH2:
        jsr     SerOutput0
        pula
        psha
        anda    #$0F
        cmpa    #$A
        blt     SAH3
        suba    #$A
        adda    #'A'
        bra     SAH4

SAH3:
        adda    #'0'

SAH4:
        jsr     SerOutput0
        pula
        rts



;==============================================================================
;-----------------------------------------------------------------------------
;HTOD-SUBROUTINE TO CONVERT A 16-BIT HEX NUMBER TO A 5 DIGIT DECIMAL
;This routine is taken from the HC11 manual.
;D=HEX VALUE TO BE CONVERTED
;X=ADDRESS WHERE THE NUMBER IS STORED TO BE CONVERTED

HTOD:
	LDD	0,X             ;
	LDX	#10000
	IDIV	
	XGDX
	ADDB	#$30
	STAB	DBUFR
	XGDX
	LDX	#1000
	IDIV
	XGDX
	ADDB	#$30
	STAB	DBUFR+1
	XGDX
	LDX	#100
	IDIV
	XGDX
	ADDB	#$30
	STAB	DBUFR+2
	XGDX
	LDX	#10
	IDIV
	ADDB	#$30
	STAB	DBUFR+4
	XGDX
	ADDB	#$30
	STAB	DBUFR+3
	LDX	#DBUFR+1        ;POINT AT DECIMAL
	rts

P5DEC:
	LDX	#DBUFR          ;POINT AT DECIMAL
	LDAA	#$30            ;CHECK FOR LEADING ZEROS
	CMPA	0,X             ;CHECK FOR 10,000S DIGIT

	BNE	P10K            ;START AT 10K DIGIT
	BSR	SKP1            ;INX AND PRINT A SPACE
	CMPA	0,X             ;CHECK FOR 1,000S

	BNE	P1K             ;START AT 1K DIGIT
	BSR	SKP1
	BSR	SKP1
	DEX
	CMPA	0,X             ;CHECK FOR 100S DIGIT

	BNE	P100            ;START AT 100 DIGIT
	BSR	SKP1
	CMPA	0,X             ;CHECK 10S DIGIT

	BNE	P10
	BSR	SKP1
	BRA	P1              ;START AT 1S DIGIT

P10K:
	LDAA	0,X             ;10,000 DIGIT
	PSHX
	jsr	SerOutput0
	PULX
	INX

P1K:
	LDAA	0,X
	PSHX
	jsr	SerOutput0
	PULX
	INX

P100:
	LDAA	0,X
	PSHX
	jsr	SerOutput0
	PULX
	INX

P10:
	LDAA	0,X
	PSHX
	jsr	SerOutput0
        	PULX
	INX

P1:
	LDAA	0,X
	jsr	SerOutput0
	RTS

SKP1:
	PSHA
	INX
	LDAA	#$20
	jsr	SerOutput0
	PULA
	RTS



;==============================================================================

*******************************************************************************
* Messages

M_UNDLN:		dc.b	$D,$A,$D,$A
M_HEADER:	dc.b	' Adapt9S12NE64 LAN DEMO PROGRAM COMMAND MENU V1.00',$D,$A
		dc.b	'_________________________________________________',$D,$A
		dc.b	$D,$A

;		dc.b	'A => SHOW PORT A STATUS',$D,$A
;		dc.b	'B => SHOW PORT B STATUS',$D,$A

		dc.b	'C => CLEAR PORT G OUTPUTS',$D,$A
		dc.b	'E => SHOW PORT E STATUS',$D,$A
		dc.b	'F => FLASH LED (CONNECT TO PH4)',$D,$A
		dc.b	'G => SHOW PORT G STATUS',$D,$A
		dc.b	'H => SHOW PORT H STATUS',$D,$A
		dc.b	'J => SHOW PORT J STATUS',$D,$A

;		dc.b	'L => SHOW PORT L STATUS',$D,$A

		dc.b	'S => SHOW PORT S STATUS',$D,$A
		dc.b	'T => SHOW PORT T STATUS',$D,$A
		dc.b	'M => Send ARP Request',$D,$A
		dc.b	'N => Change IP Address',$D,$A

		dc.b	'R => SHOW 10-bit REAL-TIME ANALOG VALUES',$D,$A
		dc.b	'0 TO 5 => TOGGLE THE SELECTED G PORT LINE',$D,$A,0

M_PROMPT:	dc.b	'?',0
CrlfStr:		dc.b	$0a,$0d,$0

M_AD0:		dc.b	'AD0=',0
M_AD1:		dc.b	'AD1=',0
M_AD2:		dc.b	'AD2=',0
M_AD3:		dc.b	'AD3=',0
M_AD4:		dc.b	'AD4=',0
M_AD5:		dc.b	'AD5=',0
M_AD6:		dc.b	'AD6=',0
M_AD7:		dc.b	'AD7=',0

M_PORTA:	dc.b	'PORTA=',0
M_PORTB:	dc.b	'PORTB=',0
M_PORTE:	dc.b	'PORTE=',0

M_PORTG:	dc.b	'PORTG=',0
M_PORTH:	dc.b	'PORTH=',0
M_PORTJ:	dc.b	'PORTJ=',0
M_PORTL:	dc.b	'PORTL=',0
M_PORTS:	dc.b	'PORTS=',0
M_PORTT:	dc.b	'PORTT=',0


M_PORTAD:	dc.b	'PTAD=',0

M_POFF:	dc.b	'PORT G CLEARED',0
M_BEEP:	dc.b	'>>> LED FLASH! <<<',0

CurrentIPMsg:	dc.b	$0a,$0d,'Current IP Address = ',0
NewIPMsg:	dc.b	$0a,$0d,'New IP Address (XX-XX-XX-XX) = ',0

	END


