;Telnet.asm
*******************************************************************************
*REVISION HISTORY:
*
*DATE			REV. NO.	DESCRIPTION
*
*August 15, 2005	1.00		Initial release
*
*
*Author: Exequiel Rarama for the Adapt9S12NE64
*******************************************************************************
;Assembled using CW
;
; ---------------------------
; Demo - Telnet Routine
; ---------------------------

	include "NE64Regs.INC"
	include "PacketFrame.inc"

;Public Function

	XDEF CheckTelnet


;Public Variables
	XDEF SessionFlag

;External Messages
	XREF CurrentIPMsg

;External Function
	XREF SerOutput0
	XREF OutStr0	

	XREF Dump_word
	XREF Dump_byte

	XREF RXABFlag

	XREF CalCRC
	XREF WriteBuff
	XREF CalAddOffset

	XREF ProcessTCP
	XREF CheckWhichRXBuff
	XREF ProcessFrameBuff
	XREF CopyMSG

	XREF DoTCP1
	XREF DoTCP2
;	XREF DoTCP2Session

	XREF DoTCP3
	XREF DoTCP4
	XREF DoTCP5

;------------------------------------------------------------------------------------------------------
;External Variables

	XREF PacketBasePtr
	XREF RAMMAC

	XREF LANState
	XREF TXWriteLen
	XREF CharCounter
	XREF RAMIPAddress
	XREF TCPIPFlag

DataSec:	SECTION

TelnetSocket:	ds.b	2*10			;10 sockets
TelnetSockPtr:	ds.b	2

TelnetState:	ds.b	2
TelnetFlag:	ds.b	1
SessionFlag:	ds.b	1

WaitAckFlg:	ds.b	1			;This flag is set if waiting for an ACK
temp:		ds.b	1

;------------------------------------------------------------------------------------------------------
NON_BANKED:SECTION

TelnetInit:
	movw	#CheckTelnet,TelnetState
	clr	TelnetFlag
	rts

CheckTelnet:
	ldd	PacketBasePtr
	addd	#TCPFlags
	xgdx
	ldaa	0,x

	cmpa	#SYN
	lbeq	TelnetSYN			;Trying to Synchronize

	cmpa	#ACK				;Only ACK, okay to send new DATA
	lbeq	TelnetACK

	cmpa	#ACK+PSH			;ACK and PSH, okay to send new DATA
	lbeq	TelnetPSHACK

	cmpa	#ACK+PSH+FIN			;ACK, PSH, FIN 
	lbeq	TelnetFIN			;Send End of Session

	cmpa	#ACK+FIN			;ACK, FIN 
	lbeq	TelnetFIN			;Send End of Session

	cmpa	#RST        			;If reset then end session
;	lbeq	TelnetRST			;Send End of Session
	lbeq	ClearRXABuff			;Do not send a response otherwise Infinitely loop

	cmpa	#RST+ACK       			;If reset then end session
;	lbeq	TelnetRST			;Send End of Session
	lbeq	ClearRXABuff			;Do not send a response otherwise Infinitely loop

ClearRXABuff:
	ldaa	RXABFlag			;Check which buffer
	bne	ClearRXBBuff

	bset	IEVENT,RXACIF			;clear Flag for next RX
	bra	CheckTelnetEx

ClearRXBBuff:
	bset	IEVENT,RXBCIF			;clear Flag for next RX
						;If gets here then clear RXbuffer
CheckTelnetEx:
	movw	#ProcessFrameBuff,LANState	;go back to polling Frame buffer
	clr	TCPIPFlag
	rts


TelnetSYN:
	clr	TelnetFlag
	movw	#goTelnetSYN,LANState
	rts

TelnetACK:
	clr	TelnetFlag
	movw	#goTelnetACK,LANState
	rts

TelnetPSHACK:
	clr	TelnetFlag
	movw	#goTelnetPSHACK,LANState
	rts

TelnetFIN:
	clr	TelnetFlag
	movw	#goTelnetFIN,LANState
	rts

TelnetRST:
	clr	TelnetFlag
	movw	#goTelnetRST,LANState
	rts


;---------------------------------------------------------------------------------------------
goTelnetSYN:
	movb	#1,TCPIPFlag

	ldx	#TCP0Msg
	jsr	OutStr0

	movw	#$0000,CharCounter		;Initialize Character Counter

	ldd	PacketBasePtr
	addd	#IPPacketLength
	xgdx

	ldd	#$002C				;IP (= 20bytes) + TCP (= 24bytes)
	std	0,x
	addd	#14				;Header = DA + SA + Ethertype (= 14bytes)
	std	TXWriteLen

	ldd	PacketBasePtr
	addd	#IPChecksum			;Initialize IP checksum to 0
	xgdx
	movw	#00,0,x	

	clr	SessionFlag			;Make sure to increment 

	jsr	TelnetIP
	jsr	ProcessTCP
	jsr	DoTCP1

	jsr	CheckWhichRXBuff
	movw	#ProcessFrameBuff,LANState	;go back to polling Frame buffer

	movb	#1,SessionFlag	;*****		;We have a telnet session

	clr	WaitAckFlg			;Make sure to clear this flag for SYN
	clr	TCPIPFlag
	clr	WaitAckFlg

	rts

;--------------------------------------------------------------------------------------------
goTelnetACK:
	movb	#1,TCPIPFlag

	ldx	#TCP1Msg
	jsr	OutStr0

	ldaa	SessionFlag	;****
	cmpa	#2		;****
	beq	YesWaitAck

	movw	#$0000,CharCounter		;Initialize Character Counter

	ldd	PacketBasePtr
	addd	#TCPPadding			;Start of Data to be written to
	xgdy
	
	ldx	#TestTelnetMsg
	jsr	CopyMSG

	ldd	PacketBasePtr
	addd	#IPPacketLength
	xgdx

	ldd	#$0028				;IP (= 20bytes) + TCP (= 20bytes) = 40bytes
	addd	CharCounter
	std	0,x

	addd	#14				;Header = DA + SA + Ethertype (= 14bytes)
	std	TXWriteLen

	jsr	TelnetIP
	jsr	ProcessTCP

	jsr	DoTCP2

	movb	#2,SessionFlag	;*****		;We have a telnet session

	jsr	CheckWhichRXBuff
	movw	#ProcessFrameBuff,LANState	;go back to polling Frame buffer
	inc	WaitAckFlg				;Sent a Package - now wait for ACK
	clr	TCPIPFlag
	rts

;-----------------------------------------------------------------------------------------
YesWaitAck:
	clr	WaitAckFlg
	jsr	ClearRXABuff
	rts

;-----------------------------------------------------------------------------------------
goTelnetPSHACK:
	movb	#1,TCPIPFlag

	ldd	PacketBasePtr
	addd	#IPPacketLength
	xgdy	
	ldd	0,y

	cpd	#$37				;Is it $37 bytes long
	beq	goTelnetPSHACKEx

	cpd	#40				;Is it 40 bytes long
	beq	goTelnetPSHACKEx	
	bra	ProcessECommand			;Go processed command 


goTelnetPSHACKEx:				;<<<original
	ldx	#ACKPSHMsg
	jsr	OutStr0

	ldd	PacketBasePtr
	ldy	#TCPPadding
	jsr	CalAddOffset			;Calculate address offset
	ldx	#PSHACKMsg	
	ldd	#3
	jsr	WriteBuff

	movw	#0006,CharCounter		;6 bytes of NULL value
;	movw	#0000,CharCounter		;No data transmitted

	ldd	PacketBasePtr
	addd	#IPPacketLength
	xgdx

	ldd	#$0028				;IP (= 20bytes) + TCP (= 20bytes) = 40bytes
	addd	CharCounter
	std	0,x

	addd	#14				;Header = DA + SA + Ethertype (= 14bytes)
	std	TXWriteLen

	jsr	TelnetIP
	jsr	ProcessTCP
;	jsr	TelnetTCP
	jsr	DoTCP3

	jsr	CheckWhichRXBuff
	movw	#ProcessFrameBuff,LANState	;go back to polling Frame buffer

	movb	#2,SessionFlag	;*****		;We have a telnet session
	inc	WaitAckFlg				;Sent a Package - now wait for ACK
	clr	TCPIPFlag
	rts

;------------------------------------------------------------------------------------------
ProcessECommand:
	ldd	PacketBasePtr
	addd	#$45				;check command type
	xgdy
	ldaa	0,y
	staa	temp

	jsr	Dump_byte

	ldaa	temp
	anda	#$df            ;simple convert to upper case (only works for alpha char)

	cmpa	#'A'
	lbeq	PCA

NoCommand:
	jmp	goTelnetPSHACKEx

PCA:
	movw	#$0000,CharCounter		;Initialize Character Counter

	ldd	PacketBasePtr
	addd	#TCPPadding			;Start of Data to be written to
	xgdy
	
	ldx	#M_PORTA
	jsr	CopyMSG	

	jmp	SendProcessedData


;------------------------------------------------------------------------------------------
SendProcessedData:
	ldd	PacketBasePtr
	addd	#IPPacketLength
	xgdx

	ldd	#$0028				;IP (= 20bytes) + TCP (= 20bytes) = 40bytes
	addd	CharCounter
	std	0,x

	addd	#14				;Header = DA + SA + Ethertype (= 14bytes)
	std	TXWriteLen

	jsr	TelnetIP
	jsr	ProcessTCP
	jsr	DoTCP2

	jsr	CheckWhichRXBuff
	movw	#ProcessFrameBuff,LANState	;go back to polling Frame buffer

	movb	#2,SessionFlag	;*****		;We have a telnet session
	inc	WaitAckFlg				;Sent a Package - now wait for ACK
	clr	TCPIPFlag
	rts


;--------------------------------------------------------------------------------------------
goTelnetFIN:
	movb	#1,TCPIPFlag ;******
	clr	SessionFlag		;make the seq is incremented

	ldx	#FINMsg
	jsr	OutStr0

	ldd	PacketBasePtr
	ldy	#TCPPadding
	jsr	CalAddOffset			;Calculate address offset
	ldx	#PSHACKMsg	
	ldd	#3
	jsr	WriteBuff

	movw	#0006,CharCounter			;6 bytes of NULL value

	ldd	PacketBasePtr
	addd	#IPPacketLength
	xgdx

	ldd	#$0028				;IP (= 20bytes) + TCP (= 20bytes) = 40bytes
	addd	CharCounter
	std	0,x

	addd	#14				;Header = DA + SA + Ethertype (= 14bytes)
	std	TXWriteLen

	jsr	TelnetIP
	jsr	ProcessTCP
;	jsr	TelnetTCP
	jsr	DoTCP4

	jsr	CheckWhichRXBuff
	movw	#ProcessFrameBuff,LANState	;go back to polling Frame buffer

;	inc	WaitAckFlg				;Sent a Package - now wait for ACK
	clr	TCPIPFlag
	rts

;--------------------------------------------------------------------------------------------
goTelnetRST:
	movb	#1,TCPIPFlag	;*****

	ldx	#RSTMsg
	jsr	OutStr0

	ldd	PacketBasePtr
	ldy	#TCPPadding
	jsr	CalAddOffset			;Calculate address offset
	ldx	#PSHACKMsg	
	ldd	#3
	jsr	WriteBuff

	movw	#0006,CharCounter			;6 bytes of NULL value

	ldd	PacketBasePtr
	addd	#IPPacketLength
	xgdx

	ldd	#$0028				;IP (= 20bytes) + TCP (= 20bytes) = 40bytes
	addd	CharCounter
	std	0,x

	addd	#14				;Header = DA + SA + Ethertype (= 14bytes)
	std	TXWriteLen

	jsr	TelnetIP
	jsr	ProcessTCP
;	jsr	TelnetTCP
	jsr	DoTCP5

	jsr	CheckWhichRXBuff
	movw	#ProcessFrameBuff,LANState	;go back to polling Frame buffer

;	inc	WaitAckFlg				;Sent a Package - now wait for ACK
	clr	TCPIPFlag

	rts

;--------------------------------------------------------------------------------------------
TelnetIP:
	ldd	PacketBasePtr
	addd	#IPChecksum			;Initialize IP checksum to 0
	xgdx
	movw	#00,0,x	

	ldd	PacketBasePtr
	ldx	#IPSourceAddress		;Copy original source IP to Destination IP
	ldy	#IPDestinationAddress
	jsr	CalAddOffset			;Calculate address offset
	ldd	#2
	jsr	WriteBuff

	ldd	PacketBasePtr
	ldy	#IPSourceAddress
	jsr	CalAddOffset			;Calculate address offset
	ldx	#RAMIPAddress			;our IP Address as source 
	ldd	#2
	jsr	WriteBuff

;****
	ldd	PacketBasePtr
	ldx	#packetSource			;Move original MAC address source as MAC address destination 
	ldy	#packetDestination
	jsr	CalAddOffset			;Calculate address offset
	ldd	#3
	jsr	WriteBuff

	ldd	PacketBasePtr
	ldy	#packetSource
	jsr	CalAddOffset			;Calculate address offset
	ldx	#RAMMAC				;Move our MAC address to source
	ldd	#3
	jsr	WriteBuff

	ldd	PacketBasePtr
	ldx	#IPVersion			;Start of DATA to added
	jsr	CalAddOffset			;Calculate address offset
	ldy	#20/2
	jsr	CalCRC				;Go calculate CRC
	coma
	comb
	xgdy					;Save Reg D in Y
	ldd	PacketBasePtr
	addd	#IPChecksum
	xgdy					;Restore D, Y = IPChecksum
	std	0,y				;Save Checksum into memory

;Calculate Checksum by the amount in Reg Y
	ldd	PacketBasePtr
	addd	#IPPacketLength			;Get packet length in IP header
	xgdy
	ldd	0,y
	subd	#20
	lsrd					;divide by 2
	xgdy					;Result now in Reg Y

	ldd	PacketBasePtr
	addd	#IPData				
	xgdx					;Start of Data in X
	jsr	CalCRC
	coma
	comb
	xgdx					;Save checksum and exchange with reg X
	rts

;-------------------------------------------------------------------------------------------------------
TCP0Msg:	dc.b	$0d,$0a,'Begin TCP Session',$0d,$0a,$0	
TCP1Msg:	dc.b	$0d,$0a,'1st Process ',$0d,$0a,$0	
TCP2Msg:	dc.b	$0d,$0a,'2nd Process ',$0d,$0a,$0	
TCP3Msg:	dc.b	$0d,$0a,'3rd Process ',$0d,$0a,$0	
TCP4Msg:	dc.b	$0d,$0a,'Calculating CRC ',$0d,$0a,$0


ACKPSHMsg:	dc.b	$0d,$0a,'PSHACK Telnet',$0d,$0a,$0	
FINMsg:		dc.b	$0d,$0a,'End Telnet Session',$0d,$0a,$0	
SYNMsg:		dc.b	$0d,$0a,'Telset SYN',$0d,$0a,$0	
RSTMsg:		dc.b	$0d,$0a,'Telset RESETTING',$0d,$0a,$0	

EXOPL:		equ	255
DO:		equ	253
WILL:		equ	251
ECHO:		equ	1

TestTelnetMsg:	dc.b	$0d,$0a
		dc.b	'-----------------------------',$0d,$0a
		dc.b	'Welcome to Technological Arts',$0d,$0a
		dc.b	'      Test Version 1.00',$0d,$0a
		dc.b	$0d,$0a
;		dc.b	EXOPL,WILL,ECHO,0

EMenuMsg:	dc.b	' 9S12NE64 EDEMO PROGRAM COMMAND MENU V1.00',$0d,$0a
		dc.b	'__________________________________________',$0d,$0a

		dc.b	$0d,$0a

		dc.b	'A => SHOW PORT A STATUS',$0d,$0a
		dc.b	'B => SHOW PORT B STATUS',$0d,$0a
		dc.b	'C => CLEAR PORT G OUTPUTS',$0d,$0a
		dc.b	'E => SHOW PORT E STATUS',$0d,$0a
		dc.b	'F => FLASH LED',$0d,$0a
		dc.b	'G => SHOW PORT G STATUS',$0d,$0a
		dc.b	'H => SHOW PORT H STATUS',$0d,$0a
		dc.b	'J => SHOW PORT J STATUS',$0d,$0a
		dc.b	'L => SHOW PORT L STATUS',$0d,$0a
		dc.b	'S => SHOW PORT S STATUS',$0d,$0a
		dc.b	'T => SHOW PORT T STATUS',$0d,$0a
		dc.b	'M => Send ARP Request',$0d,$0a
;		dc.b	'N => Change IP Address                   ',$0d,$0a

		dc.b	'R => SHOW 10-bit REAL-TIME ANALOG VALUES',$0d,$0a
		dc.b	'0 TO 5 => TOGGLE THE SELECTED G PORT LINE',$0d,$0a

E_PROMPT:	dc.b	'?'
		dc.b	EXOPL,WILL,ECHO,0

CrlfStr:		dc.b	$0a,$0d,$0
endhere:		equ	*-TestTelnetMsg

PSHACKMsg:	dc.w	$0000,$0000,$0000


M_PORTA:	dc.b	$0a,$0d,'PORTA ='
		dc.b	EXOPL,WILL,ECHO,0

M_PORTB:	dc.b	'PORTB=',0
M_PORTE:	dc.b	'PORTE=',0

M_PORTG:	dc.b	'PORTG=',0
M_PORTH:	dc.b	'PORTH=',0
M_PORTJ:	dc.b	'PORTJ=',0
M_PORTL:	dc.b	'PORTL=',0
M_PORTS:	dc.b	'PORTS=',0
M_PORTT:	dc.b	'PORTT=',0

	END

