;AUDIO.ASM
*******************************************************************************
*Description:  Part of Demo program for Adapt9S12XEP100
*Author: Carl Barnes
*Derived from Adapt98S12XDP512 demo written by Exequiel Rarama
*
*REVISION HISTORY:
*
*DATE                   REV. NO.        DESCRIPTION
*
*June 11, 2014           Beta       Audio not working; needs adjustment for 4MHz crystal
*
*******************************************************************************
;Assembled using CW5.1
;
;Port P, bit 7 is used to drive the LED.
;The port pin will toggle on compare.
;
; ---------------------------
; Demo - Audio Routine
; ---------------------------

; include derivative specific macros
        INCLUDE 'derivative.inc'

;Public Function
	XDEF audio_init
	XDEF do_4_BEEPS
	XDEF OC6Int
	XDEF audio_int
	XDEF PulseXToneB

;External Variables
	XREF TIMER
	XREF TIMER1	


;variable/data section
MY_EXTENDED_RAM:SECTION

DURATION        ds     2       ;used for tone generation
HALF_PERIOD     ds     2


;------------------------------------------------------------------------------
TONE_2K         equ     500     ;frequencies in Hertz for tone generation
TONE_1K         equ     1000
TONE_440        equ     2272
TONE_220        equ     4545
TONE_180        equ     3000
TONE_110        equ     9090
TONE_60         equ     16666

OC6mask1        equ     %01000000       ;IOS6 = 1, Bit 6 as output compare
OC6mask2        equ     %01000000       ;C6I = 1, Enable Interrupt
OC6mask3        equ     %00010000       ;OM6 = 0, OL6 = 1, toggel OC output line
OC6flag         equ     %01000000       ;C6F = 1 to clear Interrupt flag

Audio           equ     %10000000       ;Port P bit 7

_100MS          equ     25
_250MS          equ     61
_500MS          equ     125
_1SECOND        equ     250
_2SECONDS       equ     500
_3SECONDS       equ     750
_5SECONDS       equ     1250
_10SECONDS      equ     2500
_25SECONDS      equ     6250
_60SECONDS      equ     15000
_2MIN           equ     30000

***************************** Program *******************************

; code section
NON_BANKED:SECTION

;Initialize PORTT bit 6 as output compare
audio_init
	bset	ECT_TSCR1,mECT_TSCR1_TEN		;TEN=1 - Enable timer
	bset	ECT_TIOS,mECT_TIOS_IOS6		;Bit 6 of PORTT used as Audio timer

;Initialize PORTP bit 7
	bset	DDRP,Audio		;Bit 7 of PORTP is Speaker Output

	movb	#mECT_DLYCT_DLY0,ECT_DLYCT	;Delay Counter Select = 26 Bus clock cycle
	bset	ECT_TIE,mECT_TIE_C6I		;enable OC6 interrupt  ***
	bset	ECT_TFLG1,mECT_TFLG1_C6F		;clear flag	      **

	rts
 
;-----------------------
do_4_BEEPS
	ldx	#TONE_440		;generate two 100 millisecond beeps @ 440 Hz
	ldab	#$4			; (connect speaker to PP7)

	ldy	#_100MS
	bsr	PulseXToneB		;power tones
	rts

WaitX
	stx	TIMER1		;delays a length of time defined by x

W1
	ldx	TIMER1		; (note that whenever TIMER1 is non-zero,
	bne	W1		; it is decremented in the RTI interrupt
	rts			; service routine)

;-------------------------------------------------------------------------------
PulseXToneB

* b contains number of beeps desired
* x contains tone frequency
* y contains tone duration (eg. if y=1  => duration=4.1 ms; y=255 => 1 sec)

	sty	DURATION

rpt
	bsr	EnableToneX     ;tone generated via OutputCompare feature
	movw	DURATION,TIMER

d2_1
	ldy	TIMER
	bne	d2_1

	bclr	PTP,Audio     ;Disable audio
	bclr	ECT_TIE,mECT_TIE_C6I ;turn off tone
	bclr	ECT_TFLG1,mECT_TFLG1_C6F

	movw	DURATION,TIMER

d2_2
	ldy	TIMER
	bne	d2_2
	dbne	b,rpt
	rts

EnableToneX
	sei                     ;tone generation done via OutputCompare
	stx	HALF_PERIOD

	bset	PTP,Audio         ;Enable
	bset	ECT_TIE,mECT_TIE_C6I     ;enable OC6 interrupt
	bset	ECT_TFLG1,mECT_TFLG1_C6F   ;clear flag
	cli
	rts

;------------------------------------------------------------------------------
; Audio Interrupt Routine
; -----------------------
OC6Int
audio_int
	ldd   HALF_PERIOD
	addd	ECT_TC6
	std	  ECT_TC6

	brclr	PTP,Audio,audio10
	bclr	PTP,Audio
	bra	audio20

audio10
	bset	PTP,Audio		;Enable audio

audio20
	movb	#%01000000,ECT_TFLG1	;clear flag
	rti
