;INT.ASM
*******************************************************************************
*Description:  Part of Demo program for Adapt9S12XEP100
*Author: Carl Barnes
*Derived from Adapt98S12XDP512 demo written by Exequiel Rarama
*
*REVISION HISTORY:
*
*DATE                   REV. NO.        DESCRIPTION
*
*June 11, 2014           Beta       Audio not working; needs adjustment for 4MHz crystal
*
*******************************************************************************
;Assembled using CW5.1
;
; ---------------------------
; Demo - ISR Routine
; ---------------------------

  INCLUDE 'derivative.inc'


;Public Function
	XDEF RealTimeInit
	XDEF RealTimeInt

	XDEF OutStr0
	XDEF SerOutput0
	XDEF SerInputInt0

;Public Variables
	XDEF ad0
	XDEF ad1
	XDEF ad2
	XDEF ad3
	XDEF ad4
	XDEF ad5
	XDEF ad6
	XDEF ad7

	XDEF TIMER
	XDEF TIMER1
	XDEF COUNTER
	
;External Variables
	XREF d_flag

	XREF COMMAND
	XREF COMMAND_PENDING
	XREF CONTINUOUS

; variable/data section
MY_EXTENDED_RAM:SECTION

;ATD ram variables
atd_var

ad0             ds     2
ad1             ds     2
ad2             ds     2
ad3             ds     2
ad4             ds     2
ad5             ds     2
ad6             ds     2
ad7             ds     2

TIMER           ds     2       ;software timers using RTI
TIMER1          ds     2
COUNTER         ds     1

;------------------------------------------------------------------------------
;ATD Variables
admask2         equ     %11000000       ;AFFC,ADPU=1 - Enable Analog to Digital
admask3         equ     %00000000       ;FRZ1,FRZ0=0
admask4         equ     %10000001       ;SMP1,SMP0 = 0; S10BM,PRS0=1 - Select Sample time adn Bit mode
admask5         equ     %01110000       ;S8CM = 1, SCAN = 1, MULT = 1
SCFflag         equ     %10000000       ;SCF - Sequence Complete flag

;RTI Variables
clrmask         equ     %11000000       ;mask for clearing timer flags
;revise these to reflect 4MHz crystal
rtimask1        equ     %00000001       ;M=8Mhz, 1.024 msec interrupt with 16 MHz xtal
rtimask2        equ     %00000010       ;M=8Mhz, 2.048 msec interrupt with 16 MHz xtal
rtimask3        equ     %00000011       ;M=8Mhz, 4.096 msec interrupt with 16 MHz xtal
rtimask4        equ     %00000100       ;M=8Mhz, 8.196 msec interrupt with 16 MHz xtal
rtimask5        equ     %00000101       ;M=8Mhz, 16.384 msec interrupt with 16 MHz xtal
rtimask6        equ     %00000110       ;M=8Mhz, 32.768 msec interrupt with 16 MHz xtal
rtimask7        equ     %00000111       ;M=8Mhz, 65.536 msec interrupt with 16 MHz xtal
rtimask8        equ     %00001000       ;M=8Mhz, 1.024 msec interrupt with 16 MHz xtal
rtimask9        equ     %00001010       ;M=8Mhz, 2.048 msec interrupt with 16 MHz xtal
rtimask10       equ     %00001011       ;M=8Mhz, 4.096 msec interrupt with 16 MHz xtal
rtimask11       equ     %00001100       ;M=8Mhz, 8.196 msec interrupt with 16 MHz xtal
rtimask12       equ     %00001101       ;M=8Mhz, 16.384 msec interrupt with 16 MHz xtal
rtimask13       equ     %00001110       ;M=8Mhz, 32.768 msec interrupt with 16 MHz xtal
rtimask14       equ     %00001111       ;M=8Mhz, 65.536 msec interrupt with 16 MHz xtal

rtimask15       equ     %01110000       ;M=8Mhz, 65.536 msec interrupt with 16 MHz xtal

RTIF		equ	%10000000
RTIE		equ	%10000000

;SCI Variables
scimask         equ     %00101100       ;RIE - SCI Interrupt enable
                                        ;RE - Receiver Enable
RDRFflag        equ     %00100000       ;RDRF - Receive Data Register Full flag
TDREflag        equ     %10000000       ;TDRE - Transmit Data Register Empty flag

;Baud rate definitions
;=> revise these to reflect 4MHz crystal
OscFreq		equ	4000	;Enter Osc speed
initSYNR	equ	9		; mult by synr + 1 = 10 (40MHz)
initREFDV	equ	$00		;

BusFreq		equ	((OscFreq/(initREFDV+1))*(initSYNR+1))
baud115200	equ	(BusFreq/16)*10/1152  			;sets baud rate to 115,200
baud9600	equ	(BusFreq/16)*10/96  			;sets baud rate to 009,600

* Operational Constants

TRUE      equ $FF
FALSE     equ $00
CR        equ $D
LF        equ $A
SPACE     equ $20

TCIE		  equ	$40
RIE		    equ	$20
ILIE		  equ	$10
TE		    equ	$08
RE	      equ	$04
RWU		    equ	$02
SBK		    equ	$01

;------------------------------------------------------------------------------
; code section
NON_BANKED:SECTION

RealTimeInit				      ;Initialize Real Time Interrupt
	movb	#rtimask15,RTICTL	;and initialize RTI rate
	bset	CRGFLG,RTIF		    ;clear flag
	bset	CRGINT,RTIE		    ;Enable RTI

;Initialize Analog To Digital
	movb	#$80,ATD0CTL2	    ;enable ATD
	movb	#$40,ATD0CTL3
	movb	#$60,ATD0CTL4		  ;Select Sample rate
	movb	#$B0,ATD0CTL5		  ;Select 8 channel mode, Continuous scan

;
;Initialize primary Serial Communication Interface
;
	movb	#0,SCI0BDH
	movb	#baud115200,SCI0BDL	;baud = 9600
	movb	#0,SCI0CR1
	movb	#TE+RE+RIE,SCI0CR2	;RIE, RE and TE on

PeriodicTimer

	movb	#%00000001,PITCE	;Turn On PIT0
	movb	#%00000001,PITFLT	;Load timer value

	movb	#$10,PITMTLD0
	movb	#$10,PITMTLD1
	movw	#$1000,PITLD0

	movb	#%10000011,PITCFLMT	;Enable PIT
	movb	#%00000001,PITINTE	;Enable PIT0 Interrupt

	rts

PTIInt
	com	PTP
	movb	#%00000001,PITTF	;Clear Interrupt
	rti

;------------------------------------------------------------------------------
* Real-time Interrupt Routine

RealTimeInt
	cli				; so that other interrupts can be serviced

RTI_1
	ldx	TIMER
	beq	RTI_2
	dex
	stx	TIMER

RTI_2
	ldx	TIMER1
	beq	RTI_3
	dex
	stx	TIMER1

RTI_3
	ldaa	d_flag
	bne	RTI_4

	brclr	ATD0STAT0,SCFflag,*       ;Loop here until SCF of ATD is set
                                        ;save ATD

	ldd	ATD0DR0H
	std	ad0

	ldd	ATD0DR1H
	std	ad1

	ldd	ATD0DR2H
	std	ad2

	ldd	ATD0DR3H
	std	ad3

	ldd	ATD0DR4H
	std	ad4

	ldd	ATD0DR5H
	std	ad5

	ldd	ATD0DR6H
	std	ad6

	ldd	ATD0DR7H
	std	ad7

RTI_4
	movb	#RTIF,CRGFLG
	rti


;==============================================================================
*  SCI Input Interrupt Handler
*  Gets bytes from SCI.  Sets COMMAND_PENDING flag.

SerInputInt0
	ldaa	SCI0SR1                  ;read register to clear flag RDRF

	movb	SCI0DRL,COMMAND          ;read receive buffer
	movb	#TRUE,COMMAND_PENDING

SIIX

	rti

;------------------------------------------------------------------------------

OutStr0				        ;send a null terminated string to the display.
	ldaa	1,x+          ;get a character, advance pointer, null?
	beq	OutStrDone      ; yes. return.
	bsr	SerOutput0      ; no. send it out the SCI.
	bra	OutStr0         ; go get the next character.

OutStrDone
	rts

;------------------------------------------------------------------------------
SerOutput0
	brclr	SCI0SR1,TDREflag,SerOutput0     ;check if buffer is empty
	staa	SCI0DRL
	rts
