;MAIN.ASM
*******************************************************************************
*Description:  Demo program for Adapt9S12XEP100, utilizes on-board LED and SCI0
*Author: Carl Barnes
*Derived from Adapt98S12XDP512 demo written by Exequiel Rarama
*
*REVISION HISTORY:
*
*DATE                   REV. NO.        DESCRIPTION
*
*June 11, 2014           Beta       Audio not working; needs adjustment for 4MHz crystal
*
*******************************************************************************
;Assembled using CW5.1
;
; ---------------------------
; Demo - Main Routine
; ---------------------------

;Public Function
	XDEF ResetFunc
	XDEF delay

;Public Variables
	XDEF COMMAND
	XDEF COMMAND_PENDING
	XDEF CONTINUOUS

;External Functions
	XREF RealTimeInit
	XREF audio_init
	XREF do_4_BEEPS

	XREF ShowAnalog
	XREF ProcessCommand

	XREF ShowMenu

	XREF SerInputInt0
	XREF SerOutput0

	XREF OC6Int
	XREF RealTimeInt

;External Variables
	XREF d_flag


  XDEF Entry, main
        ; we use export 'Entry' as symbol. This allows us to
        ; reference 'Entry' either in the linker .prm file
        ; or from C/C++ later on

  XREF __SEG_END_SSTACK      ; symbol defined by the linker for the end of the stack

	;nolist

; include derivative specific macros
        INCLUDE 'derivative.inc'

	list

; variable/data section
MY_EXTENDED_RAM:SECTION

; Insert here your data definition.
COMMAND		ds	1		      ;used by ProcessCommand
COMMAND_PENDING	ds	1		;used by ProcessCommand
CONTINUOUS	ds	1		    ;flag for real-time a/d screen update

OscFreq		equ	4000		  ;Oscillator frequency
initSYNR	equ	9		    ; mult by synr + 1 = 10 (40MHz)
initREFDV	equ	$00
PLLSEL		equ	%10000000	;PLL select bit
LOCK		  equ	%00001000	  ;lock status bit
PLLON		  equ	%01000000	  ;phase lock loop on bit

TDRE  		equ	%10000000	  ;Transmit Data Register Empty flag

; code section
NON_BANKED:SECTION

ResetFunc:
main:
Entry:
	sei

	lds	#__SEG_END_SSTACK     ; initialize the stack pointer

SetupInt

; Initialize clock generator and PLL
	bclr	CLKSEL,PLLSEL      	;disengage PLL to system
	bset	PLLCTL,PLLON       	;turn on PLL

	movb	#initSYNR,SYNR     	;set PLL multiplier 
	movb	#initREFDV,REFDV   	;set PLL divider

	nop
	nop
	nop
	nop

	brclr	CRGFLG,LOCK,*+0    	;while (!(crg.crgflg.bit.lock==1))
	bset	CLKSEL,PLLSEL      	;engage PLL to system

	bset	DDRP,$80		        ;Make PP7 output to drive onboard LED
	bclr  PTP, $80            ;ensure LED is off
	
	movb  #$FF,DDRH		        ;Make all PortH pins outputs
	clr   PTH                 ;ensure they are off

	jsr	RealTimeInit		;Initialize SCI and RTI
	jsr	audio_init		  ;Initialize PP7 as OC for audio output

	clr	COMMAND_PENDING
	clr	CONTINUOUS
	clr	d_flag

	movb	#$FF,IVBR		;Setup Interrupt Vector Base Register to start at $FF00

	movb	#$70,INT_CFADDR
	movb	#%00000010,INT_CFDATA5

	movb	#$D0,INT_CFADDR		      ;Place ATD1 -> TOF into window
	movb	#%00000011,INT_CFDATA3	;Set SCI0 to level 3 priority

	movb	#$E0,INT_CFADDR		      ;Place IC0 -> IC7 into window
	movb	#%00000000,INT_CFDATA0	;Set Timer 7 disabled
	movb	#%00000010,INT_CFDATA1	;Set OC6 to level 2 priority
	movb	#%00000000,INT_CFDATA2	;Set Timer 5 disabled
	movb	#%00000000,INT_CFDATA3	;Set Timer 4 disabled
	movb	#%00000000,INT_CFDATA4	;Set Timer 3 disabled
	movb	#%00000000,INT_CFDATA5	;Set Timer 2 disabled
	movb	#%00000000,INT_CFDATA6	;Set Timer 1 disabled
	movb	#%00000000,INT_CFDATA7	;Set Timer 0 disabled

	movb	#$F0,INT_CFADDR		      ;Place RTI -> RESET into window
	movb	#%00000100,INT_CFDATA0	;Set RTI to level 4 priority


	cli
	
	jsr delay

	jsr	ShowMenu

;------------------------------------------------------------------------------
MainLoop					;Main Loop
	jsr	ProcessCommand		;this is the program loop

	ldaa	CONTINUOUS
	beq	NotCont
	jsr	ShowAnalog

NotCont
	bra	MainLoop


;------------------------------------------------------------------------------
;small delay

delay
	pshy
	ldy	#0

dly
	dbne	y,dly			;decrement y counter
	puly
	rts



	ORG	$FF10

;IVBR + $10
VECTOR119       dc.w    ResetFunc
VECTOR118       dc.w    ResetFunc
VECTOR117       dc.w    ResetFunc
VECTOR116       dc.w    ResetFunc
VECTOR115       dc.w    ResetFunc
VECTOR114       dc.w    ResetFunc
VECTOR113       dc.w    ResetFunc
VECTOR112       dc.w    ResetFunc

;IVBR + $20
VECTOR111       dc.w    ResetFunc
VECTOR110       dc.w    ResetFunc
VECTOR109       dc.w    ResetFunc
VECTOR108       dc.w    ResetFunc
VECTOR107       dc.w    ResetFunc
VECTOR106       dc.w    ResetFunc
VECTOR105       dc.w    ResetFunc
VECTOR104       dc.w    ResetFunc

;IVBR + $30
VECTOR103       dc.w    ResetFunc
VECTOR102       dc.w    ResetFunc
VECTOR101       dc.w    ResetFunc
VECTOR100       dc.w    ResetFunc
VECTOR99        dc.w    ResetFunc
VECTOR98        dc.w    ResetFunc
VECTOR97        dc.w    ResetFunc
VECTOR96        dc.w    ResetFunc

;IVBR + $40
VECTOR95        dc.w    ResetFunc
VECTOR94        dc.w    ResetFunc
VECTOR93        dc.w    ResetFunc
VECTOR92        dc.w    ResetFunc
VECTOR91        dc.w    ResetFunc
VECTOR90        dc.w    ResetFunc
VECTOR89        dc.w    ResetFunc
VECTOR88	dc.w	ResetFunc

;IVBR + $50
VECTOR87	dc.w	ResetFunc
VECTOR86	dc.w	ResetFunc
VECTOR85	dc.w	ResetFunc
VECTOR84	dc.w	ResetFunc
VECTOR83	dc.w	ResetFunc
VECTOR82	dc.w	ResetFunc
VECTOR81	dc.w	ResetFunc
VECTOR80	dc.w	ResetFunc

;IVBR + $60
VECTOR79	dc.w	ResetFunc
VECTOR78	dc.w	ResetFunc
VECTOR77	dc.w	ResetFunc
VECTOR76	dc.w	ResetFunc
VECTOR75	dc.w	ResetFunc
VECTOR74	dc.w	ResetFunc
VECTOR73	dc.w	ResetFunc
VECTOR72	dc.w	ResetFunc

;IVBR + $70
VECTOR71	dc.w	ResetFunc
VECTOR70	dc.w	ResetFunc
VECTOR69	dc.w	ResetFunc
VECTOR68	dc.w	ResetFunc
VECTOR67	dc.w	ResetFunc
VECTOR66	dc.w	ResetFunc
VECTOR65	dc.w	ResetFunc
VECTOR64	dc.w	ResetFunc

;IVBR + $80
VECTOR63	dc.w	ResetFunc
VECTOR62	dc.w	ResetFunc
VECTOR61	dc.w	ResetFunc
VECTOR60	dc.w	ResetFunc
VECTOR59	dc.w	ResetFunc
VECTOR58	dc.w	ResetFunc
VECTOR57	dc.w	ResetFunc
VECTOR56	dc.w	ResetFunc

;IVBR + $90
VECTOR55	dc.w	ResetFunc
VECTOR54	dc.w	ResetFunc
VECTOR53	dc.w	ResetFunc
VECTOR52	dc.w	ResetFunc
VECTOR51	dc.w	ResetFunc
VECTOR50	dc.w	ResetFunc
VECTOR49	dc.w	ResetFunc
VECTOR48	dc.w	ResetFunc

;IVBR + $A0
VECTOR47	dc.w	ResetFunc
VECTOR46	dc.w	ResetFunc
VECTOR45	dc.w	ResetFunc
VECTOR44	dc.w	ResetFunc
VECTOR43	dc.w	ResetFunc
VECTOR42	dc.w	ResetFunc
VECTOR41	dc.w	ResetFunc
VECTOR40	dc.w	ResetFunc

;IVBR + $B0
VECTOR39	dc.w	ResetFunc
VECTOR38	dc.w	ResetFunc
VECTOR37	dc.w	ResetFunc
VECTOR36	dc.w	ResetFunc
VECTOR35	dc.w	ResetFunc
VECTOR34	dc.w	ResetFunc
VECTOR33	dc.w	ResetFunc
VECTOR32	dc.w	ResetFunc

;IVBR + $C0
VECTOR31	dc.w	ResetFunc
VECTOR30	dc.w	ResetFunc
VECTOR29	dc.w	ResetFunc
VECTOR28	dc.w	ResetFunc
VECTOR27	dc.w	ResetFunc
VECTOR26	dc.w	ResetFunc
VECTOR25	dc.w	ResetFunc
VECTOR24	dc.w	ResetFunc	;Port J (PIEP)

;IVBR + $D0
VECTOR23	dc.w	ResetFunc	;Reserved
VECTOR22	dc.w	ResetFunc	;ATD (ATDCTL2 - ASCIE)
VECTOR21	dc.w	ResetFunc	;Reserved
VECTOR20	dc.w	SerInputInt0	;SCI
VECTOR19	dc.w	ResetFunc	;SPI
VECTOR18	dc.w	ResetFunc	;Pulse Accumulator 0 input edge
VECTOR17	dc.w	ResetFunc	;Pulse Accumulator 0 overflow
VECTOR16	dc.w	ResetFunc	;Standard Timer 0 Overflow

;IVBR + $E0
VECTOR15	dc.w	ResetFunc	;Timer 0 Channel 7
VECTOR14	dc.w	OC6Int		;Timer 0 Channel 6
VECTOR13	dc.w	ResetFunc	;Timer 0 Channel 5
VECTOR12	dc.w	ResetFunc	;Timer 0 Channel 4
VECTOR11	dc.w	ResetFunc	;Timer 0 Channel 3
VECTOR10	dc.w	ResetFunc	;Timer 0 Channel 2
VECTOR09	dc.w	ResetFunc	;Timer 0 Channel 1
VECTOR08	dc.w	ResetFunc	;Timer 0 Channel 0

;IVBR + $F0
VECTOR07	dc.w	RealTimeInt	;Real Time Interrupt
VECTOR06	dc.w	ResetFunc	;IRQ
VECTOR05	dc.w	ResetFunc	;XIRQ
VECTOR04	dc.w	ResetFunc	;SWI
VECTOR03	dc.w	ResetFunc	;Instruction Trap

;IVBR + $FA are always handled by MCU
VECTOR02	dc.w	ResetFunc	;COP failure
VECTOR01	dc.w	ResetFunc	;Clock Monitor
;VECTOR00	dc.w	ResetFunc	;Power On RESET


