//             TECHNOLOGICAL ARTS
//	        www.technologicalarts.com

#include <hidef.h>      /* common defines and macros */
#include "derivative.h"
#include "Delay.h"

#define EN0 (0xF8)        // set EN, RS, R/W =0for LCD
#define EN1 (0x02)        // set EN =1
#define RS  (0x04)

#define LCDLENGTH (16)	  // LCD display length

#define DELAY1 (205000)   // DELAY1 is of .0041 Sec Approx.
#define DELAY2 (5000)     // DELAY2 is of .0001 Sec Approx.
#define DELAY3 (2000)     // DELAY3 is of .00004 Sec Approx.

void Lcd_Controlword(unsigned char data,int rs);

// ***********************************************************************
// This subroutine intializes the LCD in 4-bit mode.
// ***********************************************************************
// Initially, 8-bit instructions are sent, but they are processed
// the same way as 4-bit instructions. There is no special 
// subroutine for 8-bit. 
// In 4-bit mode, the high nibble is sent first, then the low nibble.
// ***********************************************************************
// MAKE SURE THERE ARE NO DELAYS BETWEEN SENDING HIGH AND LOW NIBBLE
// ***********************************************************************

void Lcd_Initialization(void)
{
// ************ 8- bit instructions *******************************
  Lcd_Controlword(0x30,0);    // funtion set once
  Delay(DELAY1);              // delay of 4.1 msec
  
  Lcd_Controlword(0x30,0);    // funtion set twice
  Delay(DELAY2);              // delay of 100usec

  Lcd_Controlword(0x30,0);    // funtion set third time 

  Lcd_Controlword(0x20,0);    // set LCD to 4-bit mode
    
// ************ 4- bit mode starts from here ***********************
// Configure LCD
  Lcd_Controlword(0x28,0);    // last function set: 4-bit mode, 2 lines, 5x7 matrix
  
  Lcd_Controlword(0x0C,0);    // display on, cursor off, blink off
  
  Lcd_Controlword(0x01,0);    // display clear
  
  Lcd_Controlword(0x06,0);    // cursor auto-increment, disable display shift
  
}
 
void Lcd_Controlword(unsigned char data,int rs)
{
  unsigned char hi,lo;
  int z;
  
  if(rs==1)                 // check for data or instruction
    z=0x04;                 // if data set rs=1
      else
        z=0x00;             // if instruction set rs=0
      
  hi=data&0xF0;             // separate higher nibble from byte instruction
  lo=((data&0x0F)<<4);      // separate lower nibble byte instruction
  
  PTS&=0x0F;                // mask uppper nibble for sending data
                             
  PTP&=EN0|z;               // set enable=0
  PTS|=hi;                  // send higher nibble
  PTP|=EN1|z;               // set enable=1
  PTP&=EN0|z;               // set enable=0
  
  
  PTS&=0x0F;
  
  PTP&=EN0|z;               // set enable=0
  PTS|=lo;                  // send lower nibble
  PTP|=EN1|z;               // set enable=1
  PTP&=EN0|z;               // set enable=0
  
  Delay(DELAY3);            // provide approximate delay of 40usec
}

//***************************************************************************
// This subroutine is used to display information on one of 4 lines of LCD   
//***************************************************************************  
  
void Lcd_Write(char *string, int line)
{
  int charCount;
	unsigned char address;
  switch(line) 
    {
      case 1:   address = 0x80;   // line 1 address
                break;
      
      case 2:   address = 0xC0;   // line 2 address
                break;
      
      case 3:   address = 0x90;   // line 3 address
                break;
      
      case 4:   address = 0xD0;   // line 4 address
                break;
      default:  break;
    }   

	
	Lcd_Controlword( address,0);  // rs=0 for instruction
	
	for( charCount = 0; charCount < LCDLENGTH; charCount++)
	  {
		  Lcd_Controlword( string[charCount],1); // rs=1 for data
	  }
} 


void Lcd_Display(void) 
{

  Lcd_Write("  Technological ",1);  // line 1
  Lcd_Write("      Arts      ",2);  // line 2
  Lcd_Write("Adapt9S12XEP100 ",3);  // line 3
  Lcd_Write("  HELLO WORLD!  ",4);  // line 4

} 
