//             TECHNOLOGICAL ARTS
//	        www.technologicalarts.com

#include <hidef.h>      /* common defines and macros */
#include "derivative.h"     /* derivative information */

#include "Delay.h"

#define EN0 (0xF8)        // set EN, RS, R/W =0for LCD
#define EN1 (0x02)        // set EN =1
#define RS  (0x04)

#define LCDLENGTH (16)	  // LCD display length

#define DELAY1 (205000)   // DELAY1 is of .0041 Sec Approx.
#define DELAY2 (5000)     // DELAY2 is of .0001 Sec Approx.
#define DELAY3 (2000)     // DELAY3 is of .00004 Sec Approx.

void Lcd_Controlword(unsigned char data,int rs);

// ******************************************************
// This subroutine intializes the Lcd in 4-bit mode.
// ******************************************************
// Intially 8-bit instructions are sent but they are processed
// in a simillar fashion to 4-bit instructions. There is no special 
// subroutine for 8-bit. 
// In 4-bit mode, higher nibble sent first, followed by lower nibble.
// ******************************************************************
// ENSURE THERE ARE NO DELAYS BETWEEN HIGHER AND LOWER NIBBLE
// ******************************************************************

void Lcd_Initialization(void)
{
// ************ 8- bit instructions *************************
  Lcd_Controlword(0x30,0);    // function set first time
  Delay(DELAY1);              // delay of 4.1 msec
  
  Lcd_Controlword(0x30,0);    // function set second time
  Delay(DELAY2);              // delay of 100usec

  Lcd_Controlword(0x30,0);    // function set third time
 

  Lcd_Controlword(0x20,0);    // set LCD for 4-bit mode
    
// ************ 4- bit mode begins ***********************
  Lcd_Controlword(0x28,0);    // last function set: 4-bit mode, 2 lines, 5x7 matrix
  
  Lcd_Controlword(0x0C,0);    // display on, cursor off, blink off
  
  Lcd_Controlword(0x01,0);    // display clear
  
  Lcd_Controlword(0x06,0);    // cursor auto-increment, disable display shift
  
}
 
void Lcd_Controlword(unsigned char data,int rs)
{
  unsigned char hi,lo;
  int z;
  
  if(rs==1)                 // data or instruction?
    z=0x04;                 // if data then force RS line to logic 1
      else
        z=0x00;             // if instruction then force RS line to logic 0
      
  hi=data&0xF0;             // extract higher nibble from byte instruction
  lo=((data&0x0F)<<4);      // extract lower nibble from byte instruction
  
  PTS&=0x0F;                // mask uppper nibble for sending data
                             
  PTP&=EN0|z;               // assert logic low on EN line
  PTS|=hi;                  // send higher nibble
  PTP|=EN1|z;               // assert logic high on EN line
  PTP&=EN0|z;               // return EN line to logic low
  
  
  PTS&=0x0F;
  
  PTP&=EN0|z;               // assert EN=0
  PTS|=lo;                  // send lower nibble
  PTP|=EN1|z;               // assert EN=1
  PTP&=EN0|z;               // assert EN=0
  
  Delay(DELAY3);            // provide delay of approximately 40usec
}

//*******************************************************************************
// This subroutine places information on one of four lines of the LCD   
//*******************************************************************************  
  
void Lcd_Write(char *string, int line)
{
  int charCount;
	unsigned char address;
  switch(line) 
    {
      case 1:   address = 0x80;   // line 1 address
                break;
      
      case 2:   address = 0xC0;   // line 2 address
                break;
      
      case 3:   address = 0x90;   // line 3 address
                break;
      
      case 4:   address = 0xD0;   // line 4 address
                break;
      default:  break;
    }   

	
	Lcd_Controlword( address,0);  // assert RS=0 for instruction
	
	for( charCount = 0; charCount < LCDLENGTH; charCount++)
	  {
		  Lcd_Controlword( string[charCount],1); // assert RS=1 for data
	  }
} 


void Lcd_Display(void) 
{

  Lcd_Write("  Technological ",1);  // line 1
  Lcd_Write("      Arts      ",2);  // line 2
  Lcd_Write(" Toronto, Canada",3);  // line 3
  Lcd_Write("  HELLO WORLD!  ",4);  // line 4

} 
