;Keybrd.asm
*******************************************************************************
*REVISION HISTORY:
*
*DATE			REV. NO.		DESCRIPTION
*
*June 14, 2002		1.00		Initial release
*
*Author:Exequiel Rarama for the ADAPT9S12DP256 DKKI apps board
*******************************************************************************
;Compiled using MCUez

	include "Dp256Regs.INC"

;Public Function
	XDEF keybd_init
	XDEF get_key
	XDEF keybd_count
	XDEF key_char_disp

;External Function
	XREF MSG9
	XREF MSG10
	XREF disp_menu4
	XREF dstr


;Public Variable
	XDEF keybd_state
	XDEF keyp_timer
	XDEF keybd_timer
	XDEF keybd_value
	XDEF clr_flag
	XDEF key_ptr
	XDEF keybd_flag

;External Variable
	XREF drow_var
	XREF drow
	XREF lcd_state
	XREF disp_flag
	XREF disp_buffer


;Keyboard
LEFT	equ	1
RIGHT	equ	2
UP	equ	3
DOWN	equ	4

DEL	equ	7
BS	equ	8
CR	equ	$13
ESC	equ	$1b
ALT	equ	$11
CTRL	equ	$14
F1	equ	$05

ENTER	equ	CR
EXIT	equ	ESC
TEN	equ	$80


DataSec:	SECTION

;Keyboard variables
keybd_char	ds.b	1
keybd_value	ds.b	6
keybd_count	ds.b	1
keybd_flag	ds.b	1
keybd_timer	ds.b	1
release_flag	ds.b	1
keybd_state	ds.b	1
key_ptr		ds.b	2
keyp_timer	ds.b	2
keyp_flag	ds.b	1
clr_flag		ds.b	1

;==============================================================================
; Keyboard Routines
; -----------------

CodeSec: 	SECTION

keybd_init
	bset	TSCR1,TEN		;Enable timer
	bset	TIE,%1000		;Enable input capture 3
	bset	TFLG1,%1000		;Clear input capture 3 interrupt

	bset	TCTL4,%10000000		;Capture on Falling edge
	bclr	TCTL4,%01000000		;Capture on Falling edge

	ldaa	#11
	staa	keybd_count

	ldx	#0
	stx	keybd_value
	stx	keyp_timer

clear_key
        clr     keybd_flag
        clr     release_flag
        clr     keybd_char
        clr     keybd_state
        clr     keyp_flag
        clr     keybd_timer
        clr     clr_flag

        ldx     #disp_buffer+20
        stx     key_ptr

        rts

;
get_key
        ldaa    keybd_flag
        lbeq     gky90

        ldx     #keybd_value+2-1

        sei
        ldab    keybd_flag
        abx
        ldab    0,x
        dec     keybd_flag
        cli

        cmpb    #$e0                   ;skip if alternate? prefix
        beq     gky90

        cmpb    #$f0                   ;skip if release prefix
        bne     gky10

        inc     release_flag
        bra     gky90

gky10
        ldaa    release_flag
        beq     gky20

        clr     release_flag
        cmpb    #ALT
        bne     gky15

        bclr    keybd_state,%10
        bra     gky90

gky15
        cmpb    #CTRL
        bne     gky90
        bclr    keybd_state,%01
        bra     gky90

gky20
        tstb
        bmi     gky90
 
gky30
        ldx     #key_table_at
        abx
        ldaa    0,x
        staa    keybd_char

        ldaa    #1
        staa    keyp_flag

        ldaa    clr_flag
        bne     gky90

        ldaa    #0
        staa    drow_var
        jsr     drow
        ldx     #MSG10
        jsr     dstr
        inc     clr_flag

        ldaa    #1
        staa    drow_var
        jsr     drow
        ldx     #MSG9
        jsr     dstr

        ldaa    #2
        staa    drow_var
        jsr     drow
        ldx     #MSG9
        jsr     dstr

        ldaa    #3
        staa    drow_var
        jsr     drow
        ldx     #MSG9
        jsr     dstr

gky90   clra

gkyex
        rts

key_char_disp
        jsr     get_key         ;get keyboard value

        ldaa    keyp_flag       ;display value to lcd
        beq     disp_ex

        ldaa    keybd_char

        ldy     key_ptr
        cpy     #disp_buffer+40
        beq     line1

        cpy     #disp_buffer+80
        beq     line0
        bra     line2

line0
        psha
        ldaa    #1
        staa    drow_var
        jsr     drow
        ldx     #MSG9
        jsr     dstr

        ldaa    #2
        staa    drow_var
        jsr     drow
        ldx     #MSG9
        jsr     dstr

        pula

        ldy     #disp_buffer+20
        sty     key_ptr
        bra     line2

line1
        psha
        ldaa    #2
        staa    drow_var
        jsr     drow
        ldx     #MSG9
        jsr     dstr

        ldaa    #3
        staa    drow_var
        jsr     drow
        ldx     #MSG9
        jsr     dstr
        pula

        ldy     #disp_buffer+40
        sty     key_ptr

line2
        staa    0,y
        iny
        sty     key_ptr

        ldaa    #1
        staa    disp_flag
        clr     keybd_char

        ldx     #disp_menu4
        stx     lcd_state

        ldx     #61*30          ;30 second time out if no key press
        stx     keyp_timer

        clr     keyp_flag

disp_ex
        rts


;ConstSec:     SECTION 

key_table_at
        dc.b    0,0,0,0,0,F1,0,0,0,0,0,0,0,0,0,0

        dc.b    0,ALT,0,0,CTRL
        dc.b    'Q1'
        dc.b    0,0,0
        dc.b    'ZSAW2'
        dc.b    0

        dc.b    0
        dc.b    'CXDE43'
        dc.b    0,0
        dc.b    ' VFTR5'
        dc.b    0

        dc.b    0
        dc.b    'NBHGY6'
        dc.b    0,0,0
        dc.b    'MJU78'
        dc.b    0

        dc.b    0
        dc.b    ',KIO09'
        dc.b    0,0
        dc.b    './L'
        dc.b    $38
        dc.b    'P-'
        dc.b    0

        dc.b    0,0,0,0
        dc.b    '[='
        dc.b    0,0,0,0,CR
        dc.b    ']'
        dc.b    0,0,0,0

        dc.b    0,0,0,0,0,0,BS,0,0,0,0,0,0,0,0,0
        dc.b	0,0,0,0,0,0,ESC,0,0,0,0,0,0,0,0,0


	END