;Int.asm
*******************************************************************************
*REVISION HISTORY:
*
*DATE                   REV. NO.        DESCRIPTION
*
*January 20, 2000         V1.00
*Written by Exequiel Rarama for the ADAPT 812
********************************************************************************

;----------------------------
* Real-time Interrupt Routine
;----------------------------
RealTimeInt
        movb    #rtiflag,RTIFLG         ;clear real-time interrupt flag
                                        ; so that other interrupts can be service
        cli

;--------
; Timers
;--------
;State timer is decremented here

time10
        ldx     state_timer
        beq     time20
	dex
	stx     state_timer

time20
        ldx     wait_timer
        beq     time30

        dex
        stx     wait_timer

time30
        ldx     lcd_timer
        beq     time40

        dex
        stx     lcd_timer

time40
        sei
	ldaa    keybd_timer
        beq     time50
	deca
	staa    keybd_timer
        bne     time50

        ldaa    #11
        staa    keybd_count

time50
        cli

time60
        ldx     keyp_timer
        beq     time70

        dex
        stx     keyp_timer

        ldx     keyp_timer
        bne     time70

        ldx     #disp_menu0
        stx     lcd_state

        ldx     #disp_buffer+20
        stx     key_ptr
        clr     clr_flag

time70

timex
	rti

;-----------------------------------------------------------------------------
*  SCI Input Interrupt Handler
*  Gets bytes from SCI.  Sets COMMAND_PENDING flag.
;
SerInputInt
        ldaa    SC0SR1                  ;read register to clear flag RDRF
        movb    SC0DRL,COMMAND          ;read receive buffer
        movb    #TRUE,COMMAND_PENDING

SIIX
        rti

;This is needed to service SWI interrupt
dummy_int
        movb    #$55,COPRST
        movb    #$AA,COPRST
        rti

;----------------------------------------------------------------------------
spi_int
        bset    spi_int_flag,%00000001  ;Set flag

        ldaa    SP0SR
        ldaa    SP0DR

        rti
