;main.asm
;MC68HC812A4 MAIN ROUTINE
;REGS.INC CONTAINS ALL REGISTERS
;
;REGS.INC, AUDIO.ASM and RTC.ASM ARE EXTERNAL FILES
;
*******************************************************************************
*REVISION HISTORY:
*
*DATE                   REV. NO.        DESCRIPTION
*
*January 20, 2000         V1.00
*Written by Exequiel Rarama for the ADAPT 812
********************************************************************************
;
; ---------------------------
; Demo - Main Routine
; ---------------------------

#include REGS.INC

*  Operational Parameters

_100MS          equ     25
_250MS          equ     61
_500MS          equ     125
_1SECOND        equ     250
_2SECONDS       equ     500
_3SECONDS       equ     750
_5SECONDS       equ     1250
_10SECONDS      equ     2500
_25SECONDS      equ     6250
_60SECONDS      equ     15000
_2MIN           equ     30000

;Audio Variables are define in "AUDIO.ASM" file
;TONE_2K         equ     500     ;frequencies in Hertz for tone generation
;TONE_1K         equ     1000
;TONE_440        equ     2272
;TONE_220        equ     4545
;TONE_180        equ     3000
;TONE_110        equ     9090
;TONE_60         equ     16666

RAM     equ     $0800                   ;68HC812A4 internal RAM
STACK   equ     $0c00                   ;Stack at top of internal ram
rbase   equ     $0000                   ;68HC812A4 register block
FLASH   equ     $8000                   ;external Flash
EEPROM  equ     $f000                   ;68HC812A4 internal EEPROM
SRAM    equ     $7000                   ;start of external SRAM, when enabled
DWIN    equ     $7000                   ;start of data window
ENDDWIN equ     $7fff                   ;end of data window
PWIN    equ     $8000                   ;start of program window
ENDPWIN equ     $bfff                   ;end of program window
LDP128  equ     $1f                     ;last 4K page of 128K data space
LDP512  equ     $7f                     ;last 4K page of 512K data space
LPP128  equ     $07                     ;last 16K page of 128K program space
LPP512  equ     $1f                     ;last 16K page of 512K program space

PAGE0   equ     0
PAGE1   equ     1
PAGE2   equ     2
PAGE3   equ     3
PAGE4   equ     4
PAGE5   equ     5
PAGE6   equ     6
PAGE7   equ     7

* Operational Constants

TRUE            equ     $FF
FALSE           equ     $00
LF              equ     $A
SPACE           equ     $20

**********************************************************************
*       PORT ASSIGNMENTS for this program

;PORTT is initialize in REGS.INC
_PORTT  equ     PORTT           ;input capture/output compare port of 68HC812A4

*       PT0     spare           ;I/O
*       PT1     spare           ;I/O
*       PT2     spare           ;I/O
*       PT3     spare           ;I/O
*       PT4     spare           ;I/O
*       PT5     spare           ;I/O
*       PT6     SPEAKER         ;I/O
*       PT7     spare           ;I/O
**********************************************************************

* Masks
;OC Variables are define in "AUDIO.ASM" file
;OC6mask1        equ     %01000000       ;IOS6 = 1, Bit 6 as output compare
;OC6mask2        equ     %01000000       ;C6I = 1, Enable Interrupt
;OC6mask3        equ     %00010000       ;OM6 = 0, OL6 = 1, toggel OC output line
;OC6flag         equ     %01000000       ;C6F = 1 to clear Interrupt flag

;ATD Variables
admask2         equ     %11000000       ;AFFC,ADPU=1 - Enable Analog to Digital
admask3         equ     %00000000       ;FRZ1,FRZ0=0
admask4         equ     %00000001       ;SMP1,SMP0 = 0, PRS0=1 - Select Sample time
admask5         equ     %01110000       ;S8CM = 1, SCAN = 1, MULT = 1
SCFflag         equ     %10000000       ;SCF - Sequence Complete flag

;RTI Variables
clrmask         equ     %11000000       ;mask for clearing timer flags
rtimask1        equ     %10000001       ;M=8Mhz, 1.024 msec interrupt with 16 MHz xtal
rtimask2        equ     %10000010       ;M=8Mhz, 2.048 msec interrupt with 16 MHz xtal
rtimask3        equ     %10000011       ;M=8Mhz, 4.096 msec interrupt with 16 MHz xtal
rtimask4        equ     %10000100       ;M=8Mhz, 8.196 msec interrupt with 16 MHz xtal
rtimask5        equ     %10000101       ;M=8Mhz, 16.384 msec interrupt with 16 MHz xtal
rtimask6        equ     %10000110       ;M=8Mhz, 32.768 msec interrupt with 16 MHz xtal
rtimask7        equ     %10000111       ;M=8Mhz, 65.536 msec interrupt with 16 MHz xtal
rtiflag         equ     %10000000

;SCI Variables
scimask         equ     %00101100       ;RIE - SCI Interrupt enable
                                        ;RE - Receiver Enable
RDRFflag        equ     %00100000       ;RDRF - Receive Data Register Full flag
TDREflag        equ     %10000000       ;TDRE - Transmit Data Register Empty flag

;Baud rate definitions
;MCLK=8Mzh
BAUD110         equ     4545            ;(baud) 110 baud with 16 Mhz crystal
BAUD300         equ     1667            ;(baud) 300 baud with 16 Mhz crystal
BAUD600         equ     833             ;(baud) 600 baud with 16 Mhz crystal
BAUD1200        equ     417             ;(baud) 1200 baud with 16 Mhz crystal
BAUD2400        equ     208             ;(baud) 2400 baud with 16 Mhz crystal
BAUD4800        equ     104             ;(baud) 4800 baud with 16 Mhz crystal
BAUD9600        equ     52              ;(baud) 9600 baud with 16 Mhz crystal
BAUD14400       equ     35              ;(baud) 14400 baud with 16 Mhz crystal
BAUD19200       equ     26              ;(baud) 19200 baud with 16 Mhz crystal
BAUD38400       equ     13              ;(baud) 19200 baud with 16 Mhz crystal

        org     RAM

* System Variables
CURPAGE         rmb     1               ;current page counter
MEM_SIZE        rmb     2               ;memory size (128 or 512)
LAST_PPAGE      rmb     1               ;last page of Flash
LAST_DPAGE      rmb     1               ;last page of RAM

COMMAND         rmb     1               ;used by ProcessCommand

H               rmb     1               ;used in binary to decimal conversion
TO              rmb     1

DURATION        rmb     2               ;used for tone generation
HALF_PERIOD     rmb     2

TIMER           rmb     2               ;software timers using RTI
TIMER1          rmb     2
COUNTER         rmb     1
dummy           rmb     1

;-------------------
* Boolean Variables

COMMAND_PENDING rmb     1               ;used by ProcessCommand
CONTINUOUS      rmb     1               ;flag for real-time a/d screen update

; Memory Allocation for LC Display routine
disp_buffer     rmb     80              ;display buffer (4 lines of 20 chars)
disp_ptr        rmb     2               ;pointer to display buffer
disp_flag       rmb     1               ;1 = update; 0 = home; -1 = done
drow_var        rmb     1
temp            rmb     1
lcd_state       rmb     2
temp_h          rmb     1
TEMP1           rmb     1
TEMP2           rmb     1
lcd_timer       rmb     2
dcol_var        rmb     1
dig_lenght      rmb     1
l_flag          rmb     1
spi_int_flag    rmb     1
u_delay_var     rmb     2

;Keyboard
keybd_char      rmb      1
keybd_value     rmb      6
keybd_count     rmb      1
keybd_flag      rmb      1
keybd_timer     rmb      1
release_flag    rmb      1
keybd_state     rmb      1
key_ptr         rmb      2
keyp_timer      rmb      2
keyp_flag       rmb      1
clr_flag        rmb      1

;timers
state_timer     rmb     2
wait_timer      rmb     2

***************************** Program *******************************

        org     $F000
RESET2

;Set up external memory control registers
        movb    #$04,PEAR               ;enable read/write signal
        movb    #$b0,MODE               ;normal exp. narrow
        movb    #$c0,WINDEF             ;enable data & program windows
        movb    #$07,MXAR               ;enable A16, A17, A18
        movb    #$30,CSCTL0             ;enable CSD & CSP0
        movb    #$10,CSCTL1             ;CSD covers lower half of memory map

;Initialize COP
        movb    #%10000111,COPCTL       ;COP is enabled and is armed to
                                        ; reset in 1 second.

RESET1                                  ;This is where the RESET vector points to
;Initialize Stack
        lds     #STACK                  ;initialize stack pointer

;Initialize Real Time Interrupt
        movb    #rtimask5,RTICTL        ;Enable RTI and initialize RTI rate
        movb    #rtiflag,RTIFLG

;Initialize Serial Communication Interface
        movb    #scimask,SC0CR2         ;enable SCI 0 rcvr. & xmtr. & rx int
        movb    #0,SC0CR1    
        movb    #BAUD38400,SC0BDL       ;Set baud rate to 9600    
        ldaa    SC0SR1                  ;read register to clear flag RDRF
        ldaa    SC0DRL                  ;dummy read to flush receive buffer

;Initialize PORTT
        movb    #%01100000,DDRT         ;Bit 6,5 of PORTT are Output
        bclr    PORTT,%01100000

        jsr     keybd_init              ;Initialize keyboard

        cli                             ;unmask interrupts
        jsr     disp_init               ;Initialize Lcd

;-----------------------------------------------------------------------------
;Main loops
;
Main
        movb    #$55,COPRST             ;Reset COP
        movb    #$AA,COPRST

        ldy     lcd_state               ;execute current state
        jsr     0,y
        jsr     disp_update

        jsr     key_char_disp           ;check for keypress

        bra     Main

;-----------------------------------------------------------------------------
;Interrupt test traps
RESET

;Bit 5 of PORTT is toggled
        jsr     delay
        jsr     delay
        bclr    PORTT,%00100000
        jsr     delay
        jsr     delay
        bset    PORTT,%00100000

        bra     RESET

;-----------------------------------------------------------------------------
delay
        pshy
        ldy     #0
        bra     dly

small_delay
        pshy
        ldy     #10    

dly
        dbne    y,dly
        puly
        rts


HexByte2Dec

*               Supply hex value to be converted in B register
        clra
        ldx     #100    ;numerator in D, denominator in X
        idiv
*               remainder in D, quotient in X
*               B is lo-order byte
        xgdx
        stab    H       ;8 bit quotient in B
        xgdx
        ldx     #10     ;H=0X  TO=packed BCD
        idiv
        stab    TO
        xgdx
        aslb
        aslb
        aslb
        aslb
        orab    TO
        stab    TO
        rts

SendDecByte

* value is in B

        clra
        jsr     HexByte2Dec
        ldaa    H
        adda    #'0'
        jsr     SendByte
        ldaa    TO
        jsr     SendASCIIHex
        rts

SendASCIIHex
*       value in A

        psha
        anda    #$F0
        lsra
        lsra
        lsra
        lsra
        cmpa    #$A
        blt     SAH1
        suba    #$A
        adda    #'A'
        bra     SAH2
SAH1
        adda    #'0'
SAH2
        jsr     SendByte
        pula
        psha
        anda    #$0F
        cmpa    #$A
        blt     SAH3
        suba    #$A
        adda    #'A'
        bra     SAH4
SAH3
        adda    #'0'
SAH4
        jsr     SendByte
        pula
        rts


SendByte:

*  Transmits a byte, contained in register A, to the serial device via the SCI.

SB1
        ldab    SC0SR1                  ;wait for transmit data register empty (TDRE)
        bpl     SB1
        staa    SC0DRL                  ;send byte
        rts

PutNewLine
        ldaa    #CR
        jsr     SendByte
        ldaa    #LF
        jsr     SendByte
        rts

PutDblLine
        ldaa    #CR
        jsr     SendByte
        ldaa    #LF
        jsr     SendByte
        ldaa    #LF
        jsr     SendByte
        rts

SendString

*       x contains starting address of string
RV1
        ldaa    0,X                     ;$FF denotes end of string
        cmpa    #$FF
        beq     RVX
        jsr     SendByte
        inx
        bra     RV1
RVX
        rts

GetChar:

*  Fetches one character from SCI0, 
*  and returns it in register A.  

GC1:
        ldaa    SC0SR1                  ;get sci flags
        anda    #RDRFflag               ;mask off irrelevant bits
        beq     GC1                     ;loop until character found
        ldaa    SC0DRL                  ;get character
	rts

;
;-----------------------------------------------------------------------------
;These sub-routines are external to this main routine and are link during the
; assembling stage.

#include LCD.ASM                        ;Liquid Crystal Display routine
#include KEYBRD.ASM                     ;Keyboard routine                 
#include INT.ASM                        ;Interrupts routine

;MC68HC812A4 VECTOR INTERRUPTS

        org     $FFCE

        FDB     RESET                   ;KEY WAKEUP H
        FDB     RESET                   ;KEY WAKEUP J
        FDB     RESET                   ;ANALOG TO DIGITAL
        FDB     RESET                   ;SERIAL COMMUNICATION 1
        FDB     SerInputInt             ;SERIAL COMMUNICATION 0
        FDB     spi_int                 ;SPI SERIAL TRANSFER COMPLETE
        FDB     RESET                   ;PULSE ACCUMULATOR INPUT EDGE
        FDB     RESET                   ;PULSE ACCUMULATOR OVERFLOW
        FDB     RESET                   ;TIMER OVERFLOW
        FDB     RESET                   ;TIMER CHANNEL 7
        FDB     RESET                   ;TIMER CHANNEL 6
        FDB     RESET                   ;TIMER CHANNEL 5
        FDB     RESET                   ;TIMER CHANNEL 4
        FDB     keybrd_int              ;TIMER CHANNEL 3
        FDB     RESET                   ;TIMER CHANNEL 2
        FDB     RESET                   ;TIMER CHANNEL 1
        FDB     RESET                   ;TIMER CHANNEL 0
        FDB     RealTimeInt             ;REAL TIME INTERRUPT
        FDB     RESET                   ;IRQ OR KEY WAKE UP D
        FDB     RESET                   ;XIRQ
        FDB     dummy_int               ;SWI
        FDB     RESET                   ;RESERVED
        FDB     RESET                   ;COP FAILURE RESET
        FDB     RESET                   ;COP CLOCK MONITOR FAIL RESET
        FDB     RESET2                  ;RESET1 for single chip mode
                                        ;RESET2 for expanded mode
