;MAIN.ASM

*Rev0
*Date: Oct 28, 1999
*Application: For the Adapt11C75 board 
*Author: Exequiel Rarama

RAM     equ     $0
EEPROM  equ     $e000

        org     RAM

states          rmb      2
COMMAND         rmb      1       ;used by ProcessCommand
COMMAND_PENDING rmb      1       ;used by ProcessCommand
;
ad1             rmb      1               ;A/D channel 1:
ad2             rmb      1               ;A/D channel 2: 
ad3             rmb      1               ;A/D channel 3:
ad4             rmb      1               ;A/D channel 4:
;
; Memory Allocation
disp_buffer     rmb      80              ;display buffer (4 lines of 20 chars)
disp_ptr        rmb      2               ;pointer to display buffer
disp_flag       rmb      1               ;1 = update; 0 = home; -1 = done
drow_var        rmb      1
temp            rmb      1
lcd_state       rmb      2
temp_h          rmb      1
TEMP1           rmb      1
TEMP2           rmb      1
lcd_timer       rmb      2
dcol_var        rmb      1
dig_lenght      rmb      1
l_flag          rmb      1
;
state_routine   rmb      2
state_timer     rmb      2               ;general purpose state timer
wait_timer      rmb      2
temp1           rmb      1
temp2           rmb      3
;
;Keyboard
keybd_char      rmb      1
keybd_value     rmb      6
keybd_count     rmb      1
keybd_flag      rmb      1
keybd_timer     rmb      1
release_flag    rmb      1
keybd_state     rmb      1
key_ptr         rmb      2
keyp_timer      rmb      2
keyp_flag       rmb      1
clr_flag        rmb      1

*-----------------------------------------------------------------------------
REG		EQU	1000h		;starting address of register block

PORTA          EQU     00h             ;I/O port A
PORTD          EQU     08h             ;I/O port D
DDRD           EQU     09h             ;data direction for port D

TCTL1          EQU     20h             ;timer control register 1
TCTL2          EQU     21h             ;timer control register 2
TMSK1          EQU     22h             ;main timer interrupt mask register 1
TFLG1          EQU     23h             ;main timer interrupt flag register 1
TMSK2          EQU     24h             ;main timer interrupt mask register 2
TFLG2          EQU     25h             ;main timer interrupt flag register 2
PACTL          EQU     26h             ;port A control port

BAUD           EQU     2bh             ;baud rate register
SCCR1          EQU     2ch             ;SCI control register 1
SCCR2          EQU     2dh             ;SCI control register 2
SCSR           EQU     2eh             ;SCI status register
SCDR           EQU     2fh             ;SCI data register

ADCTL          EQU     30h             ;A/D control/status register
ADR1           EQU     31h             ;A/D result register 1
ADR2           EQU     32h             ;A/D result register 2
ADR3           EQU     33h             ;A/D result register 3
ADR4           EQU     34h             ;A/D result register 4

BPROT          EQU     35h             ;block protect register

OPTION         EQU     39h             ;system configuration options
COPRST         EQU     3ah             ;arm/reset COP timer
PPROG          EQU     3bh             ;EEPROM programming register
HPRIO          EQU     3ch             ;highest priority interrupt
INIT           EQU     3dh             ;ram - I/O mapping register
CONFIG         EQU     3fh             ;configuration control register


bdmsk96	equ	%00110000	;(baud) 9600 baud with 8 MHz crystal
bdmsk24	equ	%00110010	;(baud) 2400 baud with 8 MHz crystal
bdmsk12	equ	%00110011	;(baud) 1200 baud with 8 MHz crystal
ptdmsk	equ 	%00000010	;(ddrd)portd data direction: input, except txd
sc2msk2 equ     %00101100       ;(sccr2)enable tx & rx and Rx Interrupt
;
; Local Constants
lcd_ctrl                equ     %01000000       ;Port A bit 6 = 0 - Instruction in
lcd_data                equ     %01000000       ;Port A bit 6 = 0 - Data in
lcd_enable              equ     %10000000       ;Port A bit 7 - enable
BL                      EQU     $20
EOT                     EQU     $04             ;end of text/table

SSPIN		EQU  	%00100000 	;Port D bit 5 is SS* pin
					;* 0,0,SS*,SCK;MOSI,MISO,TxD,RxD
					;(RxD & TxD direction controlled by SCI)
					;* For EVBU w/ RTC use
					;$38 -> SS,SCK,and MOSI=OUTS, rest=INS

SPCR		EQU	$28    		;SPI control register
					;* SPIE,SPE,DWOM,MSTR;CPOL,CPHA,SPR1,SPR0
					;(set to $54 for RTC interface)

SPSR		EQU	$29    		;SPI status register
					;* SPIF,WCOL,-,MODF;-,-,-,-

SPIF		EQU	$80    		;Mask for SPIF flag bit
SPDR		EQU	$2A    		;SPI data register

*Register offsets for X68C75
XPORTA	equ	$10
XPORTB	equ	$08
xcr     equ     $20
XREG    equ     $8400

;Keyboard
LEFT    equ     1
RIGHT   equ     2
UP      equ     3
DOWN    equ     4

DEL     equ     7
BS      equ     8
CR      equ     $13
ESC     equ     $1b
ALT     equ     $11
CTRL    equ     $14
F1      equ     $05

ENTER   equ     CR
EXIT    equ     ESC




        ORG     EEPROM

;-----------------------------------------------------------------------------
version fcc      '100'                   ;Version 1.00
;-----------------------------------------------------------------------------

;-----------------
; Start of Program
; ----------------
reset
        sei                             ;disabel interrupt
        lds     #$ff                    ;initialize stack to top of ram
        ldx     #REG                    ;base address 1000h
        ldaa    #%10011011              ;start A/D converter, set IRQ to edge,
        staa    OPTION,x               ;  disable clock monitor, COP timer

        ldaa    #bdmsk96                ;baud=9600
        staa    BAUD,x
	ldaa	#sc2msk2
        staa    SCCR2,x                ;enable SCI rcvr. & xmtr. & rx int.
        ldaa    SCDR,x                 ;dummy read to flush receive buffer

        jsr     real_time_init          ;initialize RTI and other interrupts
        jsr     disp_init
        jsr     keybd_init

	cli                             ;enable interrupts


;                        *******************
;                        *Main Program Loop*
;                        *******************
main
        ldy     lcd_state               ;execute current state
        jsr     0,y

        jsr     disp_update

        jsr     key_char_disp

        bra     main

;-----------------------------------------------------------------------------

delay
	ldy     #0
        bra     dsi10

small_delay
        ldy     #100

dsi10   dey
	bne     dsi10
	rts


;=============================================================================
; Initialize Real Time Parameters
; -------------------------------

real_time_init
	ldx     #REG
        ldaa    #%0011000              ;initialize A/D (2nd set of channels,
        staa    ADCTL,X                ;  continuous scan & multiple channel)

        ldaa    #%00000110
        staa    PACTL,x                ;set real-time interrupt rate (16.38ms)
        bset    TMSK2,X %01000000      ;  & enable interrupts
	rts

; Real-Time Interrupt Routine
; ---------------------------

real_time_int
	ldx     #REG
        bset    TFLG2,X %01000000      ;clear real-time interrupt flag
        cli

;--------
; Timers
;--------
;State timer is decremented here

time10
        ldx     state_timer
        beq     time20
	dex
	stx     state_timer

time20
        ldx     wait_timer
        beq     time30

        dex
        stx     wait_timer

time30
        ldx     lcd_timer
        beq     time40

        dex
        stx     lcd_timer

time40
        sei
	ldaa    keybd_timer
        beq     time50
	deca
	staa    keybd_timer
        bne     time50

        ldaa    #11
        staa    keybd_count

time50
        cli

time60
        ldx     keyp_timer
        beq     time70

        dex
        stx     keyp_timer

        ldx     keyp_timer
        bne     time70

        ldx     #disp_menu0
        stx     lcd_state

        ldx     #disp_buffer+20
        stx     key_ptr
        clr     clr_flag

time70


timex
	rti

;=============================================================================
; Display Initialization
; ----------------------

disp_init                       ;Initialize LCD display
        ldx     #XREG
        ldaa    #8
        staa    xcr,x

        ldx     #REG            ;Point at start of register block
        ldaa    #00h
        staa    PORTD,x        ;Initial port D data
        ldaa    #%00111000      ;SS,SCK,and MOSI=OUTS, others=INS
        staa    DDRD,x         ;Set directions for port D pins
        ldaa    #50h            ;FOR THE 74HC595 THE CPOL=0
                                ;SPIE,SPE,DWOM,MSTR;CPOL,CPHA,SPR1,SPR0
        staa    SPCR,x         ;SPI On, Master, CPOL:CPHA=0:1, 1MHz

        ldaa    SPSR,x
        ldaa    SPDR,x         ;Clear SPIF

        ldaa    #0
        staa    drow_var
        staa    disp_flag

        jsr     delay
        jsr     delay

        ldx     #XREG
        bclr    XPORTA,x lcd_enable       ;Initialize lcd control lines
        bclr    XPORTA,x lcd_ctrl           

;Initialize 
        jsr     small_delay

        ldaa    #00110000b
        jsr     toggle_lcd_ctrl         ;8 data bits, 2 display lines, 0

        jsr     small_delay

        ldaa    #00111000b                                               
        jsr     toggle_lcd_ctrl         ;8 data bits, 2 display lines, 0

        jsr     small_delay

        ldaa    #00001100b              
        jsr     toggle_lcd_ctrl         ;display on, cursor off, blink off

        jsr     small_delay

        ldaa    #00000001b              
        jsr     toggle_lcd_ctrl         ;Clear display and return cursor to home

        jsr     small_delay

        ldaa    #01000000b        
        jsr     toggle_lcd_ctrl

        jsr     small_delay

        ldaa    #10000000b          
        jsr     toggle_lcd_ctrl

	ldx	#cgram_table
	ldab	#CGRAM_LEN
        jsr     line_update

        ldx     #disp_menu0
        stx     lcd_state

        ldx     #0
        stx     lcd_timer

        jsr     disp_clear

        rts

toggle_lcd_ctrl
        pshx

        ldx     #REG
        staa    SPDR,X                  ;Write byte to 75HC595
        brclr   SPSR,X SPIF *           ;Wait for SPIF
        ldaa    SPSR,x
        ldaa    SPDR,x                 ;Clear SPIF

        bclr    PORTD,x SSPIN          ;DRIVE SELECT OF 74HC595 LO
        nop
        bset    PORTD,x SSPIN          ;DRIVE SELECT OF 74HC595 HI
        nop
        bclr    PORTD,x SSPIN          ;DRIVE SELECT OF 74HC595 LO

        ldx     #XREG
        bclr    XPORTA,x lcd_ctrl
        nop
        bset    XPORTA,x lcd_enable     ;Pulse lcd enable
        nop
        bclr    XPORTA,x lcd_enable
        pulx
        rts


toggle_lcd_data
        pshx

        ldx     #REG
        staa    SPDR,X                  ;Write byte to 75HC595
        brclr   SPSR,X SPIF *           ;Wait for SPIF
        ldaa    SPSR,x
        ldaa    SPDR,x                 ;Clear SPIF

        bclr    PORTD,x SSPIN          ;DRIVE SELECT OF 74HC595 LO
        nop
        bset    PORTD,x SSPIN          ;DRIVE SELECT OF 74HC595 HI
        nop
        bclr    PORTD,x SSPIN          ;DRIVE SELECT OF 74HC595 LO

        ldx     #XREG
        bset    XPORTA,x lcd_data
        nop
        bset    XPORTA,x lcd_enable     ;Pulse lcd enable
        nop
        bclr    XPORTA,x lcd_enable
        pulx
        rts

;=============================================================================
;These subroutine displays the various messages in 2 second interval and are
; called in the main loop.
;

disp_menu0                      ;dummy display
        ldx     lcd_timer
        bne     lcd_ex0

        ldaa    #0
        staa    drow_var
        jsr     drow
        ldx     #MSG8
        jsr     dstr

        ldaa    #1
        staa    drow_var
        jsr     drow
        ldx     #MSG1
        jsr     dstr

        ldaa    #2
        staa    drow_var
        jsr     drow
        ldx     #MSG2
        jsr     dstr

        ldaa    #3
        staa    drow_var
        jsr     drow
        ldx     #MSG3
        jsr     dstr

        ldx     #disp_menu1
        stx     lcd_state

        ldx     #61
        stx     lcd_timer

lcd_ex0
        rts


disp_menu1
        ldx     lcd_timer
        bne     lcd_ex1

        ldaa    #0
        staa    drow_var
        jsr     drow
        ldx     #MSG1
        jsr     dstr

        ldaa    #1
        staa    drow_var
        jsr     drow
        ldx     #MSG2
        jsr     dstr

        ldaa    #2
        staa    drow_var
        jsr     drow
        ldx     #MSG3
        jsr     dstr

        ldaa    #3
        staa    drow_var
        jsr     drow
        ldx     #MSG9
        jsr     dstr

        ldx     #disp_menu2
        stx     lcd_state

        ldx     #61
        stx     lcd_timer
lcd_ex1
        rts

disp_menu2
        ldx     lcd_timer
        bne     lcd_ex2

        ldaa    #0
        staa    drow_var
        jsr     drow
        ldx     #MSG2
        jsr     dstr

        ldaa    #1
        staa    drow_var
        jsr     drow
        ldx     #MSG3
        jsr     dstr

        ldaa    #2
        staa    drow_var
        jsr     drow
        ldx     #MSG9
        jsr     dstr

        ldaa    #3
        staa    drow_var
        jsr     drow
        ldx     #MSG9
        jsr     dstr

        ldx     #disp_menu3
        stx     lcd_state

        ldx     #61
        stx     lcd_timer

lcd_ex2
        rts

disp_menu3
        ldx     lcd_timer
        bne     lcd_ex3

        ldaa    #0
        staa    drow_var
        jsr     drow
        ldx     #MSG3
        jsr     dstr

        ldaa    #1
        staa    drow_var
        jsr     drow
        ldx     #MSG9
        jsr     dstr

        ldaa    #2
        staa    drow_var
        jsr     drow
        ldx     #MSG9
        jsr     dstr

        ldaa    #3
        staa    drow_var
        jsr     drow
        ldx     #MSG9
        jsr     dstr

        ldx     #disp_menu0
        stx     lcd_state

        ldx     #61
        stx     lcd_timer

lcd_ex3
        rts

disp_menu4

        rts

;-----------------------------------------------------------------------------

; Clear Display
; -------------

disp_clear
	ldx	#disp_buffer		;starting address of display buffer
	stx	disp_ptr		;home cursor
        ldab    #80                     ;number of characters
	ldaa	#BL

dcl10
        staa    0,x                     ;fill buffer with spaces
	inx
	decb
	bne	dcl10
	ldaa	#1			;set flag for immediate display
        staa    disp_flag               ;  update

	rts

;-----------------------------------------------------------------------------

; Set Display Position
; --------------------
; This routine sets the display buffer pointer to the selected row
; and column position.  Values are assumed to be valid:  no range checking
; is performed.
;       Entry:  A contains row number (0 - 3)
;               B contains column number (0 - 19)

disp_pos
	ldx	#disp_buffer		;starting address of display buffer
	abx				;add column number
        ldab    #20
	mul
        abx                             ;add 20 x row number
	stx	disp_ptr
	rts
;-----------------------------------------------------------------------------

; Display Character
; -----------------
;	Entry:	A contains character to be displayed
;		B contains number of occurences (DISP_REP only)

disp_chr
	ldy	disp_ptr		;store character in display buffer
        cmpa    #$a6
	bne	dsc10
	ldaa	#4
dsc10
        staa    0,y
	iny
	bra	dispex

disp_rep
	ldy	disp_ptr
        cmpa    #$a6
	bne	drp10
	ldaa	#4

drp10	staa	0,y			;store character, decrement counter
	iny				;  and loop until done
	decb
	bne	drp10

dispex
        cpy     #disp_buffer+80
	blo	dsp10
	ldy	#disp_buffer
dsp10
        sty     disp_ptr
	ldaa	#1			;set flag for immediate display
	staa	disp_flag		;  update
	rts
;-----------------------------------------------------------------------------

; Display String
; --------------

disp_str
	ldy	disp_ptr

dst10
        ldaa    0,x
	beq	dst20
        cmpa    #$a6
	bne	dst15
	ldaa	#4

dst15
        staa    0,y
	inx
	iny
	bra	dst10

dst20
        inx
	bra	dispex

;--------
disp_strn
	ldy	disp_ptr

dsn10
        ldaa    0,x
        cmpa    #$a6
	bne	dsn15
	ldaa	#4

dsn15
        staa    0,y
	inx
	iny
	decb
	bne	dsn10

	bra	dispex
;-----------------------------------------------------------------------------
; Update Display
; --------------
;	This routine updates the LCD display from the display image in
; memory whenever the update flag is set.

disp_update
        ldaa    disp_flag               ;exit if display update flag is clr
        bmi     dupex                   ; 
	dec	disp_flag
	beq	dup10

        ldaa    #%00000010
        jsr     toggle_lcd_ctrl         ;home cursor

	bra	dupex

dup10
        ldab    #20                     ;number of characters per line

	ldx	#disp_buffer		;display 1st line
	jsr	line_update

	ldx	#disp_buffer+40		;display 3rd line
        jsr     line_update

	ldx	#disp_buffer+20		;display 2nd line
        jsr     line_update

	ldx	#disp_buffer+60		;display 4th line
        jsr     line_update

        ldaa    #%1100
        jsr     toggle_lcd_ctrl         ;display on, cursor off, blink off

dupex
        rts

;----------------------------------------------------------------------------
line_update
	pshb				;save character count

lup10	ldaa	0,x			;write character to display
	cmpa	#'0'			;  (substitue O for 0)
	bne	lup15
	ldaa	#'O'

lup15                                   ;Display Char to LCD
        jsr     toggle_lcd_data
        jsr     small_delay

	inx				;advance to next character, decrement
	decb				;  count & loop if not done
	bne	lup10
	pulb				;restore character count

	rts


;==============================================================================

; Set Cursor Position
; -------------------
;       A contains row number
;       B contains column number

drow
        ldaa    drow_var                ;drow_var = 0 =>1st line
;                                       ;drow_var = 1 =>2nd line
;                                       ;drow_var = 2 =>3rd line
;                                       ;drow_var = 3 =>4th line
	ldab	#0
	jsr	disp_pos
        rts

dpos    
        ldaa    drow_var                ;drow_var = 0 =>1st line
;                                       ;drow_var = 1 =>2nd line
;                                       ;drow_var = 2 =>3rd line
;                                       ;drow_var = 3 =>4th line

        ldab    dcol_var                ;dcol_var = 0 => 20 1st line
;                                       ;dcol_var = 0 => 20 2nd line
;                                       ;dcol_var = 0 => 20 3nd line
;                                       ;dcol_var = 0 => 20 4nd line

	jsr	disp_pos
        rts

; Display String
; --------------
;       X contains address of string to be displayed
;       B contains length of string (if absent:  nul terminates string)

dstr    
        jsr     disp_str
        rts

dstrn    
        jsr     disp_strn
        rts

dvalx   
        ldab    #5              ;will display 5 digit value
;        subb    #3              ;lenght of value
        subb    dig_lenght      ;lenght of value to be displayed
        abx                     ;Reg X contain the address to be displayed
        jsr     disp_strn
        rts

;-----------------------------------------------------------------------------
cgram_table
        fcb     %00000                 
        fcb     %00000
        fcb     %00000
        fcb     %00000
        fcb     %00000
        fcb     %00000
        fcb     %00000
        fcb     %00000


CGRAM_LEN       EQU     $-cgram_table

;-----------------------------------------------------------------------------

;Lcd Messages
MSG1            fcc     'LCD Routine Program.'
                fcb     0
MSG2            fcc     'This is a TEST......'
                fcb     0
MSG3            fcc     '--------------------'
                fcb     0
MSG4            fcc     'Msg4................'
                fcb     0
MSG5            fcc     'Msg5................'
                fcb     0
MSG6            fcc     'Msg6................'
                fcb     0
MSG7            fcc     'Msg7................'
                fcb     0
MSG8            fcc     'Technological Arts  '
                fcb     0
MSG9            fcc     '                    '
                fcb     0
MSG10           fcc     'Keyboard Test.......'
                fcb     0
MSG11           fcc     'Msg11...............'

;==============================================================================
; Keyboard Routines
; -----------------

keybd_init
        ldx     #REG
        bset    TCTL2,X %10000000     ; 
        bset    TMSK1,X %00001000      ;set interrupt for input capture 1
        bset    TFLG1,X %00001000 

        ldaa    #11
        staa    keybd_count

        ldx     #0
        stx     keybd_value
        stx     keyp_timer

clear_key
        clr     keybd_flag
        clr     release_flag
        clr     keybd_char
        clr     keybd_state
        clr     keyp_flag
        clr     keybd_timer
        clr     clr_flag

        ldx     #disp_buffer+20
        stx     key_ptr

        rts

keybrd_int
        ldaa    #10
        staa    keybd_timer

        ldx     #REG
        ldaa    PORTA,x
        rola
        ldd     keybd_value
        rora
        rorb
        std     keybd_value

        bset    TFLG1,x %00001000      ;Clear input capture 0 interrupt

        dec     keybd_count
        bne     keyex

        ldaa    #11
        staa    keybd_count

        inc     keybd_flag

        ldx     keybd_value+2
        stx     keybd_value+3
        ldaa    keybd_value
        rol     keybd_value+1
        rola
        rol     keybd_value+1
        rola
        staa    keybd_value+2

keyex
        rti

;
get_key
        ldaa    keybd_flag
        beq     gky90

        ldx     #keybd_value+2-1

        sei
        ldab    keybd_flag
        abx
        ldab    0,x
        dec     keybd_flag
        cli

        cmpb    #$e0                   ;skip if alternate? prefix
        beq     gky90

        cmpb    #$f0                   ;skip if release prefix
        bne     gky10

        inc     release_flag
        bra     gky90

gky10
        ldaa    release_flag
        beq     gky20

        clr     release_flag
        cmpb    #ALT
        bne     gky15

        bclr    keybd_state,%10
        bra     gky90

gky15
        cmpb    #CTRL
        bne     gky90
        bclr    keybd_state,%01
        bra     gky90

gky20
        tstb
        bmi     gky90
 
gky30
        ldx     #key_table_at
        abx
        ldaa    0,x
        staa    keybd_char

        ldaa    #1
        staa    keyp_flag

        ldaa    clr_flag
        bne     gky90

        ldaa    #0
        staa    drow_var
        jsr     drow
        ldx     #MSG10
        jsr     dstr
        inc     clr_flag

        ldaa    #1
        staa    drow_var
        jsr     drow
        ldx     #MSG9
        jsr     dstr

        ldaa    #2
        staa    drow_var
        jsr     drow
        ldx     #MSG9
        jsr     dstr

        ldaa    #3
        staa    drow_var
        jsr     drow
        ldx     #MSG9
        jsr     dstr

gky90   clra

gkyex
        rts

;BS      equ     8
;CR      equ     13h
;ESC     equ     1bh
;ALT     equ     11h
;CTRL    equ     14h
;F1      equ     05h
 
key_table_at
        fcb     0,0,0,0,0,F1,0,0,0,0,0,0,0,0,0,0

        fcb     0,ALT,0,0,CTRL
        fcc     'Q1'
        fcb     0,0,0
        fcc     'ZSAW2'
        fcb     0

        fcb      0
        fcc     'CXDE43'
        fcb     0,0
        fcc     ' VFTR5'
        fcb     0

        fcb      0
        fcc     'NBHGY6'
        fcb     0,0,0
        fcc     'MJU78'
        fcb     0

        fcb     0
        fcc     ',KIO09'
        fcb     0,0
        fcc     './L'
        fcb     $38
        fcc     'P-'
        fcb     0

        fcb     0,0,0,0
        fcc     '[='
        fcb     0,0,0,0,CR
        fcc     ']'
        fcb     0,0,0,0

        fcb     0,0,0,0,0,0,BS,0,0,0,0,0,0,0,0,0
        fcb     0,0,0,0,0,0,ESC,0,0,0,0,0,0,0,0,0


key_char_disp
        jsr     get_key         ;get keyboard value

        ldaa    keyp_flag       ;display value to lcd
        beq     disp_ex

        ldaa    keybd_char

        ldy     key_ptr
        cpy     #disp_buffer+40
        beq     line1

        cpy     #disp_buffer+80
        beq     line0
        bra     line2

line0
        psha
        ldaa    #1
        staa    drow_var
        jsr     drow
        ldx     #MSG9
        jsr     dstr

        ldaa    #2
        staa    drow_var
        jsr     drow
        ldx     #MSG9
        jsr     dstr

        pula

        ldy     #disp_buffer+20
        sty     key_ptr
        bra     line2

line1
        psha
        ldaa    #2
        staa    drow_var
        jsr     drow
        ldx     #MSG9
        jsr     dstr

        ldaa    #3
        staa    drow_var
        jsr     drow
        ldx     #MSG9
        jsr     dstr
        pula

        ldy     #disp_buffer+40
        sty     key_ptr

line2
        staa    0,y
        iny
        sty     key_ptr

        ldaa    #1
        staa    disp_flag
        clr     keybd_char

        ldx     #disp_menu4
        stx     lcd_state

        ldx     #61*30          ;30 second time out if no key press
        stx     keyp_timer

        clr     keyp_flag

disp_ex
        rts


;=============================================================================
*  SCI Input Interrupt Handler

*  Gets bytes from SCI.  Sets COMMAND_PENDING flag.

SerInputInt 
        ldy     #REG
        ldaa    SCSR,y            ;clear RDRF
        ldaa    SCDR,y
	staa	COMMAND

SIIX
	rti

SendString

*	x contains starting address of string
RV1:
	ldaa	0,X		;$FF denotes end of string
	cmpa	#$FF
	beq	RVX
        bsr     SendByte
	inx
	bra	RV1
RVX:
	rts	

SendByte

*  Transmits a byte, contained in register A, to the serial device via the SCI.

SB1
        ldy     #REG
        ldab    SCSR,y  ;wait for transmit data register empty (TDRE)
	bpl	SB1
        staa    SCDR,y  ;send byte
	rts

;=============================================================================

	ORG     0ffd6h

        dw     SerInputInt             ;SCI Receiver Interrupt
        dw     reset                   ;SPI
        dw     reset                   ;Pulse Accumulator Input Edge
        dw     reset                   ;Pulse Accumulator Overflow
        dw     reset                   ;Timer Overflow

        dw     keybrd_int              ;Timer Output Compare 5
                                        ; or Timer Input Capture 4

        dw     reset                   ;Timer Output Compare 4
        dw     reset                   ;Timer Output Compare 3
        dw     reset                   ;Timer Output Compare 2
        dw     reset                   ;Timer Output Compare 1

        dw     reset                   ;Timer Input Capture 3
        dw     reset                   ;Timer Input Capture 2
        dw     reset                   ;Timer Input Capture 1
        dw     real_time_int           ;Real Time Interrupt

        dw     reset                   ;IRQ Pin
        dw     reset                   ;XIRQ Pin
        dw     reset                   ;SWI
        dw     reset                   ;Illegal Opcode Trap
        dw     reset                   ;COP Failure
        dw     reset                   ;Clock Monitor Fail
        dw     reset                   ;RESET


