#include <hc11.h>

/*	Operational Constants	*/

#define TRUE    0xFF
#define FALSE   0x00
#define CR		0x0D
#define	BL		0x20

#define clrmsk	0xC0	/*	mask for clearing timer flags					*/
#define ptdmsk	0x3A	/*	output: ss, sck, mosi, txd; input: miso, rxd  	*/
#define sc2msk2 0x2C	/*	(sccr2)enable tx & rx and Rx Interrupt			*/

#define spimsk	0x50	/*	SPE,MSTR=1, CPOL,SWOM,CPHA=0 ; 1MHz				*/
void InitLCD(void);
void ClearLCD(void);
void Cursor(unsigned char,unsigned char);
void CursorOff(void);
void CursorHome(void);


void InitLCD(void){
	
	unsigned char x;
	unsigned short i;

	DDRD = ptdmsk ;		/*	initialize PORTD	*/
	PORTD &= 0xDF ;			/*	clear d5	*/
	SPCR = spimsk ; 	/*	SPE,MSTR=1, CPOL,SWOM,CPHA=0; 1MHz	*/
	
	x = SPSR ;
	x = SPDR ;		  	  

	Toggle_lcd_ctrl(0x38);	
	Delay();
	Toggle_lcd_ctrl(0x38);	
	Delay();
	Toggle_lcd_ctrl(0x38);	
	Small_delay();
	
	Cursor(0,0);
	
	ClearLCD();		
	
	Toggle_lcd_ctrl(0x40);
	
	Small_delay();
	
	Toggle_lcd_ctrl(0x80);
	Small_delay();
	
	CursorHome();
	
	Delay();
	
}

void ClearLCD(void){
	Toggle_lcd_ctrl(0x01);
	Delay();	
}
	
	
void DumpSpiData(char x){
	
	char y;
	SPDR = x ;
	while((SPSR & 0X80) == 0) ;
}

void Delay(void)
	{
	
	unsigned short x;
	
	for(x=0 ; x < 0x2000; x++);
	
	}
	
void Small_delay(void)
	{
	
	unsigned short x ;
	for(x=0 ; x < 0x8; x++);
	
	}


void Toggle_lcd_ctrl(char x)
	{
	
	char i ;
	
	DumpSpiData(x) ;
	
	PORTD |= 0x20 ;   	  	   /*	DRIVE SELECT OF 74HC595 HI	*/
	
	//for(i=0 ; i < 4 ; i++);
	
	PORTD &= 0xDF ;	  	   	   /*	DRIVE SELECT OF 74HC595 LO	*/

	
	PORTB &= 0xBF ;			   /*	DIS_RS low	*/				
	    
	
	//for(i=0 ; i < 4 ; i++);
	
	PORTB |= 0x80 ;	  	   	   /*	Pulse lcd enable	*/
	
	//for(i=0 ; i < 4 ; i++);	
	
	PORTB &= 0x7F ;
	
	}
	

void Toggle_lcd_data(char x){
	
	char i ;
	
	DumpSpiData(x) ;
	
	PORTD |= 0x20 ;   	  	   /*	DRIVE SELECT OF 74HC595 HI	*/
	
	PORTD &= 0xDF ;	  	   	   /*	DRIVE SELECT OF 74HC595 LO	*/

	
	PORTB |= 0x40 ;			   /*	DIS_RS high	*/
	
	
	PORTB |= 0x80 ;	  	   	   /*	Pulse lcd enable	*/
	
	PORTB &= 0x7F ;
	
}
	

void LCDPrint(char text[32]){
	 int x = 0;
	 int v = 0;
	 char data = 0;
	 for(x=0x0;x<=0x37;x++){
	 					data = 'x'; 
						if(x <= 0x0F){
							 data = text[v];
							 v++;
						}
						if(x >= 0x28){
							 data = text[v];
							 v++;
						}
						Toggle_lcd_data(data);
						Small_delay();
	 }
	 

}

void Cursor(unsigned char blink,unsigned char visible){
	 unsigned char cur;
	 
	 if(blink == 1){
	 	if(visible == 1){
		cur = 0x0F;
	 	}
		else{
		cur = 0x0D;
		}	  
	 }
	 else{
	 	  if(visible == 1){
	 	  cur = 0x0E;
	 	  }
		  else{
		  cur = 0x0C;
		  }
	 }
	 
	 Toggle_lcd_ctrl(cur);
	 Small_delay();
}

void CursorOff(void){
	 Toggle_lcd_ctrl(0x0C);
	 Small_delay();
}

void CursorHome(void){
	 Toggle_lcd_ctrl(0x02);
	 Small_delay();
}	