/*
*filename: vrpm24.c
*******************************************************************************
*REVISION HISTORY:
*
* DATE		REV. NO.	DESCRIPTION
*
* 4/18/94	1.0			Initial release in assambler by CARL BARNES
* 3/16/2000             Incorporate Speech board by JEFF YUAN
* 12/07/2000			Removed non-speech related code
*
*******************************************************************************
*TECHNOLOGICAL ARTS
*ADAPT11C24 SPEECH DEMO SOFTWARE

Recommend: power down input (PD) of the ISD2560 should be connected to ground.

Function for Voice Recorder/Playback module:

	User can set the memory of ISD2560 to 1,2,4,8,16,32, or 64 segments using
	key '+' or '-', and then record or playback in the selected segment.
	
*/


#include <stdio.h>

#if defined(_HC11)
#include <hc11.h>
#elif defined(_HC12)
#include <hc12.h>
#elif defined(_HC16)
#include <hc16.h>
#else
#error "no target defined"
#endif


/*  Operational Parameters	*/

#define _100MS		25
#define _250MS		61
#define _500MS		125
#define _1SECOND	250
#define _2SECONDS	500
#define _3SECONDS	750
#define _5SECONDS	1250
#define _10SECONDS	2500
#define _25SECONDS	6250
#define _60SECONDS	15000
#define _2MIN		30000

/*	Operational Constants	*/

#define TRUE    0xFF
#define FALSE   0x00
#define CR		0x0D
#define ESC		0x13

#define opts  	0x90	/* a/d on */
#define admask1	0x30	/* (adctl)continuous conversion, AD0 thru AD3		*/
#define admask2	0x34	/* (adctl)continuous conversion, AD4 thru AD7		*/
#define tmask	0x40	/* (tmsk2)no timer prescale, RTI enabled			*/
#define rtimsk	0x08	/* (pactl) 4.1 msec interrupt with 8 MHz xtal		*/
#define tc1msk	0x40	/*	OC2 in toggle mode								*/

#define clrmsk	0xC0	/*	mask for clearing timer flags					*/
#define ptdmsk	0x02	/*	(ddrd)portd data direction: input, except txd  	*/
#define sc2msk2 0x2C	/*	(sccr2)enable tx & rx and Rx Interrupt			*/

/*	constants for recorder	*/

#define EOM    0x01       /* EOM - Marker */
#define OVF    0x02       /* OVF - Overflow */
#define CE     0x80       /* CE* - Chip select */
#define PR     0x40       /* P/R* - Playback/Record */
#define PD     0x08       /* PD - Power down */




/* System Variables	*/

volatile unsigned char COMMAND, COMMAND_PENDING;
volatile unsigned short TIMER, HALF_PERIOD;

/* Recorder Variables */
volatile unsigned char RECORDER_FLAG, PLAYBACK_FLAG, SEGMENT_FLAG, SEGMENT_SET;
volatile unsigned char SEGMENT_NUM2,SEGMENT_NUM4, SEGMENT_NUM8, SEGMENT_NUM16,SEGMENT_NUM32, SEGMENT_NUM64;
volatile unsigned short RECORDING_TIMER, DOT_TIMER, ADDRESS;

#pragma	interrupt_handler SCIHandler;
#pragma	interrupt_handler RTIHandler;

void ProcessCommand(void);
void ShowMenu(void);

/* Functions for recorder */
void Init_recorder(void);

void Recorder(unsigned char x, unsigned short y, unsigned short z);
void Playback(unsigned char x, unsigned short y);


void main(void)
	{
	
	INTR_OFF();			/*	disable interrupts */
	
	OPTION = opts ;		/*	define system option	*/
	ADCTL = admask1 ;	/*	set A/D to scan AD0 thru AD3 continuously	*/        
	
	TMSK2 = tmask ;		/*	enable real-time interrupt (RTI)	*/
	PACTL = rtimsk;		/*	initialize RTI rate	*/
	
	DDRD = ptdmsk ;		/*	initialize PORTD	*/
	
	setbaud(BAUD2400);	/*	baud=2400	*/
	SCCR2=sc2msk2;		/*	enable SCI rcvr. & xmtr. & rx int. */
	/* getchar(); */
	
	Init_recorder() ;
	
	COMMAND = 0 ;
	TIMER = 0 ;
	
	INTR_ON();			/*	enable interrupts */

	while(1)
		{
				
		ProcessCommand();

		}
	}

void ProcessCommand(void)
	{
		
	if(COMMAND_PENDING)
		{
		
		COMMAND_PENDING = 0;

		/*putchar('\n'); */
		COMMAND |= 0X20;
		
		if(SEGMENT_FLAG)
			{
			
			switch(COMMAND)
				{
				case '+':
				
					if(!(SEGMENT_SET - 0x06)) SEGMENT_SET = 0 ;
					
					else SEGMENT_SET++ ;
				
					switch(SEGMENT_SET)
						{
						case 0:
							printf("	1 x 60 seconds");
							
							break ;
						case 1:
							printf("	2 x 30 seconds");	
							break ;
						case 2:
							printf("	4 x 15 seconds");	
							break ;
						case 3:
							printf("	8 x 7.5 seconds");	
							break ;
						case 4:
							printf("	16 x 3.75 seconds");	
							break ;
						case 5:
							printf("	32 x 1.8 seconds");	
							break ;
						case 6:
							printf("	64 x 0.9 seconds");	
							break ;
						default:;
						}
					putchar(CR);
					break ;
				
				case '-':
				
					if(!(SEGMENT_SET)) SEGMENT_SET = 0x06 ;
					
					else SEGMENT_SET-- ;
				
				    switch(SEGMENT_SET)
						{
						case 0:
							printf("	1 x 60 seconds");
							
							break ;
						case 1:
							printf("	2 x 30 seconds");	
							break ;
						case 2:
							printf("	4 x 15 seconds");	
							break ;
						case 3:
							printf("	8 x 7.5 seconds");	
							break ;
						case 4:
							printf("	16 x 3.75 seconds");	
							break ;
						case 5:
							printf("	32 x 1.8 seconds.");	
							break ;
						case 6:
							printf("	64 x 0.9 seconds");	
							break ;
						default:;
						}
				    
				    putchar(CR);
				    break ;
				    
				case '0':
					
					SEGMENT_FLAG = FALSE ;
					puts("");
					break ;
				
				default:;	
				
				}
			}
		
		
		else if(RECORDER_FLAG | PLAYBACK_FLAG)
				{
				
				switch(SEGMENT_SET)
						{
						case 0:
							
							switch(COMMAND)
								{
								
								case '0':
									if(RECORDER_FLAG) Recorder(1, 560, 14000);
									else Playback(1, 560);
									break ;
								
								default:
								
									RECORDER_FLAG = FALSE ;
									PLAYBACK_FLAG = FALSE ;
								}
										
							break ;
						
						case 1:
						
							
							switch(COMMAND)
								{
								
								case '+':
									
									if(!(SEGMENT_NUM2 - 2)) SEGMENT_NUM2 = 1;
									else SEGMENT_NUM2++;
									printf("	Segment %2d", SEGMENT_NUM2);	
									break ;		
								case '-':
								
									if(!(SEGMENT_NUM2 - 1)) SEGMENT_NUM2 = 2 ;
									else SEGMENT_NUM2--;
									printf("	Segment %2d", SEGMENT_NUM2);
							        break ;
								case '0':
								
									if(RECORDER_FLAG) Recorder(SEGMENT_NUM2, 280, 6400);
									else Playback(SEGMENT_NUM2, 280);
									break ;
								
								default:
									
									RECORDER_FLAG = FALSE ;
									PLAYBACK_FLAG = FALSE ;
								}	
													
							break ;
							
						case 2:
						
							switch(COMMAND)
								{
								
								case '+':
									
									if(!(SEGMENT_NUM4 - 4)) SEGMENT_NUM4 = 1;
									else SEGMENT_NUM4++;
									printf("	Segment %2d", SEGMENT_NUM4);	
									break ;		
								case '-':
								
									if(!(SEGMENT_NUM4 - 1)) SEGMENT_NUM4 = 4 ;
									else SEGMENT_NUM4--;
									printf("	Segment %2d", SEGMENT_NUM4);
							        break ;
								case '0':
								
									if(RECORDER_FLAG) Recorder(SEGMENT_NUM4, 140, 3200);
									else Playback(SEGMENT_NUM4, 140);
									break ;
								
								default:
									
									RECORDER_FLAG = FALSE ;
									PLAYBACK_FLAG = FALSE ;
								}
								
							break ;
							
						case 3:
							
							switch(COMMAND)
								{
								
								case '+':
									
									if(!(SEGMENT_NUM8 - 8)) SEGMENT_NUM8 = 1 ;
									else SEGMENT_NUM8++;
									printf("	Segment %2d", SEGMENT_NUM8);	
									break ;		
								case '-':
								
									if(!(SEGMENT_NUM8 - 1)) SEGMENT_NUM8 = 8 ;
									else SEGMENT_NUM8--;
									printf("	Segment %2d", SEGMENT_NUM8);
							        break ;
								case '0':
								
									if(RECORDER_FLAG) Recorder(SEGMENT_NUM8, 70, 1600 );
									else Playback(SEGMENT_NUM8, 70);
									break ;
								
								default:
									
									RECORDER_FLAG = FALSE ;
									PLAYBACK_FLAG = FALSE ;
								}
								
							break ;
							
						case 4:
							
							switch(COMMAND)
								{
								
								case '+':
									
									if(!(SEGMENT_NUM16 - 16)) SEGMENT_NUM16 = 1 ;
									else SEGMENT_NUM16++;
									printf("	Segment %2d", SEGMENT_NUM16);	
									break ;		
								case '-':
								
									if(!(SEGMENT_NUM16 - 1)) SEGMENT_NUM16 = 16 ;
									else SEGMENT_NUM16--;
									printf("	Segment %2d", SEGMENT_NUM16);
							        break ;
								case '0':
								
									if(RECORDER_FLAG) Recorder(SEGMENT_NUM16, 36, 800);
									else Playback(SEGMENT_NUM16, 36);	
									break ;
								
								default:
									
									RECORDER_FLAG = FALSE ;
									PLAYBACK_FLAG = FALSE ;
								}
							
							break ;
						case 5:
						
							switch(COMMAND)
								{
								
								case '+':
									
									if(!(SEGMENT_NUM32 - 32)) SEGMENT_NUM32 = 1 ;
									else SEGMENT_NUM32++;
									printf("	Segment %2d", SEGMENT_NUM32);	
									break ;		
								case '-':
								
									if(!(SEGMENT_NUM32 - 1)) SEGMENT_NUM32 = 32 ;
									else SEGMENT_NUM32--;
									printf("	Segment %2d", SEGMENT_NUM32);
							        break ;
								case '0':
								
									if(RECORDER_FLAG) Recorder(SEGMENT_NUM32, 18, 400);
									else Playback(SEGMENT_NUM32, 18);
									break ;
								
								default:
									
									RECORDER_FLAG = FALSE ;
									PLAYBACK_FLAG = FALSE ;
								}
						
							break ;
						case 6:
						
							switch(COMMAND)
								{
								
								case '+':
									
									if(!(SEGMENT_NUM64 - 64)) SEGMENT_NUM64 = 1 ;
									else SEGMENT_NUM64++;
									printf("	Segment %2d", SEGMENT_NUM64);	
									break ;		
								case '-':
								
									if(!(SEGMENT_NUM64 - 1)) SEGMENT_NUM64 = 64 ;
									else SEGMENT_NUM64--;
									printf("	Segment %2d", SEGMENT_NUM64);
							        break ;
								case '0':
								
									if(RECORDER_FLAG) Recorder(SEGMENT_NUM64, 0x9, 200);
									else Playback(SEGMENT_NUM64,0x9);
									break ;
								
								default:
									
									RECORDER_FLAG = FALSE ;
									PLAYBACK_FLAG = FALSE ;
								}
							
							break ;
					
						default:;
					
						}	
				putchar(CR);				
				}
			 

		else
			{
			switch(COMMAND)
				{  
			
				case 'n':
				
					puts("\n");
					SEGMENT_FLAG = TRUE ;
					puts("	+/- selects segment");
					puts("	0 to confirm and exit\n");
					
					switch(SEGMENT_SET)
						{
						case 0:
							printf("	1 x 60 seconds");
							
							break ;
						case 1:
							printf("	2 x 30 seconds");	
							break ;
						case 2:
							printf("	4 x 15 seconds");	
							break ;
						case 3:
							printf("	8 x 7.5 seconds");	
							break ;
						case 4:
							printf("	16 x 3.75 seconds");	
							break ;
						case 5:
							printf("	32 x 1.8 seconds.");	
							break ;
						case 6:
							printf("	64 x 0.9 seconds");	
							break ;
						default:;
						}	
					
					putchar(CR);
					break ;
								
				case 'p':
						
					puts("\n");	
					PLAYBACK_FLAG = TRUE ;
					PORTC |= CE ;		/* Set CE* high */
					PORTC |= PR ;		/* Set P/R* high */
					/*PORTC &= ~PD ;*/		/* Set PD low */
					
					switch(SEGMENT_SET)
						{
						case 0:
							printf("	1 x 60  seconds");
							printf("\n	0 to play");
							break ;
						case 1:
							printf("	2 x 30  seconds");	
							printf("\n	+/- selects segment\n");
							printf("	0 to play\n");
							printf("	Segment %2d", SEGMENT_NUM2);
							break ;
						case 2:
							printf("	4 x 15  seconds");	
							printf("\n	+/- selects segment\n");
							printf("	0 to play\n");
							printf("	Segment %2d", SEGMENT_NUM4);
							break ;
						case 3:
							printf("	8 x 7.5 seconds");	
							printf("\n	+/- selects segment\n");
							printf("	0 to play\n");
							printf("	Segment %2d", SEGMENT_NUM8);
							break ;
						case 4:
							printf("	16 x 3.7 seconds");	
							printf("\n	+/- selects segment\n");
							printf("	0 to play\n");
							printf("	Segment %2d", SEGMENT_NUM16);
							break ;
						case 5:
							printf("	32 x 1.8 seconds");	
							printf("\n	+/- selects segment\n");
							printf("	0 to play\n");
							printf("	Segment %2d", SEGMENT_NUM32);
							break ;
						case 6:
							printf("	64 x 0.9 seconds");	
							printf("\n	+/- selects segment\n");
							printf("	0 to play\n");
							printf("	Segment %2d", SEGMENT_NUM64);
							break ;
						default:;
						}
					
					putchar(CR);
					break ;
			
				case 'r':
			
					puts("\n");
					RECORDER_FLAG = TRUE ;
					PORTC |= CE ;		/* Set CE* high */
					PORTC &= ~PR ;		/* Set P/R* low */
					/*PORTC &= ~PD ;*/		/* Set PD low */
					
					switch(SEGMENT_SET)
						{
						case 0:
							printf("	1 x 60 seconds");
							printf("\n	0 to record");
							break ;
						case 1:
							printf("	2 x 30  seconds");	
							printf("\n	+/- selects segment\n");
							printf("	0 to record\n");
							printf("	Segment %2d", SEGMENT_NUM2);
							break ;
						case 2:
							printf("	4 x 15  seconds");	
							printf("\n	+/- selects segment\n");
							printf("	0 to record\n");
							printf("	Segment %2d", SEGMENT_NUM4);
							break ;
						case 3:
							printf("	8 x 7.5 seconds");	
							printf("\n	+/- selects segment\n");
							printf("	0 to record\n");
							printf("	Segment %2d", SEGMENT_NUM8);
							break ;
						case 4:
							printf("	16 x 3.7 seconds");	
							printf("\n	+/- selects segment\n");
							printf("	0 to record\n");
							printf("	Segment %2d", SEGMENT_NUM16);
							break ;
						case 5:
							printf("	32 x 1.8 seconds");	
							printf("\n	+/- selects segment\n");
							printf("	0 to record\n");
							printf("	Segment %2d", SEGMENT_NUM32);
							break ;
						case 6:
							printf("	64 x 0.9 seconds");	
							printf("\n	+/- selects segment\n");
							printf("	0 to record\n");
							printf("	Segment %2d", SEGMENT_NUM64);
							break ;
						default:;
						}
					
					putchar(CR);							
					break ;	
			
				case 'h':
					break ;
						
				default:
				
					ShowMenu();
			
				}
			}
		}
	}
	


 
void ShowMenu(void)
	{
	puts("\n");
	puts("	N  => SELECT THE NUMBER OF RECORD SEGMENTS");
	puts("	P  => PLAY RECORDED MESSAGE");
	puts("	R  => RECORD A MESSAGE");
	puts("	H  => STOP RECORDING");
	putchar('?');
	
	}




void Init_recorder(void)
	{
	
	RECORDER_FLAG = FALSE ;
	PLAYBACK_FLAG = FALSE ;
	SEGMENT_SET = 0 ;
	SEGMENT_NUM2 = 1;
	SEGMENT_NUM4 = 1;
	SEGMENT_NUM8 = 1;
	SEGMENT_NUM16 = 1;
	SEGMENT_NUM32 = 1;
	SEGMENT_NUM64 = 1;
	ADDRESS = 0;
		
	DDRC |= 0xF0 ;		/* PortC bit 4 to 7 are outputs*/
	PORTC |= 0xC0 ;	 	/* Disable the ISD2560 */
	
	}


void Recorder(unsigned char x, unsigned short y, unsigned short z)
	{
	
	unsigned char i;
	
	PORTC |= CE ;		/* Set CE* high */
	PORTC &= ~PR ;		/* Set P/R* low */
	
	
	ADDRESS = (x-1) * y;
	
	PORTB = ADDRESS ;
	
	ADDRESS = ADDRESS >> 4 ;
	
	ADDRESS &= 0x30 ;
	
	ADDRESS |= 0x80 ;
	
	PORTC = ADDRESS ;
		
	
	printf("\n	Segment %d record:\n",x) ;
	
	for(i=0; i < 0xFF; i++);
	
	
	PORTC &= ~CE ;		/* Enable record */
	
	RECORDING_TIMER = z ;
	
	DOT_TIMER = 230;
				
	while(RECORDING_TIMER)
		{
		
		if(!(DOT_TIMER))
			{
			
			printf(".");
			DOT_TIMER = 230 ;
			
			}
		}
	
	PORTC |= CE ;
	
	RECORDER_FLAG = FALSE ;
	
	puts("	End");
	
	}



void Playback(unsigned char x, unsigned short y )
	{
	
	PORTC |= (CE|PR) ;		/* Set CE, P/R* high */
		
	ADDRESS = (x-1) * y;
	
	PORTB = ADDRESS ;
	
	ADDRESS = ADDRESS >> 4 ;
	
	ADDRESS &= 0x30 ;
	
	ADDRESS |= 0xC0 ;
	
	PORTC = ADDRESS ;


	printf("\n	Segment %d Playback:\n", x) ;
	
	for(x=0; x < 0xFF; x++);

	PORTC &= ~CE ;		/* Enable playback */
	
		
	for(x=0; x < 0xFF; x++);
	
	PORTC |= CE ;
	
	while(PORTA&EOM);		/* Loop till end of marker reach */
	
	PLAYBACK_FLAG = FALSE ;
	
	puts("	End");
	
	}



/*  SCI Input Interrupt Handler

	Gets bytes from SCI.  Sets COMMAND_PENDING flag.	*/


void SCIHandler(void)
	{
	
	COMMAND = getchar();
	COMMAND_PENDING = TRUE ;
	if(!((COMMAND - 'H')&(COMMAND - 'h')))
		RECORDING_TIMER = 0 ;
	}



/*	Real-time Interrupt Routine	*/

void RTIHandler(void)
	{
	
	TFLG2 = 0x40 ;		/*	clear real-time interrupt flag	*/
	if(TIMER) TIMER--;
	if(RECORDING_TIMER) RECORDING_TIMER--;
	if(DOT_TIMER) DOT_TIMER--;			
	}	


extern void _start(void);	/* entry point in crt??.s */
extern void SCIHandler(void);
extern void RTIHandler(void);

#define DUMMY_ENTRY	(void (*)(void))0xFFFF

#pragma abs_address:0xffd6

void (*interrupt_vectors[])(void) = 
	{

	SCIHandler,	/* SCI */
	DUMMY_ENTRY,	/* SPI */
	DUMMY_ENTRY,	/* PAIE */
	DUMMY_ENTRY,	/* PAO */
	DUMMY_ENTRY,	/* TOF */
	DUMMY_ENTRY,	/* TOC5 */	/* HC12 TC7 */
	DUMMY_ENTRY,	/* TOC4 */	/* TC6 */
	DUMMY_ENTRY,	/* TOC3 */	/* TC5 */
	DUMMY_ENTRY,	/* TOC2 */	/* TC4 */
	DUMMY_ENTRY,	/* TOC1 */	/* TC3 */
	DUMMY_ENTRY,	/* TIC3 */	/* TC2 */
	DUMMY_ENTRY,	/* TIC2 */	/* TC1 */
	DUMMY_ENTRY,	/* TIC1 */	/* TC0 */
	RTIHandler,	/* RTI */
	DUMMY_ENTRY,	/* IRQ */
	DUMMY_ENTRY,	/* XIRQ */
	DUMMY_ENTRY,	/* SWI */
	DUMMY_ENTRY,	/* ILLOP */
	DUMMY_ENTRY,	/* COP */
	DUMMY_ENTRY,	/* CLM */
	_start	/* RESET */
	};
#pragma end_abs_address






