;INT.ASM
*******************************************************************************
*REVISION HISTORY:
*
*DATE                   REV. NO.        DESCRIPTION
*
*0102214                V1.00           X-Y-Z Stepper board 
********************************************************************************
*AUTHOR: EXEQUIEL RARAMA
;
;
;This is where RTI is service.
;
; ---------------------------
; X-Y-Z Stepper Board - Interrupt Routines
; ---------------------------

	INCLUDE REG.INC                 ;register block starting address
	INCLUDE REGS.INC                ;register block addresses
	INCLUDE	SYS.MAC

; Public Routines

	PUBLIC  real_time_init          ;initialize real time parameters
	PUBLIC  real_time_int           ;real time interrupt routine
        PUBLIC  dummy_int
        PUBLIC  SerInputInt
        PUBLIC  SendByte

; Public Variables

        PUBLIC  ad1
        PUBLIC  ad2
        PUBLIC  ad3
        PUBLIC  ad4

; External Routines


	PAGE0

; External Variables

        EXTERN  state_timer
        EXTERN  stepper_timer

        EXTERN  COMMAND
        EXTERN  COMMAND_PENDING



;local variables
int_flag        ds      1
counter         ds      1

ad1             ds      1               ;A/D channel 1:
ad2             ds      1               ;A/D channel 2: 
ad3             ds      1               ;A/D channel 3:
ad4             ds      1               ;A/D channel 4:

	CODE

;=============================================================================
; Initialize Real Time Parameters
; -------------------------------

real_time_init
	ldx     #REG
	ldaa    #00110000b              ;initialize A/D (2nd set of channels,

        staa    _ADCTL,X                ;  continuous scan & multiple channel)
        bset    _PACTL,X,00001000b      ;set real-time interrupt rate (4.096ms)
        bset    _TMSK2,X,01000000b      ;  & enable interrupts

	rts

;=============================================================================

; Real-Time Interrupt Routine
; ---------------------------

real_time_int
	ldx     #REG
	ldaa    #01000000b              ;clear real-time interrupt flag
	staa    _TFLG2,X
        cli

 
;--------
; Timers
;--------
;State timer is decremented here

time20
        ldx     state_timer
        beq     time30
	dex
	stx     state_timer

time30
        ldx     stepper_timer
        beq     time40
	dex
        stx     stepper_timer

time40

timex

dummy_int
	rti

*  SCI Input Interrupt Handler

*  Gets bytes from SCI.  Sets COMMAND_PENDING flag.

SerInputInt 
        ldy     #REG
        ldaa    _SCSR,y            ;clear RDRF
        ldaa    _SCDR,y
	staa	COMMAND

SIIX
        ldaa    #'i'
        jsr     SendByte

	rti

SendString

*	x contains starting address of string
RV1:
	ldaa	0,X		;$FF denotes end of string
	cmpa	#$FF
	beq	RVX
        bsr     SendByte
	inx
	bra	RV1
RVX:
	rts	

SendByte

*  Transmits a byte, contained in register A, to the serial device via the SCI.

SB1
        ldy     #REG
        ldab    _SCSR,y  ;wait for transmit data register empty (TDRE)
	bpl	SB1
        staa    _SCDR,y  ;send byte
	rts


	END

