;MAIN.ASM
*******************************************************************************
*REVISION HISTORY:
*
*DATE                   REV. NO.        DESCRIPTION
*
*0102214                V1.00           X-Y-Z Stepper board 
********************************************************************************
*AUTHOR: EXEQUIEL RARAMA
;
; ---------------------
; XYZ Stepper Board - Main Routine
; ---------------------

	INCLUDE REG.INC                 ;register block starting address
	INCLUDE REGS.INC                ;register block addresses

; Public routines

	PUBLIC  reset
	PUBLIC  delay
        PUBLIC  main

; Public variables

	PUBLIC	state
        PUBLIC  COMMAND
        PUBLIC  COMMAND_PENDING

; External subroutines

	EXTERN  real_time_init
	EXTERN  real_time_int
	EXTERN  dummy_int
        EXTERN  go_power

        EXTERN  SerInputInt
        EXTERN  SendByte

        EXTERN  stepper_init
        EXTERN  stepper_state

        PAGE0

state           ds      2
COMMAND         ds      1       ;used by ProcessCommand
COMMAND_PENDING ds      1       ;used by ProcessCommand

		CODE

bdmsk96	equ	%00110000	;(baud) 9600 baud with 8 MHz crystal
bdmsk24	equ	%00110010	;(baud) 2400 baud with 8 MHz crystal
bdmsk12	equ	%00110011	;(baud) 1200 baud with 8 MHz crystal
ptdmsk	equ 	%00000010	;(ddrd)portd data direction: input, except txd
sc2msk2	equ	%00101100	;(sccr2)enable tx & rx and Rx Interrupt

;-----------------
; Start of Program
; ----------------
reset
        sei                             ;disabel interrupt
	lds     #ffh                    ;initialize stack to top of ram
        ldx     #REG                    ;base address 1000h
	clra
	staa    _BPROT,x

        ldaa    #10010011b              ;start A/D converter, set IRQ to level,
        staa    OPTION                  ;  disable clock monitor, COP timer

        ldaa    #bdmsk96                ;baud=9600
        staa    _BAUD,x
	ldaa	#sc2msk2
        staa    _SCCR2,x                ;enable SCI rcvr. & xmtr. & rx int.
        ldaa    _SCDR,x                 ;dummy read to flush receive buffer

        jsr     real_time_init          ;initialize RTI and other interrupts
        jsr     go_power                ;initialize power on state

        jsr     stepper_init            ;initialize stepper board

	cli                             ;enable interrupts

;------------------
;Main Program Loop*
;------------------
;
main
	ldx     #REG
	ldaa    #55h                    ;reset watchdog timer
	staa    _COPRST,x
	ldaa    #0aah
	staa    _COPRST,X

        ldx     state                   ;execute current state
        jsr     0,x

        ldx     stepper_state           ;execute current stepper state
        jsr     0,x

        bra     main

;--------------------
delay
        pshy
        ldy     #$3333
dsi10   dey
	bne     dsi10
        puly
	rts

;=============================================================================
VECT    SECTION

	ORG     0ffd6h

        dw      SerInputInt             ;SCI Receiver Interrupt
	dw      reset                   ;SPI
	dw      reset                   ;Pulse Accumulator Input Edge
	dw      reset                   ;Pulse Accumulator Overflow
	dw      reset                   ;Timer Overflow
        dw      reset                   ;Timer Output Compare 5
        dw      reset                   ;Timer Output Compare 4
	dw      reset                   ;Timer Output Compare 3
        dw      reset                   ;Timer Output Compare 2
	dw      reset                   ;Timer Output Compare 1
	dw      reset                   ;Timer Input Capture 3
	dw      reset                   ;Timer Input Capture 2
        dw      reset                   ;Timer Input Capture 1
        dw      real_time_int           ;Real Time Interrupt
        dw      reset                   ;IRQ Pin
	dw      reset                   ;XIRQ Pin
	dw      reset                   ;SWI
	dw      reset                   ;Illegal Opcode Trap
	dw      reset                   ;COP Failure
	dw      reset                   ;Clock Monitor Fail
	dw      reset                   ;RESET

	END
