;STATES.ASM
*******************************************************************************
*REVISION HISTORY:
*
*DATE                   REV. NO.        DESCRIPTION
*
*0102214                V1.00           X-Y-Z Stepper board 
********************************************************************************
*AUTHOR: EXEQUIEL RARAMA
;
;
;STATES.ASM
; -----------------------
; X-Y-Z Stepper board - State Routines
; -----------------------

	INCLUDE SYS.MAC                 ;system macros
	INCLUDE REG.INC                 ;register block starting address
	INCLUDE REGS.INC                ;register block addresses
 
; Public Routines

	PUBLIC  go_power                ;enter POWER ON state

; Public Variables

	PUBLIC  state_timer             ;general purpose state timer

; Extern Routines

        EXTERN  delay
        EXTERN  main
        EXTERN  SendByte

	PAGE0

; External Variables
        EXTERN  speech_address
        EXTERN  COMMAND
 
state_timer     ds      2               ;general purpose state timer
record_flag     ds      1

	CODE

; Local Constants

SECOND          EQU     61              ;number of timer interrupts per second
MINUTE          EQU     60*SECOND       ;number of timer interrupts per minute

EOM             EQU     %00000001       ;EOM - Marker
OVF             EQU     %00000010       ;OVF - Overflow
CE              EQU     %00000001

;=============================================================================

; Power-On State
; --------------
;       This state is entered only upon initial power up.

go_power
        ldx     #REG

        ldx     #ex_state
        stx     state

        rts

ex_state

        rts

	END

 
