*filename: xystep.asm - Stepper motor routine
*******************************************************************************
*REVISION HISTORY:
*
*DATE                   REV. NO.        DESCRIPTION
*
*0102214                V1.00           X-Y-Z Stepper board 
********************************************************************************
*AUTHOR: EXEQUIEL RARAMA
*-----------------------------------------------------------------------------
*Port B pin assignment
ZDIR    EQU     %1              ;Port B, bit 0
ZSTEP   EQU     %10             ;Port B, bit 1
YDIR    EQU     %100            ;Port B, bit 2
YSTEP   EQU     %1000           ;Port B, bit 3
XDIR    EQU     %10000          ;Port B, bit 4
XSTEP   EQU     %100000         ;Port B, bit 5
ZHALF   EQU     %1000000        ;Port B, bit 6
YHALF   EQU     %10000000       ;Port B, bit 7

*-----------------------------------------------------------------------------
*Port C pin assignment
XHALF   EQU     %1              ;Port C, bit 0
ZCTRL   EQU     %10             ;Port C, bit 1
YCTRL   EQU     %100            ;Port C, bit 2
XCTRL   EQU     %1000           ;Port C, bit 3
XYZEN   EQU     %10000          ;Port C, bit 4

*-----------------------------------------------------------------------------
	INCLUDE REG.INC                 ;register block starting address
	INCLUDE REGS.INC                ;register block addresses

;Public variables
        PUBLIC  stepper_timer
        PUBLIC  stepper_state
        PUBLIC  stepper_init

;Extern variables

        PAGE0
stepper_timer   ds      2
stepper_state   ds      2
step            ds      1

        CODE

stepper_init
        ldx     #REG
        ldaa    #XHALF+ZCTRL+YCTRL+XCTRL+XYZEN
        staa    _DDRC,x
        staa    _PORTC,x
        bclr    _PORTC,XHALF
 
        ldaa    #YHALF+ZHALF+XSTEP+XDIR+YSTEP+YDIR+ZSTEP+ZDIR
        staa    _PORTB,x
        bclr    _PORTB,x,YHALF+ZHALF

        ldx     #step1_state
        stx     stepper_state

        ldx     #0
        stx     stepper_timer

	rts

step1_state
        ldx     stepper_timer
        bne     stx1

        ldx     #REG
        bset    _PORTB,x,#XSTEP+YSTEP+ZSTEP
        ldx     #step2_state
        stx     stepper_state

        ldx     #5
        stx     stepper_timer

stx1
        rts

step2_state
        ldx     stepper_timer
        bne     stx2

        ldx     #REG
        bclr    _PORTB,x,#XSTEP+YSTEP+ZSTEP
        ldx     #step1_state
        stx     stepper_state

        ldx     #5
        stx     stepper_timer

stx2
        rts


        END


