/*
*filename: receive.c
*******************************************************************************
*REVISION HISTORY:
*
* DATE		REV. NO.	DESCRIPTION
*
* 4/26/2000		 0		Initial release by JEFF YUAN
* 
*
*
*******************************************************************************
*TECHNOLOGICAL ARTS
*Embedded ethernet card demo

*	In this demo program, I use 'pktTypeH' and 'pktTypeL' to hold the number 
	of the data. You can make it for other uses.	

Function: Receive message from the LAN and then send it out through 232 port.

*/



/*	IP address IP1.IP2.IP3.IP4	*/

#include <hc11.h>
/*#include <stdio.h>*/

#define IP1	193 
#define IP2	168
#define IP3	96
#define IP4	155

/*	MAC address MAC1-MAC2-MAC3-MAC4-MAC5-MAC6	*/

#define MAC1	0x09
#define MAC2	0x08
#define MAC3	0x07
#define MAC4	0x06
#define MAC5	0x05
#define MAC6	0x04

/*	Crystal CS8900A PacketPage	*/

#define portRxTxDataL	*(unsigned char volatile *)0x7B00
#define portRxTxDataH	*(unsigned char volatile *)0x7B01
#define portRxTxData1L	*(unsigned char volatile *)0x7B02
#define portRxTxData1H	*(unsigned char volatile *)0x7B03
#define portTxCmdL		*(unsigned char volatile *)0x7B04
#define portTxCmdH		*(unsigned char volatile *)0x7B05
#define portTxLengthL	*(unsigned char volatile *)0x7B06
#define portTxLengthH	*(unsigned char volatile *)0x7B07
#define portISQL		*(unsigned char volatile *)0x7B08
#define portISQH		*(unsigned char volatile *)0x7B09
#define portPtrL		*(unsigned char volatile *)0x7B0A
#define portPtrH		*(unsigned char volatile *)0x7B0B
#define portDataL		*(unsigned char volatile *)0x7B0C
#define portDataH		*(unsigned char volatile *)0x7B0D
#define portData1L		*(unsigned char volatile *)0x7B0E
#define portData1H		*(unsigned char volatile *)0x7B0F

#define ppEISA		0x0000
#define ppProdID	0x0002
#define ppIOBase	0x0020
#define ppIntNum	0x0022
#define ppMemBase	0x002C
#define ppRxCfg		0x0102
#define ppRxCtl		0x0104
#define ppTxCfg		0x0106
#define ppTxCmdRd	0x0108
#define vppBufCfg	0x010A
#define ppLineCtl	0x0112
#define ppSelfCtl	0x0114
#define ppBusCtl	0x0116
#define ppTestCtl	0x0118
#define ppISQ		0x0120
#define ppRxEvt		0x0124
#define ppTxEvt		0x0128
#define ppBufEvt	0x012C
#define ppRxMiss	0x0130
#define ppTxCol		0x0132
#define ppLineSt	0x0134
#define ppSelfSt	0x0136
#define ppBusSt		0x0138
#define ppTxCmd		0x0144
#define ppTxLength	0x0146
#define ppIndAddr	0x0158
#define ppRxStat	0x0400
#define ppRxLength	0x0402
#define ppRxFrame	0x0404
#define ppTxFrame	0x0A00
 
#define REG_NUM_MASK	0x003F
#define REG_NUM_RX_EV	0x0004
#define REG_NUM_TX_EV	0x0008
#define REG_NUM_BF_EV	0x000C
#define REG_NUM_RX_MS	0x0010
#define REG_NUM_TX_CL	0x0012

#define SELF_CTL_RST	0x0040
#define SELF_CTL_HC1E	0x2000
#define SELF_CTL_HCB1	0x8000

#define LNCTL_10BT_OF	0x0000			/* Rx and Tx off */
#define LNCTL_10BT_ON	0x0060			/* Rx and Tx on */

#define LINE_CTL_10BT	0x0000

#define TEST_CTL_FDX	0x4000

#define RX_CFG_RXOKIE	0x0100

#define RX_CTL_RX_OKA	0x0100
#define RX_CTL_IND_A	0x0400
#define RX_CTL_BCASTA	0x0800

#define TX_CFG_ALL_IE	0x8FC0

#define TX_CMD_STRTAL	0x00C0




/*	Ethernet packet offsets	*/

#define pktLenH		0x00
#define pktLenL		0x01
#define pktDest0H	0x02
#define pktDest0L	0x03
#define pktDest1H	0x04
#define pktDest1L	0x05
#define pktDest2H	0x06
#define pktDest2L	0x07
#define pktSrc0H	0x08
#define pktSrc0L	0x09
#define pktSrc1H	0x0A
#define pktSrc1L	0x0B
#define pktSrc2H	0x0C
#define pktSrc2L	0x0D
#define pktTypeH	0x0E
#define pktTypeL	0x0F

/* with IP	*/

#define ip_verlen	0x10
#define ip_tos		0x11
#define ip_len		0x12
#define ip_id		0x14
#define ip_fragoff	0x16
#define ip_ttl		0x18
#define ip_proto	0x19
#define ip_cksum	0x1A
#define ip_src		0x1C
#define ip_dst		0x20
#define ip_data		0x24

/* system instants */

#define sc2msk2 	0x2C	/*	(sccr2)enable tx & rx and Rx Interrupt			*/
#define CR			0x0D

void Init_CS8900(void);
void Poll_Chip(void);
void TxPacket(void);
void LoadPacket(unsigned short x, unsigned short y);
unsigned short ReadPP(unsigned short x);
void WritePP(unsigned short x, unsigned short y);
void VWAIT(void);

void Pcad(unsigned char x, char *s);
void putchar(char x);
int puts(const char *s);

char *ptr, PacketRAM[64];


void main(void)
	{
	
	unsigned char i;
	
	setbaud(BAUD2400);	/*	baud=2400	*/
	SCCR2=sc2msk2;		/*	enable SCI rcvr. & xmtr. & rx int. */
	
	Init_CS8900();
	
			
	while(1)
		{			
			
		Poll_Chip();
			
		
		for(i=0x10; i<(0x10+PacketRAM[pktTypeL]); i++)
			{
			putchar(PacketRAM[i]);
			}
		puts("\n");		
		
		}		
	
	
	}
	
	
	
void Init_CS8900(void)
	{
	
	unsigned short x;
	unsigned char y,z;
	
	puts("ok");
	
	x = ReadPP(ppEISA);
	
	y = x;
	z = x>>8;
	
	
	Pcad(y, "	EISA0 ");
	Pcad(z, "	EISA1 ");
	

	/* WritePP(ppSelfCtl, SELF_CTL_RST) ;
		VWAIT();*/
	
	WritePP(ppLineCtl, LNCTL_10BT_OF);		/* Set to 10 Base T */
	WritePP(ppTestCtl, TEST_CTL_FDX);		/* Set to full duplex */
	WritePP(ppRxCfg, RX_CFG_RXOKIE) ;
	
	WritePP(ppRxCtl, (RX_CTL_RX_OKA | RX_CTL_IND_A | RX_CTL_BCASTA));
	WritePP(ppTxCfg, TX_CFG_ALL_IE);
	
	WritePP(ppIndAddr, 0x0606);
	WritePP(ppIndAddr+2, 0x0606);
	WritePP(ppIndAddr+4, 0x0606);

	WritePP(ppIntNum,0);
	

	x = ReadPP(ppBusCtl);
	x |= 0x8000;
	WritePP(ppBusCtl, x); 
	
	x = ReadPP(ppLineCtl);
	x |= 0x00C0;
	WritePP(ppLineCtl, x); 		/* Enable Rx and Tx */
	

	puts("\nCS8900 initialised ");
	
	}






void Poll_Chip(void)
	{
	
	unsigned char x, y ;
	unsigned short i,j;
	
/* modify later while((x <> 0x4)|(!(y & 0x01)));*/	
	do {
		y = portISQH;
		x = portISQL;
	/*	Pcad(y, "ISQH ");
		Pcad(x, "ISQL ");*/
		}while((0x4 - x)||(!(y&0x01)));		/*	Check for a received frame in ISQ.
												Will also clear any previously
												received frame via "implied Skip"
												see page 84 of CS8900 product info.
												For "implied Skip" to work, Status
												and Length of frame must be read. */

	
	y = portRxTxDataH;						
	x = portRxTxDataL;						/*	Read and discard status */
	
	y = portRxTxDataH;						
	x = portRxTxDataL;						/*	Read pcket length */

	
	PacketRAM[pktLenH] = y ;
	PacketRAM[pktLenL] = x ;

	
	LoadPacket(pktDest0H, 14);				/* 	Start by reading ethernet header
												dest MAC (6) + source MAC (6) + type (2) = 14 */

	i = PacketRAM[pktTypeH];
	j = PacketRAM[pktTypeL];
	
	j = ((i<<8) & 0xFF00)|(j & 0x00FF) ;
	
	LoadPacket(ip_verlen, j);
			
	}
	
void TxPacket(void)
	{
	
	unsigned char x, y;
	
	portTxCmdL = 0xC0 ;
	portTxCmdH = 0x0 ;
	
	portTxLengthL = PacketRAM[pktLenL] ;
	portTxLengthH = PacketRAM[pktLenH] ;
	
	
	while(!(ReadPP(ppBusSt)& 0x0100));	
	
	x = pktDest0H ;
	y = PacketRAM[pktLenL] ;
	
	do {
		
		portRxTxDataL = PacketRAM[x];
		
		x++;
		y--;
		
		if(!y) break ;
		
		portRxTxDataH = PacketRAM[x];
		
		x++;
		
		} while(y);
	}	
	


/*	READ PART OF THE RECEIVED ETHERNET PACKET
 	x is the destination usually in PacketRAM
 	y is the number of bytes to read from CS8900
*/
	
void LoadPacket(unsigned short x, unsigned short y)
	{
	
	unsigned short i;
	
	for(i=0; i < y; i++)
		{
		
		PacketRAM[x] = portRxTxDataL ;
		x++;
		i++;
		
		if(!(y-i)) break ;
		
		PacketRAM[x] = portRxTxDataH ;
		
		x++;
		
		}
	}	
	
	
	
	




/* 	x contains the offset of the register 
	'value' contains the data read from the register */
		
unsigned short ReadPP(unsigned short x)
        {
        
        unsigned short value, event0, event1;
        unsigned char offsetH, offsetL;
        
        offsetL = x ;
        offsetH = x >> 8 ;
        
        portPtrL = offsetL ;
        portPtrH = offsetH ;

        event1 = portDataH;
        event0 = portDataL; 

        value = (event0 & 0x00FF)|((event1 << 8) & 0xFF00);

        return value;
        }
       

/* 	x contains the offset of the register. 
	y contains the data to be writen into the register */
 
void WritePP(unsigned short x, unsigned short y)
	{
	
	unsigned char offsetH, offsetL, valueH, valueL;
	
	offsetL = x;
	offsetH = x >> 8 ;
	
	valueL = y ; 
	valueH = y >> 8 ;
	
	portPtrL = offsetL ;
    portPtrH = offsetH ;

	portDataH = valueH ;
	portDataL = valueL ;
	
	}



void Pcad(unsigned char x, char *s)
	{
	
	unsigned char y;
	int i;
	
	for (i = 0; *s; i++, s++){putchar(*s);}

	for(i=7; i>=0; i--)
		{
		y = (x>>i) & 0x01 ;
		y += 0x30 ;				
		putchar(y);
		}
		
	putchar('\n');
	putchar(CR);
	}	




int puts(const char *s)
	{
	int n;

	for (n = 0; *s; n++, s++)
		putchar(*s);
	putchar('\n');
	putchar(CR);
	return 1;
	}

void putchar(char x)
	{
	
	while(!(SCSR&0x80));
	SCDR = x;
	
	}
	
	
		
void VWAIT(void)
	{
	unsigned short i, j;
	
	for(j=0; j< 0x1 ; j++)
		{
		
		for(i=0;i<0x8FFF; i++);
		
		}
	}	








/* As is, all interrupts except reset jumps to 0xffff, which is most
 * likely not going to useful. To replace an entry, declare your function,
 * and then change the corresponding entry in the table. For example,
 * if you have a SCI handler (which must be defined with 
 * #pragma interrupt_handler ...) then in this file:
 * add
 *	extern void SCIHandler();
 * before th table.
 * In the SCI entry, change:
 *	DUMMY_ENTRY,
 * to
 *  SCIHandler, 
 */
extern void _start(void);	/* entry point in crt??.s */

#define DUMMY_ENTRY	(void (*)(void))0xFFFF

#ifdef _HC12
#pragma abs_address:0xffd0
#else	/* HC11 */
#pragma abs_address:0xffd6
#endif

/* change the above address if your vector starts elsewhere
 */
void (*interrupt_vectors[])(void) = 
	{
	/* to cast a constant, say 0xb600, use
	   (void (*)())0xb600
	 */
#ifdef _HC12
	/* 812A4 vectors starts at 0xff80, but most entries are not used 
	   if you use Key Wakeup H, change the start address to 0xffCE and
	   add one entry to the beginning */
	DUMMY_ENTRY,	/* BDLC */			/* Key Wakeup J */
	DUMMY_ENTRY,	/* ATD */			/* ATD */
	DUMMY_ENTRY,	/* RESERVED */		/* SCI 1 */
#endif
	DUMMY_ENTRY,	/* SCI */
	DUMMY_ENTRY,	/* SPI */
	DUMMY_ENTRY,	/* PAIE */
	DUMMY_ENTRY,	/* PAO */
	DUMMY_ENTRY,	/* TOF */
	DUMMY_ENTRY,	/* TOC5 */	/* HC12 TC7 */
	DUMMY_ENTRY,	/* TOC4 */	/* TC6 */
	DUMMY_ENTRY,	/* TOC3 */	/* TC5 */
	DUMMY_ENTRY,	/* TOC2 */	/* TC4 */
	DUMMY_ENTRY,	/* TOC1 */	/* TC3 */
	DUMMY_ENTRY,	/* TIC3 */	/* TC2 */
	DUMMY_ENTRY,	/* TIC2 */	/* TC1 */
	DUMMY_ENTRY,	/* TIC1 */	/* TC0 */
	DUMMY_ENTRY,	/* RTI */
	DUMMY_ENTRY,	/* IRQ */
	DUMMY_ENTRY,	/* XIRQ */
	DUMMY_ENTRY,	/* SWI */
	DUMMY_ENTRY,	/* ILLOP */
	DUMMY_ENTRY,	/* COP */
	DUMMY_ENTRY,	/* CLM */
	_start	/* RESET */
	};
#pragma end_abs_address





























