#include <hcs12dp256.h>

void InitATD0(void){
	 ATD0CTL2  = 0xC0; //power up the ATD subsystem
	 ATD0CTL3 = 0x00; //scans all 8 chans
	 ATD0CTL5 = 0x30; //SCAN and MULIT
}

void InitATD1(void){
	 ATD1CTL2  = 0xC0; //power up the ATD subsystem
	 ATD1CTL3 = 0x00; //scans all 8 chans
	 ATD1CTL5 = 0x30; //SCAN and MULIT
}

unsigned int ReadATD0(unsigned char ch){
	unsigned volatile char *p = &ATD0DR0H;
	unsigned int X;
	while((ATD0STAT0 & 0x80) == 0);
	p = p + (ch*2);
	X = *p * 4;
	p = p + 1;
	X = X + (*p/64);
	return X;
}

unsigned int ReadATD1(unsigned char ch){
	unsigned volatile char *p = &ATD1DR0H;
	unsigned int X;
	while((ATD1STAT0 & 0x80) == 0);
	p = p + (ch*2);
	X = *p * 4;
	p = p + 1;
	X = X + (*p/64);
	return X;
}

unsigned int AvgATD0(unsigned char ch){
		 unsigned int avg=0;
		 unsigned char X;
		 for(X = 0; X < 4;X++){
		 	   avg = avg + ReadATD0(ch);
		 }
		 avg = avg/4;
		 return avg;
} 

unsigned int AvgATD1(unsigned char ch){
		 unsigned int avg=0;
		 unsigned char X;
		 for(X = 0; X < 4;X++){
		 	   avg = avg + ReadATD1(ch);
		 }
		 avg = avg/4;
		 return avg;
} 