	.module ATD.c
	.area text
	.dbfile C:\Robot\Robot\ATD.c
	.dbfunc e InitATD0 _InitATD0 fV
_InitATD0::
	.dbline -1
	.dbline 3
; #include <hcs12dp256.h>
; 
; void InitATD0(void){
	.dbline 4
; 	 ATD0CTL2  = 0xC0; //power up the ATD subsystem
	ldab #192
	stab 0x82
	.dbline 5
; 	 ATD0CTL3 = 0x00; //scans all 8 chans
	clr 0x83
	.dbline 6
; 	 ATD0CTL5 = 0x30; //SCAN and MULIT
	ldab #48
	stab 0x85
	.dbline -2
	.dbline 7
; }
L3:
	.dbline 0 ; func end
	rts
	.dbend
	.dbfunc e InitATD1 _InitATD1 fV
_InitATD1::
	.dbline -1
	.dbline 9
; 
; void InitATD1(void){
	.dbline 10
; 	 ATD1CTL2  = 0xC0; //power up the ATD subsystem
	ldab #192
	stab 0x122
	.dbline 11
; 	 ATD1CTL3 = 0x00; //scans all 8 chans
	clr 0x123
	.dbline 12
; 	 ATD1CTL5 = 0x30; //SCAN and MULIT
	ldab #48
	stab 0x125
	.dbline -2
	.dbline 13
; }
L4:
	.dbline 0 ; func end
	rts
	.dbend
	.dbfunc e ReadATD0 _ReadATD0 fi
;              X -> -4,x
;              p -> -2,x
;             ch -> 3,x
_ReadATD0::
	pshd
	pshx
	tfr s,x
	leas -6,sp
	.dbline -1
	.dbline 15
; 
; unsigned int ReadATD0(unsigned char ch){
	.dbline 16
; 	unsigned volatile char *p = &ATD0DR0H;
	ldd #0x90
	std -2,x
L6:
	.dbline 18
L7:
	.dbline 18
; 	unsigned int X;
; 	while((ATD0STAT0 & 0x80) == 0);
	brclr 0x86,#128,L6
	.dbline 19
; 	p = p + (ch*2);
	ldab 3,x
	clra
	lsld
	addd -2,x
	std -2,x
	.dbline 20
; 	X = *p * 4;
	ldy -2,x
	; vol
	ldab 0,y
	clra
	lsld
	lsld
	std -4,x
	.dbline 21
; 	p = p + 1;
	ldd -2,x
	addd #1
	std -2,x
	.dbline 22
; 	X = X + (*p/64);
	ldy -2,x
	; vol
	ldab 0,y
	clra
	ldy #64
	exg x,y
	idivs
	exg x,y
	sty -6,x
	ldd -4,x
	addd -6,x
	std -4,x
	.dbline 23
; 	return X;
	ldd -4,x
	.dbline -2
L5:
	tfr x,s
	pulx
	leas 2,sp
	.dbline 0 ; func end
	rts
	.dbsym l X -4 i
	.dbsym l p -2 pc
	.dbsym l ch 2 I
	.dbsym l ch 3 c
	.dbend
	.dbfunc e ReadATD1 _ReadATD1 fi
;              X -> -4,x
;              p -> -2,x
;             ch -> 3,x
_ReadATD1::
	pshd
	pshx
	tfr s,x
	leas -6,sp
	.dbline -1
	.dbline 26
; }
; 
; unsigned int ReadATD1(unsigned char ch){
	.dbline 27
; 	unsigned volatile char *p = &ATD1DR0H;
	ldd #0x130
	std -2,x
L10:
	.dbline 29
L11:
	.dbline 29
; 	unsigned int X;
; 	while((ATD1STAT0 & 0x80) == 0);
	brclr 0x126,#128,L10
	.dbline 30
; 	p = p + (ch*2);
	ldab 3,x
	clra
	lsld
	addd -2,x
	std -2,x
	.dbline 31
; 	X = *p * 4;
	ldy -2,x
	; vol
	ldab 0,y
	clra
	lsld
	lsld
	std -4,x
	.dbline 32
; 	p = p + 1;
	ldd -2,x
	addd #1
	std -2,x
	.dbline 33
; 	X = X + (*p/64);
	ldy -2,x
	; vol
	ldab 0,y
	clra
	ldy #64
	exg x,y
	idivs
	exg x,y
	sty -6,x
	ldd -4,x
	addd -6,x
	std -4,x
	.dbline 34
; 	return X;
	ldd -4,x
	.dbline -2
L9:
	tfr x,s
	pulx
	leas 2,sp
	.dbline 0 ; func end
	rts
	.dbsym l X -4 i
	.dbsym l p -2 pc
	.dbsym l ch 2 I
	.dbsym l ch 3 c
	.dbend
	.dbfunc e AvgATD0 _AvgATD0 fi
;              X -> -3,x
;            avg -> -2,x
;             ch -> 3,x
_AvgATD0::
	pshd
	pshx
	tfr s,x
	leas -6,sp
	.dbline -1
	.dbline 37
; }
; 
; unsigned int AvgATD0(unsigned char ch){
	.dbline 38
; 		 unsigned int avg=0;
	ldd #0
	std -2,x
	.dbline 40
	clr -3,x
	bra L17
L14:
	.dbline 40
	.dbline 41
	ldab 3,x
	clra
	jsr _ReadATD0
	std -6,x
	ldd -2,x
	addd -6,x
	std -2,x
	.dbline 42
L15:
	.dbline 40
	ldab -3,x
	clra
	addd #1
	stab -3,x
L17:
	.dbline 40
; 		 unsigned char X;
; 		 for(X = 0; X < 4;X++){
	ldab -3,x
	cmpb #4
	blo L14
	.dbline 43
; 		 	   avg = avg + ReadATD0(ch);
; 		 }
; 		 avg = avg/4;
	ldd -2,x
	lsrd
	lsrd
	std -2,x
	.dbline 44
; 		 return avg;
	ldd -2,x
	.dbline -2
L13:
	tfr x,s
	pulx
	leas 2,sp
	.dbline 0 ; func end
	rts
	.dbsym l X -3 c
	.dbsym l avg -2 i
	.dbsym l ch 2 I
	.dbsym l ch 3 c
	.dbend
	.dbfunc e AvgATD1 _AvgATD1 fi
;              X -> -3,x
;            avg -> -2,x
;             ch -> 3,x
_AvgATD1::
	pshd
	pshx
	tfr s,x
	leas -6,sp
	.dbline -1
	.dbline 47
; } 
; 
; unsigned int AvgATD1(unsigned char ch){
	.dbline 48
; 		 unsigned int avg=0;
	ldd #0
	std -2,x
	.dbline 50
	clr -3,x
	bra L22
L19:
	.dbline 50
	.dbline 51
	ldab 3,x
	clra
	jsr _ReadATD1
	std -6,x
	ldd -2,x
	addd -6,x
	std -2,x
	.dbline 52
L20:
	.dbline 50
	ldab -3,x
	clra
	addd #1
	stab -3,x
L22:
	.dbline 50
; 		 unsigned char X;
; 		 for(X = 0; X < 4;X++){
	ldab -3,x
	cmpb #4
	blo L19
	.dbline 53
; 		 	   avg = avg + ReadATD1(ch);
; 		 }
; 		 avg = avg/4;
	ldd -2,x
	lsrd
	lsrd
	std -2,x
	.dbline 54
; 		 return avg;
	ldd -2,x
	.dbline -2
L18:
	tfr x,s
	pulx
	leas 2,sp
	.dbline 0 ; func end
	rts
	.dbsym l X -3 c
	.dbsym l avg -2 i
	.dbsym l ch 2 I
	.dbsym l ch 3 c
	.dbend
