#include <hcs12e128.h>
#include "ATD.h"
#include "sci.h"

#define  RF 0xFA
#define	 RR 0xE5
#define	 RS 0xFF

#define LF	0xE5
#define LR	0xFA   
#define	LS	0xFF

float Dis;

void main(){
	 char chCmd;
	 setbaud(BAUD38K);
	 puts("SSIM DP256 Blue Robot Demo");
	 InitPWM();
	 InitATD0();
	 puts("");
	 puts("Controls are as follows");
	 puts("r -> Display ATD");
	 puts("m -> Motor current draw");
	 puts("v -> Battery voltage"); 
	 puts("i -> Autonomous mode");
	 puts("p -> Sonar Ping");
	 puts("o -> Ir TX");
	 puts("b -> Beep");
	 puts("t -> Mic Read");
	 puts();
	 puts("  w   -> Forward");
	 puts("a s d -> Left, Stop, Right");
	 puts("  x   -> Reverse");
	 puts();
	 do{
	 chCmd = getchar();
	 if(chCmd == 'b'){
	 		  Beep();
	 }
	 if(chCmd == 't'){
	 		  Mic();
	 }
	 if(chCmd == 'o'){
	 		printf("IRTX -> ");  	
			IRTX();
			printf("done\n");
	 }
	 if(chCmd == 'w'){
	 		  Forward();
	 }
	 if(chCmd == 's'){
	 		  Stop();
	 }
	 if(chCmd == 'a'){
	 		  Left();
	 }
	 if(chCmd == 'd'){
	 		  Right();
	 }
	 if(chCmd == 'x'){
	 		  Back();
	 }
	 if(chCmd == 'r'){
	 		printf("AD0=%4.d \tAD1=%4.d \tAD2=%4.d \tAD3=%4.d\n",ReadATD0(0),ReadATD0(1),ReadATD0(2),ReadATD0(3));  
			printf("AD4=%4.d \tAD5=%4.d \tAD6=%4.d \tAD7=%4.d\n",ReadATD0(4),ReadATD0(5),ReadATD0(6),ReadATD0(7));
	 }
	 if(chCmd == 'i'){
			Auto();
	 }
	  if(chCmd == 'v'){
			Dis = ReadATD0(2)*0.019;
			printf("\nVin -> %f\n",Dis);
	 }
	  if(chCmd == 'm'){
			printf("\nCurrent draw of Servo0 and Servo1");
			Dis = ReadATD0(0)*0.1025;
			printf("\n Servo0 -> %f ma",Dis);
			Dis = ReadATD0(1)*0.1025;
			printf("\n Servo1 -> %f ma\n",Dis); 
	 }
	 }while(1);
}

void InitPWM(void){
	 PWMCLK = 0x03; //select clock SA for pwm0 and pwm1
	 PWMPRCLK = 0x07; //Clock A =  E/128
	 PWMSCLA = 0x02; //Clock SA = Clock A/4
	 PWME = 0x03; //enable pwm0 and pwm1
}

void Auto(){
	 unsigned int m,x,y;
	 puts("\nEntering Autonomous mode\n");
	 Forward();
	 while(1){/*While Loop*/
	 x = AvgATD0(4);
	 y = AvgATD0(5);
	 m = max(x,y);
	   if(m>=240){
	 			  	if(close(x,y) & (m>=400)){
						puts("ODD");
		   				Back();
						DelaySL();
						DelaySL();
						Right();
						DelaySL();
						Forward();
		   			}
		   			else{
	 	   				 if((m >= 400)){
	 	   		 		  	   puts("ODC");
	 	   		 		  	   if(x >= 400){
		  		 	  	  	   		Right();
				 	  		   		DelayL();
				 	  		   		Forward();
		  				  		}
		  				  		else{
		  	    	 	  	   		 Left();
				     		   		 DelayL();
					 		   		 Forward();
						  		}
	 	  		    	}
	 	  				if(m < 400){
	 	  				  	  puts("ODF");
		  				  	  if(x >= 240){
		  			 	  	   	   Right();
					 		   	   DelayS();
					 		   	   Forward();
		  				  	  }
		  				  	  else{
		  	    	 	  	   	   Left();
					 		   	   DelayS();
					 		   	   Forward();
		  				  	  }
	 			        }
	 				}
	 	}
	 }/*While Loop*/
}

void Forward(){ //move robot foward
	 PWMDTY0 = RF;
	 PWMDTY1 = LF;
	 BeepHS();
}

void Left(){ //rotate robot left
	 PWMDTY0 = RF;
	 PWMDTY1 = LR;
	 BeepLS();
}

void Right(){ //rotate robot right
	PWMDTY0 = RR;
	PWMDTY1 = LF;
	BeepLS();
}

void Back(){ //move robot backwards
	PWMDTY0 = RR;
	PWMDTY1 = LR;
	BeepHS();
}

void Stop(){ // all stop
	PWMDTY0 = RS;
	PWMDTY1 = LS;
}

void DelayL(){ //long delay
	 int x,y;
	 for(x=0;x<6000;x++){
	 	for(y=0;y<10;y++);
	 };
}

void DelaySL(){ //super long delay
	 int x,y;
	 for(x=0;x<6000;x++){
	 	for(y=0;y<100;y++);
	 };
}

void DelayS(){ //short delay
	 int x;
	 for(x=0;x<2000;x++);
}

unsigned int max(unsigned int x, unsigned int y){
		 if(x>y)return x;
		 else return y;
}

unsigned char close(unsigned int x, unsigned int y){
		 if((x < (y + 20)) & (x > (y - 20))) return 1;
}

void Beep(){
	 BeepHS();
	 BeepLL();
	 BeepHL();
	 BeepLS();
//	 PTT = 0x00;
	 puts("<<BEEP>>");
}

void Mic(){
	 printf("Mic %d\n",ReadATD0(3));
}

void BeepHS(){
	 int c,y;
//	 DDRT |= 0x04;
	 y=0;
	 while(y<750){
	 	for(c=0;c<50;c++);
//	 	PTT ^= 0x04; 
	 	y++;
	 }
}

void BeepHL(){
	 int c,y;
//	 DDRT |= 0x04;
	 y=0;
	 while(y<1500){
	 	for(c=0;c<50;c++);
//	 	PTT ^= 0x04; 
	 	y++;
	 }
}

void BeepLL(){
	 int c,y;
//	 DDRT |= 0x04;
	 y=0;
	 while(y<750){
	 	for(c=0;c<250;c++);
//	 	PTT ^= 0x04; 
	 	y++;
	 }
}

void BeepLS(){
	 int c,y;
//	 DDRT |= 0x04;
	 y=0;
	 while(y<75){
	 	for(c=0;c<500;c++);
//	 	PTT ^= 0x04; 
	 	y++;
	 }
}

void IRTX(){
	 int x;
	 x = 0;
//	 DDRH = 0x80;
	 while(x<20){
//	 PTH = 0x80;
	 DelayL();
//	 PTH = 0x00;
	 DelayS();
	 x++;
	 }
}
