	.module sonar.c
	.area text
	.dbfile C:\Robot\Robot\sonar.c
	.dbfunc e initSonar _initSonar fV
_initSonar::
	.dbline -1
	.dbline 5
; #include <hcs12dp256.h>
; 
; unsigned int overflow;
; 
; void initSonar(){
	.dbline -2
	.dbline 9
; 	 //TSCR2 = 0x04;
; 	 //TSCR1 = 0x80;
; 	
; }
L3:
	.dbline 0 ; func end
	rts
	.dbend
	.dbfunc e SonarPing _SonarPing fV
_SonarPing::
	.dbline -1
	.dbline 10
; void SonarPing(){
	.dbline 14
; 	 //unsigned int start,end,ret;
; //	DDRT |= 0x02; //setups the data direction of port t
; //	PTT |= 0x02;
; 	ShortPing();
	jsr _ShortPing
	.dbline 16
; //	PTT = 0x00;
; 	NewPing();
	jsr _NewPing
	.dbline -2
	.dbline 28
; 	/*while((PTT & 0x01) == 1){}
; 	start = TCNT;
; 	while((PTT & 0x01) == 0){}
; 	end = TCNT;
; 	if(start>end){
; 		ret = (65536u-start)+end;
; 	}
; 	else{
; 		 ret = start - end;
; 	}
; 	return ret;*/
; }
L4:
	.dbline 0 ; func end
	rts
	.dbend
	.dbfunc e ShortPing _ShortPing fV
;              x -> -2,x
_ShortPing::
	pshx
	tfr s,x
	leas -2,sp
	.dbline -1
	.dbline 30
; 
; void ShortPing(){ //short delay used to create the sonar ping
	.dbline 32
	ldd #0
	std -2,x
L6:
	.dbline 32
	.dbline 33
L7:
	.dbline 32
; 	int x;
; 	for(x = 0;x<10;x++){
	ldd -2,x
	addd #1
	std -2,x
	.dbline 32
	ldd -2,x
	cpd #10
	blt L6
	.dbline -2
	.dbline 34
; 	}
; }
L5:
	tfr x,s
	pulx
	.dbline 0 ; func end
	rts
	.dbsym l x -2 I
	.dbend
	.dbfunc e NewPing _NewPing fV
;  lreg1 -> -4,x
;  lreg2 -> -8,x
;       distance -> -20,x
;           diff -> -16,x
;             pw -> -14,x
;          edge1 -> -10,x
_NewPing::
	pshx
	tfr s,x
	leas -24,sp
	.dbline -1
	.dbline 36
; 
; void NewPing(){
	.dbline 40
; 	 unsigned long pw;
; 	 unsigned int edge1,diff;
; 	 float distance;
; 	 overflow = 0;
	ldd #0
	std _overflow
	.dbline 41
; 	 TSCR1 = 0x90;
	ldab #144
	stab 0x46
	.dbline 42
; 	 TSCR2 = 0x04;
	ldab #4
	stab 0x4d
	.dbline 43
; 	 TIOS &= 0xFE;
	bclr 0x40,#0x1
	.dbline 44
; 	 DDRT &= 0xFE;
	bclr 0x242,#0x1
	.dbline 45
; 	 TCTL4 = 0x01;
	ldab #1
	stab 0x4b
	.dbline 46
; 	 TFLG1 = 0x01;
	ldab #1
	stab 0x4e
L11:
	.dbline 47
L12:
	.dbline 47
; 	 while(!(TFLG1 & 0x01));
	brclr 0x4e,#1,L11
	.dbline 48
; 	 TFLG1 = 0x01;
	ldab #1
	stab 0x4e
	.dbline 49
; 	 TFLG2 = 0x80;
	ldab #128
	stab 0x4f
	.dbline 50
; 	 TSCR2 |=0x80;
	bset 0x4d,#128
	.dbline 51
; 	 INTR_ON();
		cli

	.dbline 52
; 	 edge1 = TC0;
	; vol
	ldy 0x50
	sty -10,x
	.dbline 53
; 	 TCTL4 = 0x02;
	ldab #2
	stab 0x4b
L14:
	.dbline 54
L15:
	.dbline 54
; 	 while(!(TFLG1 & 0x01));
	brclr 0x4e,#1,L14
	.dbline 55
; 	 INTR_OFF();
		sei

	.dbline 56
; 	 diff = TC0 - edge1;
	; vol
	ldd 0x50
	subd -10,x
	std -16,x
	.dbline 57
; 	 if(TC0<edge1)
	; vol
	ldd 0x50
	cpd -10,x
	bhs L17
	.dbline 58
; 	 		overflow = overflow - 1;
	ldd _overflow
	subd #1
	std _overflow
L17:
	.dbline 59
; 	 pw = overflow*65536u+diff;	
	ldy #L19
	movw 0,y,-4,x
	movw 2,y,-2,x
	ldd _overflow
	std -6,x
	movw #0,-8,x
	jsr __lmul
	ldd -16,x
	std -6,x
	movw #0,-8,x
	jsr __ladd
	leay -14,x
	movw -4,x,0,y
	movw -2,x,2,y
	.dbline 60
; 	 distance = pw * 0.0331;
	ldd #1
	jsr __d2lreg
	movw -2,x,-6,x
	movw -4,x,-8,x
	leay -14,x
	movw 0,y,-4,x
	movw 2,y,-2,x
	jsr __land
	jsr __long2fp
	jsr __fpmov
	leay -14,x
	movw 0,y,-4,x
	movw 2,y,-2,x
	ldd #1
	jsr __luirsh
	jsr __long2fp
	leas -6,sp
	jsr __pshfp2 ; spill
	jsr __fpmov
	ldy #L21
	jsr __tofp1
	jsr __fpmul
	jsr __pulfp2 ; reload
	leas 6,sp
	jsr __fpadd
	jsr __fpmov
	ldy #L20
	jsr __tofp1
	jsr __fpmul
	leay -20,x
	jsr __fromfp1
	.dbline 61
; 	 printf("%0.2fcm\n", distance);
	leay -20,x
	jsr __tofp1
	leay 0,sp
	jsr __fromfp1
	ldd #L22
	jsr _printf
	.dbline 62
; 	 TSCR1 = 0x00;
	clr 0x46
	.dbline 63
; 	 TSCR2 = 0x00;
	clr 0x4d
	.dbline 64
; 	 TFLG1 = 0x00;
	clr 0x4e
	.dbline 65
; 	 TIOS = 0x00;
	clr 0x40
	.dbline 66
; 	 TCTL4 = 0x00;
	clr 0x4b
	.dbline -2
	.dbline 67
; }
L10:
	tfr x,s
	pulx
	.dbline 0 ; func end
	rts
	.dbsym l distance -20 D
	.dbsym l diff -16 i
	.dbsym l pw -14 l
	.dbsym l edge1 -10 i
	.dbend
	.dbfunc e tov_isr _tov_isr fV
_tov_isr::
	.dbline -1
	.dbline 70
; 
; #pragma interrupt_handler tov_isr
; void tov_isr(void){
	.dbline 71
; 	 INTR_OFF();
		sei

	.dbline 72
; 	 TFLG2 = 0x80;
	ldab #128
	stab 0x4f
	.dbline 73
; 	 overflow = overflow + 1;
	ldd _overflow
	addd #1
	std _overflow
	.dbline 74
; 	 INTR_ON();
		cli

	.dbline -2
	.dbline 75
; }
L23:
	.dbline 0 ; func end
	rti
	.dbend
	.area bss
	.dbfile C:\Robot\Robot\sonar.c
_overflow::
	.blkb 2
	.dbsym e overflow _overflow i
	.area text
	.dbfile C:\Robot\Robot\sonar.c
L22:
	.byte 37,48,46,50,'f,'c,'m,10,0
L21:
	.word 0x4000,0x0
L20:
	.word 0x3d07,0x93de
L19:
	.word 1,0
