// filename ******** Main.C ************** 
// LCD Display (HD44780) on Port PAD,M for the 9S12C32   
// Jonathan W. Valvano 8/15/06
// Purpose: test program for ADC converter
// analog input connected to PAD1

/*   
  size is 1*16 
  if do not need to read busy, then you can tie R/W=ground 
  ground = pin 1    Vss
  power  = pin 2    Vdd   +5V
  ground = pin 3    Vlc   grounded for highest contrast
  PM5    = pin 4    RS    (1 for data, 0 for control/status)
  PAD0   = pin 5    R/W   (1 for read, 0 for write)
  PM4    = pin 6    E     (enable)
  PM3    = pin 14   DB7   (4-bit data)
  PM2    = pin 13   DB6
  PM1    = pin 12   DB5
  PM0    = pin 11   DB4
16 characters are configured as 2 rows of 8
addr  00 01 02 03 04 05 06 07 40 41 42 43 44 45 46 47
*/
#include <hidef.h>      /* common defines and macros */
#include <mc9s12c32.h>  /* derivative information */
#include "LCD.H"
#include "PLL.H"
#include "ADC.H"

#pragma LINK_INFO DERIVATIVE "mc9s12c32"
unsigned short Data;		// ADC sample

//--------------------TimerInit---------------
// initialize timer module to 0.667us(Boot Mode) TCNT clock
// inputs: none
// outputs: none
void TimerInit(void){
  DDRT |= 0x03;   // PortT bits 1,0 are outputs to LED
  TSCR1 = 0x80;   // Enable TCNT, 24MHz in both boo tand run modes
  TSCR2 = 0x04;   // divide by 16 TCNT prescale, TCNT at 667nsec
  PACTL = 0;      // timer prescale used for TCNT
/* Bottom three bits of TSCR2 (PR2,PR1,PR0) determine TCNT period
    divide  24MHz E clock    
000   1     42ns  TOF  2.73ms  
001   2     84ns  TOF  5.46ms   
010   4    167ns  TOF  10.9ms       
011   8    333ns  TOF  21.8ms 	 
100  16    667ns  TOF  43.7ms 	 
101  32   1.33us  TOF  87.4ms		 
110  64   2.67us  TOF 174.8ms   
111 128   5.33us  TOF 349.5ms    */ 
// Be careful, TSCR1 and TSCR2 maybe set in other rituals
}

//---------------------mwait---------------------
// wait specified number of msec
// Input: number of msec to wait
// Output: none
// assumes TCNT timer is running at 667ns
void mwait(unsigned short msec){ 
unsigned short startTime;
  for(; msec>0; msec--){
    startTime = TCNT;
    while((TCNT-startTime) <= 1500){} 
  }
}

//---------------------check---------------------
// if LCD broken toggle LED1 at 2Hz
// Input: last LCD status, 0 means bad
// Output: none
// Error: if status is zero, this function will not return
void check(short status){	 // 0 if LCD is broken
  if(status ==0){		   
    for(;;) {
      PTT ^= 0x02;   // fast toggle LED
      mwait(250);      // 0.25 sec wait
    }
  }
}

void main(void) {	 
  PLL_Init();     // running at 24MHz
  TimerInit();    // initialize COP, Port T 
  ADC_Init();     // Activate ADC 
  check(LCD_Open(LCDINC+LCDNOSHIFT,
    LCDNOCURSOR+LCDNOBLINK,
    LCDNOSCROLL+LCDLEFT,
    LCD2LINE+LCD7DOT));
// font number 0
// *       *   17
// * * * * *   31
// *   *   *   21
// *   *   *   21
// *   *   *   21
//   * * *     14
//     *        4 
  check(LCD_SetFont(0,0,17,31,21,21,21,14,4));

  check(LCD_OutString("ADC test")); 
  check(LCD_GoTo(2,2));
  check(LCD_OutChar(0));  // UT sign
  //asm cli
  for(;;) {
    PTT ^= 0x01;           // toggle LED
    Data = ADC_In(0x81);	 // right justified channel 1
    check(LCD_GoTo(2,3));
    check(LCD_OutDec(Data));
    mwait(200);            // 200msec wait
  } 
}