// filename ******** Main.C ************** 

//***********************************************************************
// Simple ADC example for the Technological Arts EsduinoXtreme board
// by Carl Barnes, 12/03/2014
//***********************************************************************

#include <hidef.h>      /* common defines and macros */
#include "derivative.h"  /* derivative information */
#include "SCI.h"

char string[20];
unsigned short val;  

void msDelay(unsigned int);

//---------------------OutCRLF---------------------
// Output a CR,LF to SCI to move cursor to a new line
// Input: none
// Output: none
// Toggle LED each time through the loop

void OutCRLF(void){
  SCI_OutChar(CR);
  SCI_OutChar(LF);
  PTJ ^= 0x20;          // toggle LED D2
}

void main(void) {
// Setup and enable ADC channel 0
// Refer to Chapter 14 in S12G Reference Manual for ADC subsystem details
		
	ATDCTL1 = 0x4F;		// set for 12-bit resolution
	ATDCTL3 = 0x88;		// right justified, one sample per sequence
	ATDCTL4 = 0x02;		// prescaler = 2; ATD clock = 6.25MHz / (2 * (2 + 1)) == 1.04MHz
	ATDCTL5 = 0x20;		// continuous conversion on channel 0
	
	
// Setup LED and SCI
  DDRJ |= 0x01;     // PortJ bit 0 is output to LED D2 on DIG13
  SCI_Init(9600);
  
  SCI_OutString("Technological Arts - EsduinoXtreme ADC demo"); OutCRLF();
  for(;;) {
    PTJ ^= 0x01;          // toggle LED
    val=ATDDR0;
    SCI_OutString("Analog0 reading in decimal = ");
    SCI_OutUDec(val);
    SCI_OutString("    Analog0 reading in hex = ");
    SCI_OutUHex(val);
    OutCRLF();
    msDelay(10000);
  }
}

void msDelay(unsigned int time)
{
	unsigned int j,k;
	for(j=0;j<time;j++)
		for(k=0;k<40;k++);
}