/*******************************************************************************
* Freescale Semiconductor Inc.
* (c) Copyright 2004-2005 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
********************************************************************************
Services performed by FREESCALE in this matter are performed AS IS and without 
any warranty. CUSTOMER retains the final decision relative to the total design 
and functionality of the end product. FREESCALE neither guarantees nor will be 
held liable by CUSTOMER for the success of this project.
FREESCALE DISCLAIMS ALL WARRANTIES, EXPRESSED, IMPLIED OR STATUTORY INCLUDING, 
BUT NOT LIMITED TO, IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR 
A PARTICULAR PURPOSE ON ANY HARDWARE, SOFTWARE OR ADVISE SUPPLIED TO THE PROJECT
BY FREESCALE, AND OR NAY PRODUCT RESULTING FROM FREESCALE SERVICES. IN NO EVENT
SHALL FREESCALE BE LIABLE FOR INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF
THIS AGREEMENT.

CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or
actions by anyone on account of any damage, or injury, whether commercial, 
contractual, or tortuous, rising directly or indirectly as a result of an advise
or assistance supplied CUSTOMER in connection with product, services or goods 
supplied under this Agreement.
********************************************************************************
* File      main.c
* Owner     B34874
* Version   1.0
* Date      Nov-8-2011
* Classification   General Business Information
* Brief     Wakeup from Stop mode by API example
********************************************************************************
* Detailed Description:
*
* - The SW demonstrates enter to STOP mode and wake-up by API
*
* - tested on: TWR-S12G128
*   - OSCCLK = 8MHz oscillator, BUSCLK = 16MHz set by means of PLL in PEE mode
*   - Reference to documentation: MC9S12GRMV1 Rev.1.01
*
*
********************************************************************************
Revision History:
Version  Date         Author  Description of Changes
1.0      Nov-8-2011  B34874  Initial version
*******************************************************************************/
#include <hidef.h>      /* common defines and macros */
#include "derivative.h"      /* derivative-specific definitions */
 
//==============================================================================
#pragma CODE_SEG NON_BANKED
interrupt 59 void API_ISR(void)
{  
  PTT_PTT4 = ~PTT_PTT4;
  CPMUAPICTL_APIF = 1; 
}
#pragma CODE_SEG DEFAULT

//==============================================================================
/*
 PLL Engaged External (PEE)
 The Bus Clock is based n the PLLCLK.
 This mode can be entered from default mode PEI by performing the following steps:
 Configure the PLL for desired bus frequency.
 Program the reference divider (REFDIV[3:0] bits) to divide down oscillator frequency if
necessary.
 Enable the external oscillator (OSCE bit)
 Wait for oscillator to start up (UPOSC=1) and PLL to lock (LOCK=1).
*/
void SetPEEmodeBUSCLK(byte _synr, byte _refdv, byte _postdiv)
{
 CPMUSYNR    = _synr;
 CPMUREFDIV  = _refdv;
 CPMUPOSTDIV = _postdiv;   
  
 CPMUOSC_OSCE = 1; //enable external oscillator OSCE
    
 while(!CPMUFLG_UPOSC)
  {// you can check for timeot here with error message report
  };    
 while(!CPMUFLG_LOCK)
  {// you can check for timeot here with error message report
  };    
 
  //--- select clocks --------------------
 CPMUCLKS = 0B10000011;                   // bus=fPLL/2; COP is clocked from OSCCLK
 if(CPMUCLKS != 0B10000011)               // After writing CPMUCLKS register, it is strongly recommended to read  
  {                                       // back CPMUCLKS register to make sure that write of PLLSEL,
     asm nop;                             // RTIOSCSEL, COPOSCSEL0 and COPOSCSEL1 was successful.
  }
 //--------------------------------------
}
//==============================================================================
void Go_Stop(void)
{
   asm STOP;        //Go to stop mode   
}

//==============================================================================
void Set_API(void)
{
  CPMUAPIR = 0x0FFF;    //app.1s interval    
  CPMUAPICTL_APICLK = 0; //Autonomous Clock (ACLK) used as source
  CPMUAPICTL_APIE = 1;   //interrutp enable
  CPMUAPICTL_APIFE = 1;  //enable API     
}   
//==============================================================================


void main(void) {
  unsigned int i;
  //--- PLL Initialization ---------------
  //SetPEEmodeBUSCLK(0x58, 0x03, 0x00);   // 25MHz BUSCLK from 4 MHZ oscclk, PEE mode
  //SetPEEmodeBUSCLK(0x58, 0x07, 0x00);   // 25MHz BUSCLK from 8 MHZ oscclk, PEE mode
  //SetPEEmodeBUSCLK(0x03, 0x40, 0x00);   // 16MHz BUSCLK from 4 MHZ oscclk, PEE mode
  SetPEEmodeBUSCLK(0x01, 0x80, 0x00);     // 16MHz BUSCLK from 8 MHZ oscclk, PEE mode
  //SetPEEmodeBUSCLK(0x01, 0x80, 0x07);   // 2MHz BUSCLK from 8 MHZ oscclk, PEE mode
  
  ECLKCTL_NECLK = 0;                      // enable ECLK output (bus clock is visible on pin PB0 for TWR-S12G128, PS7 for TWR-S12GN32)
  
  DDRT = 0x30;          //PT4,PT5 as output
  
  Set_API();

	EnableInterrupts;
  
  PTT_PTT5 = 1;      //just initial settings
  
  asm ANDCC #0x7F;  //clear S bit = enable stop mode
  
  for(;;) {
  PTT_PTT5 = ~PTT_PTT5; 
    
    //delay
    for(i=1;i<60000;i++) asm nop;
    for(i=1;i<60000;i++) asm nop;
    for(i=1;i<60000;i++) asm nop;
    for(i=1;i<60000;i++) asm nop;
    Go_Stop();      //go to stop mode    
  }   
}