#ifndef _CAN_H
#define _CAN_H
//==============================================================================
#include "map.h"
#include "derivative.h"      /* derivative-specific definitions */
//==============================================================================
typedef struct { UINT  id; BOOL  RTR; UBYTE data[8]; UBYTE len; UBYTE prty;}
tCAN_MSG;
//==============================================================================
typedef struct
{
 UBYTE CTL0;    /*00*/  UBYTE CTL1;   /*01*/  UBYTE BTR0;   /*02*/  UBYTE BTR1;   /*03*/
 UBYTE RFLG;    /*04*/  UBYTE RIER;   /*05*/	UBYTE TFLG;   /*06*/  UBYTE TIER;   /*07*/
 UBYTE TARQ;    /*08*/  UBYTE TAAK;   /*09*/  UBYTE TBSEL;  /*0A*/  UBYTE IDAC;   /*0B*/
 UBYTE RESER0;  /*0C*/  UBYTE RESER1; /*0D*/  UBYTE RXERR;  /*0E*/  UBYTE TXERR;  /*0F*/
 UBYTE IDAR0;   /*10*/  UBYTE IDAR1;  /*11*/  UBYTE IDAR2;  /*12*/  UBYTE IDAR3;  /*13*/
 UBYTE IDMR0;   /*14*/  UBYTE IDMR1;  /*15*/  UBYTE IDMR2;  /*16*/  UBYTE IDMR3;  /*17*/
 UBYTE IDAR4;   /*18*/  UBYTE IDAR5;  /*19*/  UBYTE IDAR6;  /*1A*/  UBYTE IDAR7;  /*1B*/
 UBYTE IDMR4;   /*1C*/  UBYTE IDMR5;  /*1D*/  UBYTE IDMR6;  /*1E*/  UBYTE IDMR7;  /*1F*/
 UBYTE RXIDR0;  /*20*/  UBYTE RXIDR1; /*21*/  UBYTE RXIDR2; /*22*/  UBYTE RXIDR3; /*23*/
 UBYTE RXDSR[8];/*24 ~ 2B*/
 UBYTE RXDLR;   /*2C*/  UBYTE NOTAPP0;/*2D*/  UBYTE RXTSRH; /*2E*/  UBYTE RXTSRL; /*2F*/
 UBYTE TXIDR0;  /*30*/  UBYTE TXIDR1; /*31*/  UBYTE TXIDR2; /*32*/  UBYTE TXIDR3; /*33*/
 UBYTE TXDSR[8];/*34 ~ 3B*/
 UBYTE TXDLR;   /*3C*/  UBYTE TXTBPR; /*3D*/  UBYTE TXTSRH; /*3E*/  UBYTE TXTSRL; /*3F*/
}tCAN_REGS;						

//typedef struct
//{
// UBYTE CTL0;    /*00*/  UBYTE CTL1;   /*01*/  UBYTE BTR0;   /*02*/  UBYTE BTR1;   /*03*/
// UBYTE RFLG;    /*04*/  UBYTE RIER;   /*05*/	UBYTE TFLG;   /*06*/  UBYTE TIER;   /*07*/
// UBYTE TARQ;    /*08*/  UBYTE TAAK;   /*09*/  UBYTE TBSEL;  /*0A*/  UBYTE IDAC;   /*0B*/
// UBYTE RESERVED;/*0C*/  UBYTE MISC;   /*0D*/  UBYTE RXERR;  /*0E*/  UBYTE TXERR;  /*0F*/
// UBYTE IDAR0;   /*10*/  UBYTE IDAR1;  /*11*/  UBYTE IDAR2;  /*12*/  UBYTE IDAR3;  /*13*/
// UBYTE IDMR0;   /*14*/  UBYTE IDMR1;  /*15*/  UBYTE IDMR2;  /*16*/  UBYTE IDMR3;  /*17*/
// UBYTE IDAR4;   /*18*/  UBYTE IDAR5;  /*19*/  UBYTE IDAR6;  /*1A*/  UBYTE IDAR7;  /*1B*/
// UBYTE IDMR4;   /*1C*/  UBYTE IDMR5;  /*1D*/  UBYTE IDMR6;  /*1E*/  UBYTE IDMR7;  /*1F*/
// UBYTE RXIDR0;  /*20*/  UBYTE RXIDR1; /*21*/  UBYTE RXIDR2; /*22*/  UBYTE RXIDR3; /*23*/
// UBYTE RXDSR0;  /*24*/  UBYTE RXDSR1; /*25*/  UBYTE RXDSR2; /*26*/  UBYTE RXDSR3; /*27*/
// UBYTE RXDSR4;  /*28*/  UBYTE RXDSR5; /*29*/  UBYTE RXDSR6; /*2A*/  UBYTE RXDSR7; /*2B*/
// UBYTE RXDLR;   /*2C*/  UBYTE NOTAPP0;/*2D*/  UBYTE RXTSRH; /*2E*/  UBYTE RXTSRL; /*2F*/
// UBYTE TXIDR0;  /*30*/  UBYTE TXIDR1; /*31*/  UBYTE TXIDR2; /*32*/  UBYTE TXIDR3; /*33*/
// UBYTE TXDSR0;  /*34*/  UBYTE TXDSR1; /*35*/  UBYTE TXDSR2; /*36*/  UBYTE TXDSR3; /*37*/
// UBYTE TXDSR4;  /*38*/  UBYTE TXDSR5; /*39*/  UBYTE TXDSR6; /*3A*/  UBYTE TXDSR7; /*3B*/
// UBYTE TXDLR;   /*3C*/  UBYTE TXTBPR; /*3D*/  UBYTE TXTSRH; /*3E*/  UBYTE TXTSRL; /*3F*/
//}tCAN_REGS;						

//==============================================================================
extern tCAN_MSG canRxMsg, canTxMsg; // can0~can4 structures of messages
//==============================================================================
extern void init_CAN(UBYTE _canbtr0, UBYTE _canbtr1, UBYTE loop);
extern BOOL MSCANSendMsg(tCAN_MSG *msg);
extern BOOL MSCANGetMsg(tCAN_MSG *msg);
extern BOOL MSCANCheckRcvdMsg();
extern void createMessage(tCAN_MSG *msg,UINT id,BOOL RTR,UBYTE len,UBYTE prty,
                 UBYTE d0,UBYTE d1,UBYTE d2,UBYTE d3,UBYTE d4,UBYTE d5,UBYTE d6,UBYTE d7);

//==============================================================================
#endif