/*******************************************************************************
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
********************************************************************************
Services performed by FREESCALE in this matter are performed AS IS and without
any warranty. CUSTOMER retains the final decision relative to the total design
and functionality of the end product. FREESCALE neither guarantees nor will be
held liable by CUSTOMER for the success of this project.
FREESCALE DISCLAIMS ALL WARRANTIES, EXPRESSED, IMPLIED OR STATUTORY INCLUDING,
BUT NOT LIMITED TO, IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR
A PARTICULAR PURPOSE ON ANY HARDWARE, SOFTWARE ORE ADVISE SUPPLIED TO A PROJECT
BY FREESCALE, AND OR NAY PRODUCT RESULTING FROM FREESCALE SERVICES. IN NO EVENT
SHALL FREESCALE BE LIABLE FOR INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF
THIS AGREEMENT.
CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or
actions by anyone on account of any damage, or injury, whether commercial,
contractual, or tortuous, rising directly or indirectly as a result of an advise
or assistance supplied CUSTOMER in connection with product, services or goods
supplied under this Agreement.
********************************************************************************
* File main.c
* Owner b34874
* Version 1.0 // version 0.x is reserved for development phase and
// should not be placed in the repository
* Date Dec-11-2012
* Classification General Business Information/Internal Use Only/Confidential Proprietary
* Brief Brief description of the file
********************************************************************************
* Detailed Description:
* Software periodically sends/receives (depends on CAN_node value) CAN frame. 
* Software suppose using of two S12G boards
*
* Results are sent over SCI module
*
* For simplicity is CAN clock based on default bus clock (6.25MHz) and Can baud rate is set to 390625bit/s
* 
* Don't forget install jumpers at JP4 and JP6 connectors on TWR boards
*  
* Tested on: S12G64/S12G128, TWR-S12G64/TWR-S12G128, 
* CLK source:1MHz IRCCLK; BUSCLK:6.25MHz
********************************************************************************
Revision History:
Version Date Author Description of Changes
1.0 Dec/11/2012 b34874 Initial Version
*******************************************************************************/
#include <hidef.h>      /* common defines and macros */
#include "derivative.h"      /* derivative-specific definitions */
#include "can_S12G.h"
#include "stdio.h"
#include "map.h"


#define CAN_node_send 0x00;
#define CAN_node_receive 0x01;

unsigned char CAN_id = 0x00;
unsigned char CAN_data_lenght = 1;
unsigned char CAN_node = CAN_node_sent;

UBYTE data;
SBYTE txt[50];


//==============================================================================
// SCI0 initialization
//==============================================================================
void  SCI0_Init(void)
{
 //----- BR = BUSCLK / (16*Baud rate) = 6250000 / (16*9600) = 41 = 0x29 -----
                                            //------------------------------------------------------
   SCI0BDH = 0x00;                          // prescaller value (depends on module clock frequency) 
   SCI0BDL = 0x29;                          // prescaller = 0x29   9600Bd  (6.25MHz bus clock is set)
                                            //------------------------------------------------------
   SCI0CR1 = 0x04;                          // Loops sciswai rsrc   m    wake  ilt   pe    pt       
                                            // 0-LOOPS=RSRC=0 => 1 Single-wire mode with Rx input connected to TXD
                                            // 0-SCI dis. in wait mode                              
                                            // 0-if RSRC=1-RxTx intern. connected if loops=1                  
                                            // 0-start+8 data+1 stop bit                          
                                            // 0-IDLE mark wake up                                  
                                            // 1-idle char. bit count begins after stop bit         
                                            // 0-parity fction disabled                             
                                            // 0-odd parity                                       
                                            //------------------------------------------------------
   SCI0CR2 = 0x0C;                          // tie   tcie    rie  ilie   te    re   rwu   sbk       
                                            // 0-Tx empty intr disabled                             
                                            // 0-Tx complete intr disabled                          
                                            // 0-Rx full + OverRun interrupts
                                            // 0-idle line intr disabled                            
                                            // 1-transmitter enabled
                                            // 0-receiver disabled
                                            // 0-receiver normal operation                                   
                                            // 0-no break characters                                
                                            //------------------------------------------------------
}
//==============================================================================

//==============================================================================
// SCI send text
//==============================================================================
void send_text(SBYTE *str)
{
  unsigned char i;
  i=0;
  while(str[i]!='\0')
    {
     while(!SCI0SR1_TC);                    // write data to SCI (clear TC) 
     SCI0DRL = str[i];
     i++;
    }
}
//==============================================================================

//==============================================================================
// delay loop
//==============================================================================
void delay(void)
{
 unsigned int  i,j;
 for(i=0;i<0xFFFF;i++) for(j=0;j<5;j++) { asm nop; }
}
//==============================================================================

//==============================================================================
// Get CAN message
//==============================================================================
void RxMsgOnCAN(UBYTE data0)
{
   UBYTE tmp0;

   while(!MSCANCheckRcvdMsg());           // CAN#,CAN# :wait till mesage is not received
   if(MSCANGetMsg(&canRxMsg))       // CAN# :get message
    {if(canRxMsg.id == CAN_id && canRxMsg.RTR == 0) // check message id
      {tmp0 = canRxMsg.data[0];          // show received data
       data0 = tmp0;
       (void)sprintf(txt,"received: 0x%02X DTR:%d \n\r",tmp0, canRxMsg.len);
       send_text(txt);
      }
    }
  
   
}


//==============================================================================
// main loop
//==============================================================================
void main(void) {  


  PER01AD = 0xFFFF; 
  
  SCI0_Init();
  
  DDRT  = 0xF0;                          // PORT T is an output port for LEDs
  
  init_CAN(0xC0, 0x67, 0);               // 390625bit/s, loop enabled/disabled=1/0  (TJA1041T)
                                         // For calculation use CAN CAN_setup1.xls
                                         
	data = 0x00;
	
	send_text("\r\n\r\nHELLO, I AM ALIVE....\r\n\r\n");


  for(;;) {
  
  if (CAN_node)                         // Receiver
  {                                     
   
   RxMsgOnCAN(data);                    // CAN receive function
   
  } else                                // Transmitter
  {
   createMessage(&canTxMsg,CAN_id,0,CAN_data_lenght,3,data,0,0,0,0,0,0,0);  //CAN#,id,RTR,len,prty,d0,d1,d2,d3,d4,d5,d6,d7
   (void) MSCANSendMsg(&canTxMsg);            // CAN#,CAN#, buf :send message
   
   (void)sprintf(txt,"sent: 0x%02X \r\n",data);
   send_text(txt);
   
   data++;
   
   delay(); 
  }
   
   // _FEED_COP(); /* feeds the dog */
  } /* loop forever */
  /* please make sure that you never leave main */
}
