/*******************************************************************************
* Freescale Semiconductor Inc.
* (c) Copyright 2004-2005 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
********************************************************************************
Services performed by FREESCALE in this matter are performed AS IS and without 
any warranty. CUSTOMER retains the final decision relative to the total design 
and functionality of the end product. FREESCALE neither guarantees nor will be 
held liable by CUSTOMER for the success of this project.
FREESCALE DISCLAIMS ALL WARRANTIES, EXPRESSED, IMPLIED OR STATUTORY INCLUDING, 
BUT NOT LIMITED TO, IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR 
A PARTICULAR PURPOSE ON ANY HARDWARE, SOFTWARE OR ADVISE SUPPLIED TO THE PROJECT
BY FREESCALE, AND OR NAY PRODUCT RESULTING FROM FREESCALE SERVICES. IN NO EVENT
SHALL FREESCALE BE LIABLE FOR INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF
THIS AGREEMENT.

CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or
actions by anyone on account of any damage, or injury, whether commercial, 
contractual, or tortuous, rising directly or indirectly as a result of an advise
or assistance supplied CUSTOMER in connection with product, services or goods 
supplied under this Agreement.
********************************************************************************
* File      main.c
* Owner     B34874
* Version   1.0
* Date      Sep-3-2012
* Classification   General Business Information
* Brief     Interrupt catcher example code  at S12G128
********************************************************************************
* Detailed Description:
*
* Interrupt catcher example code(catch all unexpected interrupts)
* Interrupt catcher you can use for debugging or directly in your software. 
* Few notes: 
* 1. You should replace lines for expected interrupt by your interrupts routines 
*    as in example of SCI0 interrupt routine. 
* 2. All interrupt vectors are only 16bit addresses, therefore all your interrupt 
*    routines must be placed in non banked memory (for example by #pragma commands) 
* 3. Interrupt number 0 presents POR reset vector, 1 is CM reset, 2 is COP reset, ... , 63 is Spurious Interrupt. 
*    Interrupt number = (0xFE-Vector Address)/2. See Table 1-34. Interrupt Vector Locations at RM(page 134-135). 
*    For Example: Interrupt number of SCI0 = (0xFE-D6)/2 = 0x14 = 20.
*
********************************************************************************
Revision History:
Version  Date         Author  Description of Changes
1.0      Sep-3-2012   B34874  Initial version
*******************************************************************************/

#include <hidef.h>      /* common defines and macros */
#include "derivative.h"      /* derivative-specific definitions */


volatile unsigned int number_of_ISR = 0;
volatile unsigned char sc0_data_in;


void Unimplemented_ISR(void)
{
  asm nop;         //insert breakpoint here. If the code stops here, check the "number_of_ISR"
}


#pragma CODE_SEG NON_BANKED
interrupt	1	void 	ISR_1	(void)	{number_of_ISR = 1	;	Unimplemented_ISR();}
interrupt	2	void 	ISR_2	(void)	{number_of_ISR = 2	;	Unimplemented_ISR();}
interrupt	3	void 	ISR_3	(void)	{number_of_ISR = 3	;	Unimplemented_ISR();}
interrupt	4	void 	ISR_4	(void)	{number_of_ISR = 4	;	Unimplemented_ISR();}
interrupt	5	void 	ISR_5	(void)	{number_of_ISR = 5	;	Unimplemented_ISR();}
interrupt	6	void 	ISR_6	(void)	{number_of_ISR = 6	;	Unimplemented_ISR();}
interrupt	7	void 	ISR_7	(void)	{number_of_ISR = 7	;	Unimplemented_ISR();}
interrupt	8	void 	ISR_8	(void)	{number_of_ISR = 8	;	Unimplemented_ISR();}
interrupt	9	void 	ISR_9	(void)	{number_of_ISR = 9	;	Unimplemented_ISR();}
interrupt	10	void 	ISR_10	(void)	{number_of_ISR = 10	;	Unimplemented_ISR();}
interrupt	11	void 	ISR_11	(void)	{number_of_ISR = 11	;	Unimplemented_ISR();}
interrupt	12	void 	ISR_12	(void)	{number_of_ISR = 12	;	Unimplemented_ISR();}
interrupt	13	void 	ISR_13	(void)	{number_of_ISR = 13	;	Unimplemented_ISR();}
interrupt	14	void 	ISR_14	(void)	{number_of_ISR = 14	;	Unimplemented_ISR();}
interrupt	15	void 	ISR_15	(void)	{number_of_ISR = 15	;	Unimplemented_ISR();}
interrupt	16	void 	ISR_16	(void)	{number_of_ISR = 16	;	Unimplemented_ISR();}
interrupt	17	void 	ISR_17	(void)	{number_of_ISR = 17	;	Unimplemented_ISR();}
interrupt	18	void 	ISR_18	(void)	{number_of_ISR = 18	;	Unimplemented_ISR();}
interrupt	19	void 	ISR_19	(void)	{number_of_ISR = 19	;	Unimplemented_ISR();}
//interrupt	20	void 	ISR_20	(void)	{number_of_ISR = 20	;	Unimplemented_ISR();}
interrupt	21	void 	ISR_21	(void)	{number_of_ISR = 21	;	Unimplemented_ISR();}
interrupt	22	void 	ISR_22	(void)	{number_of_ISR = 22	;	Unimplemented_ISR();}
interrupt	23	void 	ISR_23	(void)	{number_of_ISR = 23	;	Unimplemented_ISR();}
interrupt	24	void 	ISR_24	(void)	{number_of_ISR = 24	;	Unimplemented_ISR();}
interrupt	25	void 	ISR_25	(void)	{number_of_ISR = 25	;	Unimplemented_ISR();}
interrupt	26	void 	ISR_26	(void)	{number_of_ISR = 26	;	Unimplemented_ISR();}
interrupt	27	void 	ISR_27	(void)	{number_of_ISR = 27	;	Unimplemented_ISR();}
interrupt	28	void 	ISR_28	(void)	{number_of_ISR = 28	;	Unimplemented_ISR();}
interrupt	29	void 	ISR_29	(void)	{number_of_ISR = 29	;	Unimplemented_ISR();}
interrupt	30	void 	ISR_30	(void)	{number_of_ISR = 30	;	Unimplemented_ISR();}
interrupt	31	void 	ISR_31	(void)	{number_of_ISR = 31	;	Unimplemented_ISR();}
interrupt	32	void 	ISR_32	(void)	{number_of_ISR = 32	;	Unimplemented_ISR();}
interrupt	33	void 	ISR_33	(void)	{number_of_ISR = 33	;	Unimplemented_ISR();}
interrupt	34	void 	ISR_34	(void)	{number_of_ISR = 34	;	Unimplemented_ISR();}
interrupt	35	void 	ISR_35	(void)	{number_of_ISR = 35	;	Unimplemented_ISR();}
interrupt	36	void 	ISR_36	(void)	{number_of_ISR = 36	;	Unimplemented_ISR();}
interrupt	37	void 	ISR_37	(void)	{number_of_ISR = 37	;	Unimplemented_ISR();}
interrupt	38	void 	ISR_38	(void)	{number_of_ISR = 38	;	Unimplemented_ISR();}
interrupt	39	void 	ISR_39	(void)	{number_of_ISR = 39	;	Unimplemented_ISR();}
interrupt	40	void 	ISR_40	(void)	{number_of_ISR = 40	;	Unimplemented_ISR();}
interrupt	41	void 	ISR_41	(void)	{number_of_ISR = 41	;	Unimplemented_ISR();}
interrupt	42	void 	ISR_42	(void)	{number_of_ISR = 42	;	Unimplemented_ISR();}
interrupt	43	void 	ISR_43	(void)	{number_of_ISR = 43	;	Unimplemented_ISR();}
interrupt	44	void 	ISR_44	(void)	{number_of_ISR = 44	;	Unimplemented_ISR();}
interrupt	45	void 	ISR_45	(void)	{number_of_ISR = 45	;	Unimplemented_ISR();}
interrupt	46	void 	ISR_46	(void)	{number_of_ISR = 46	;	Unimplemented_ISR();}
interrupt	47	void 	ISR_47	(void)	{number_of_ISR = 47	;	Unimplemented_ISR();}
interrupt	48	void 	ISR_48	(void)	{number_of_ISR = 48	;	Unimplemented_ISR();}
interrupt	49	void 	ISR_49	(void)	{number_of_ISR = 49	;	Unimplemented_ISR();}
interrupt	50	void 	ISR_50	(void)	{number_of_ISR = 50	;	Unimplemented_ISR();}
interrupt	51	void 	ISR_51	(void)	{number_of_ISR = 51	;	Unimplemented_ISR();}
interrupt	52	void 	ISR_52	(void)	{number_of_ISR = 52	;	Unimplemented_ISR();}
interrupt	53	void 	ISR_53	(void)	{number_of_ISR = 53	;	Unimplemented_ISR();}
interrupt	54	void 	ISR_54	(void)	{number_of_ISR = 54	;	Unimplemented_ISR();}
interrupt	55	void 	ISR_55	(void)	{number_of_ISR = 55	;	Unimplemented_ISR();}
interrupt	56	void 	ISR_56	(void)	{number_of_ISR = 56	;	Unimplemented_ISR();}
interrupt	57	void 	ISR_57	(void)	{number_of_ISR = 57	;	Unimplemented_ISR();}
interrupt	58	void 	ISR_58	(void)	{number_of_ISR = 58	;	Unimplemented_ISR();}
interrupt	59	void 	ISR_59	(void)	{number_of_ISR = 59	;	Unimplemented_ISR();}
interrupt	60	void 	ISR_60	(void)	{number_of_ISR = 60	;	Unimplemented_ISR();}
interrupt	61	void 	ISR_61	(void)	{number_of_ISR = 61	;	Unimplemented_ISR();}
interrupt	62	void 	ISR_62	(void)	{number_of_ISR = 62	;	Unimplemented_ISR();}
interrupt	63	void 	ISR_63	(void)	{number_of_ISR = 63	;	Unimplemented_ISR();}
#pragma CODE_SEG DEFAULT

//==============================================================================
//Example of SCI0 Interrupt routine
//==============================================================================
#pragma CODE_SEG NON_BANKED
interrupt 20 void SCI0_Isr(void)
{   
 unsigned char scicr2,scisr1;
 scisr1 = SCI0SR1;                          // save status register actual status
 scicr2 = SCI0CR2;                          // save control register actual status

 //if receiver interrupt is enabled and corresponding interrupt flag is set
 if((scicr2 & SCI0CR2_RIE_MASK) && ((scisr1 & (SCI0SR1_OR_MASK | SCI0SR1_RDRF_MASK))))
  {
    if(scisr1 & SCI0SR1_OR_MASK)            // if overrun error do nothing/something
      {
        (void)SCI0DRL;                      // clear interrupt flag 
        // do something
      }
    else
      {
        sc0_data_in = SCI0DRL;             // read received character + clear interrupt flag
        
        
        //here implement the recognizing of received data. I have used method where
        //I always receive packet with constant size and the packet start with two #
        //characters
               
                
        //do something with data in buffer            
            
        PORTB_PB4  = ~PORTB_PB4; //just negate the LED
          
        
      }
  }
}
#pragma CODE_SEG DEFAULT

//==============================================================================

void main(void) {
  /* put your own code here */
  


	EnableInterrupts;


  for(;;) {
    _FEED_COP(); /* feeds the dog */
  } /* loop forever */
  /* please make sure that you never leave main */
}
