/*******************************************************************************
* Freescale Semiconductor Inc.
* (c) Copyright 2004-2005 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
********************************************************************************
Services performed by FREESCALE in this matter are performed AS IS and without 
any warranty. CUSTOMER retains the final decision relative to the total design 
and functionality of the end product. FREESCALE neither guarantees nor will be 
held liable by CUSTOMER for the success of this project.
FREESCALE DISCLAIMS ALL WARRANTIES, EXPRESSED, IMPLIED OR STATUTORY INCLUDING, 
BUT NOT LIMITED TO, IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR 
A PARTICULAR PURPOSE ON ANY HARDWARE, SOFTWARE OR ADVISE SUPPLIED TO THE PROJECT
BY FREESCALE, AND OR NAY PRODUCT RESULTING FROM FREESCALE SERVICES. IN NO EVENT
SHALL FREESCALE BE LIABLE FOR INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF
THIS AGREEMENT.

CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or
actions by anyone on account of any damage, or injury, whether commercial, 
contractual, or tortuous, rising directly or indirectly as a result of an advise
or assistance supplied CUSTOMER in connection with product, services or goods 
supplied under this Agreement.
********************************************************************************
* File      main.c
* Owner     B34874
* Version   1.0
* Date      Sep-3-2012
* Classification   General Business Information
* Brief     Interrupt catcher example code  at S12G128
********************************************************************************
* Detailed Description:
*
* If we load the flash security byte together with other code, 
* then we have to add following command to preload command file (P&E_Multilink_USB_Preload.cmd if you use PE Multilink):
* 
* FLASH NOUNSECURE
* 
* This command will ensure that the burner will not change security byte to unsecured state prior to programming. 
* That's normal way: the MCU is erased, flash security byte is programmed to default unsecure state (0xFE) and 
* then the code is loaded. We just have to turn off the programming of security byte.
* 
* Why:
* The cumulative bits within the phrase is not allowed. If the flash security byte at address 0xFF0F is not erased 
* prior to programming of the new value then the ECC checksum of this phrase is corrupted and the MCU will be left 
* in secured state and the flash will be fully protected after next reset. 
* 
* Datasheet says:
* "If a double bit fault is detected while reading the P-Flash phrase containing the P-Flash protection byte during 
* the reset sequence, the FPOPEN bit will be cleared and remaining bits in the FPROT register will be set to leave 
* the P-Flash memory fully protected."
* 
* "If a double bit fault is detected while reading the P-Flash phrase containing the Flash security byte during the 
* reset sequence, all bits in the FSEC register will be set to leave the Flash module in a secured state with 
* backdoor key access disabled."
* 
* "If a double bit fault is detected while reading the P-Flash phrase containing the EEPROM protection byte
* during the reset sequence, the DPOPEN bit will be cleared and DPS bits will be set to leave the EEPROM
* memory fully protected." 
*
* If the security is enabled then: - internal flash memory cannot be read via BDM device - this is the main point. 
* - debug features are disabled 
*  
* For more information see the description of FSEC register in datasheet.
* I would like also recommend our application note AN2400 HCS12 NVM Guidelines:
* http://cache.freescale.com/files/microcontrollers/doc/app_note/AN2400.pdf?fsrch=1&sr=1
* AN2880 Using the Backdoor Access Capability to Unsecure HCS12 MCUs:
* http://cache.freescale.com/files/microcontrollers/doc/app_note/AN2880.pdf?fsrch=1&sr=2
* http://www.freescale.com/webapp/sps/download/license.jsp?colCode=AN2880SW&location=null&fsrch=1&sr=2&Parent_nodeId=from%20search&Parent_pageType=from%20search
* 
* Unsecure is possible by three ways:
* 1. Backdoor key access(temporary)
* 2. Reprogramming the security bits
* 3. Complete memory erase (special modes) - only way for this example code
* 
* Ad1) The backdoor key access method allows debugging of a secured microcontroller without having to erase the Flash. 
* This is particularly useful for failure analysis. 
* For unsecure by backdoor key you use special flash command 0C (caption 26.4.6.11 Verify Backdoor Access Key Command page 987 
* in S12G reference manual). Example is in attached file, additionally is there only sending status on SCI(backdoor key is 
* there 4time 0xAAAA). No word of the backdoor key is allowed to have the value 0x0000 or 0xFFFF. Unsecure is valid only 
* till reset. If an invalid attempt is made to verify the Backdoor Keys the command will be locked out until a power down occurs.  
* 
* Ad2) In normal single chip mode (NS), security can also be disabled by erasing and reprogramming the security bits within 
* Flash options/security byte to the unsecured value. Because the erase operation will erase the entire sector from 
* 0xFE00-0xFFFF (0x0F_FE00-0x0F_FFFF), the backdoor key and the interrupt vectors will also be erased; this method is 
* not recommended for normal single chip mode.
* 
* Ad3) Complete mass erase by BDM device(in special mode). In Code Warior debugger menu ->MultilinkCyclonePro->Unsecure ...
* Note: default busclock after reset is 6.25Mhz
*  
* If not work you can use unsecure12 from P&E.
* http://www.pemicro.com/support/downloads_find.cfm         -           choose HC(S)12(X)
* Download "Unsecure_12" and "Unsecure_12 Help Files".
* For downloading is necessary registration.
* 
* 
********************************************************************************
Revision History:
Version  Date         Author  Description of Changes
1.0      Sep-3-2012   B34874  Initial version
*******************************************************************************/

#include <hidef.h>      /* common defines and macros */
#include "derivative.h"      /* derivative-specific definitions */

//secure the flash
const unsigned char flash_sec @0xFF0F = 0xFD;

void main(void) {
  /* put your own code here */
  


	EnableInterrupts;


  for(;;) {
    _FEED_COP(); /* feeds the dog */
  } /* loop forever */
  /* please make sure that you never leave main */
}
