/*******************************************************************************
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
********************************************************************************
Services performed by FREESCALE in this matter are performed AS IS and without
any warranty. CUSTOMER retains the final decision relative to the total design
and functionality of the end product. FREESCALE neither guarantees nor will be
held liable by CUSTOMER for the success of this project.
FREESCALE DISCLAIMS ALL WARRANTIES, EXPRESSED, IMPLIED OR STATUTORY INCLUDING,
BUT NOT LIMITED TO, IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR
A PARTICULAR PURPOSE ON ANY HARDWARE, SOFTWARE ORE ADVISE SUPPLIED TO A PROJECT
BY FREESCALE, AND OR NAY PRODUCT RESULTING FROM FREESCALE SERVICES. IN NO EVENT
SHALL FREESCALE BE LIABLE FOR INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF
THIS AGREEMENT.
CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or
actions by anyone on account of any damage, or injury, whether commercial,
contractual, or tortuous, rising directly or indirectly as a result of an advise
or assistance supplied CUSTOMER in connection with product, services or goods
supplied under this Agreement.
********************************************************************************
* File main.c
* Owner b34874
* Version 1.0 // version 0.x is reserved for development phase and
// should not be placed in the repository
* Date Oct-15-2012
* Classification General Business Information/Internal Use Only/Confidential Proprietary
* Brief Brief description of the file
********************************************************************************
* Detailed Description:
* Software trimming APICLK to 10kHz 
* Tested on: S12G240, TWR-S12G240, 
* CLK source:1MHz IRCCLK; BUSCLK:8MHz
********************************************************************************
Revision History:
Version Date Author Description of Changes
1.0 Oct/15/2012 b34874 Initial Version
*******************************************************************************/
#include <hidef.h>      /* common defines and macros */
#include "derivative.h"      /* derivative-specific definitions */

//==============================================================================
// API_Init
//==============================================================================
void API_Init(void)
{  
  CPMUACLKTR=0xF4;       //Trimming value - special for every MCU
  
  CPMUAPIR = 4;          //1ms interval  
  
  CPMUAPICTL = 0x09;     //API osc is source of clock, interrupt disable, 
                         //clear flag if set
  CPMUAPICTL_APIFE = 1;  //API enable
  
  CPMUAPICTL_APIES = 1;          //Show API_EXTCLK signal at PB1 pin
  CPMUAPICTL_APIEA = 1;          //
  	
	CPMUAPICTL_APIE = 1;           //interrutp enable
}

//==============================================================================
// API_ISR
//==============================================================================
#pragma CODE_SEG NON_BANKED
interrupt 59 void API_ISR(void)
{  
  PTT_PTT7 = ~PTT_PTT7;  //toggle LED => half frequency, period = 20ms, frequency = 50Hz
  CPMUAPICTL_APIF = 1;   //clear flag
}
#pragma CODE_SEG DEFAULT

void main(void) {
  
  ECLKCTL_NECLK=0;       //enable ECLK signal at pin PB0 - simply show run/stop mode

  DDRT_DDRT7 = 1;        //LED output
  
	asm ANDCC #0x7F;  //clear S bit - enable the stop mode. If the S bit is not
                    //cleared then STOP instruction has no effect and is 
                    //executed as a dummy instruction NOP. 
	
	//CPMUCLKS_PSTP = 1;//Pseudo Stop Bit- Oscillator continues to run in Stop Mode (Pseudo Stop Mode), option to run RTI and COP.
	
	API_Init();
	
	EnableInterrupts;


  for(;;) {
    
     asm STOP;         //STOP mode
  
    //now we are in STOP mode
    //CPU can be waken via interrupt or reset
    //all clocks are stopped, so asynchronous interrupt can be used only
    
    //See the Table 1-34 in 
    //http://www.freescale.com/files/32bit/doc/ref_manual/MC9S12GRMV1.pdf
    //Column "STOP Wake up" says which interrupt is able to wake up the MCU
    
  } /* loop forever */
  /* please make sure that you never leave main */
}
