/*******************************************************************************
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
********************************************************************************
Services performed by FREESCALE in this matter are performed AS IS and without
any warranty. CUSTOMER retains the final decision relative to the total design
and functionality of the end product. FREESCALE neither guarantees nor will be
held liable by CUSTOMER for the success of this project.
FREESCALE DISCLAIMS ALL WARRANTIES, EXPRESSED, IMPLIED OR STATUTORY INCLUDING,
BUT NOT LIMITED TO, IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR
A PARTICULAR PURPOSE ON ANY HARDWARE, SOFTWARE ORE ADVISE SUPPLIED TO A PROJECT
BY FREESCALE, AND OR NAY PRODUCT RESULTING FROM FREESCALE SERVICES. IN NO EVENT
SHALL FREESCALE BE LIABLE FOR INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF
THIS AGREEMENT.
CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or
actions by anyone on account of any damage, or injury, whether commercial,
contractual, or tortuous, rising directly or indirectly as a result of an advise
or assistance supplied CUSTOMER in connection with product, services or goods
supplied under this Agreement.
********************************************************************************
* File main.c
* Owner b34874
* Version 1.0 // version 0.x is reserved for development phase and
// should not be placed in the repository
* Date June-15-2012
* Classification General Business Information/Internal Use Only/Confidential Proprietary
* Brief Brief description of the file
********************************************************************************
* Detailed Description:
* Sample describe how set pins at port AD as analog input(PAD0), 
* digital inputs(PAD4..7) and outputs(PAD1..3).
* When SW5 pushed: ATD measures ATD channel 0. Result is displayed on LEDs and toggle with PAD3 pin.
* When SW4 pushed: PAD1 output is set according to SW3, PAD2 output is set according to SW2, 
*                  PAD1 and PAD2 values are displayed at LEDs   
* Tested on: PC9S12G240 0N95B, TWR-S12G240, 
* Clock source:1MHz IRC1M; BUSCLK:6.25MHz
********************************************************************************
Revision History:
Version Date Author Description of Changes
1.0 June/15/2012 b34874 Initial Version
*******************************************************************************/
#include <hidef.h>      /* common defines and macros */
#include "derivative.h"      /* derivative-specific definitions */


//==============================================================================
// Global variables
//==============================================================================
volatile unsigned int result;

//==============================================================================
// ATD_Init
//==============================================================================
void ATD_Init(void)
{
  ATDCTL1 = 0B00010000;
    //ETRIGSEL - External Trigger Source Select (without trigger)
    //SRES[1:0] - A/D Resolution Select (8 bit)
    //SMP_DIS - Discharge Before Sampling Bit 
    //ETRIGCH[3:0] - External Trigger Channel Select
  
  ATDCTL2 = 0B01000000;
    //Reserved
    //AFFC - ATD Fast Flag Clear All (yes)
    //Reserved
    //ETRIGLE - External Trigger Level/Edge Control
    //ETRIGP - External Trigger Polarity
    //ETRIGE - External Trigger Mode Enable
    //ASCIE - ATD Sequence Complete Interrupt Enable (no interrupt)
    //ACMPIE - ATD Compare Interrupt Enable (no interrupt)
  
  ATDCTL3 = 0B10100010;
    //DJM - Result Register Data Justification (Right Justified)
    //S8C, S4C, S2C, S1C - Converison Sequence Length (4)
    //FIFO - Result Register FIFO Mode (no FIFO)
    //FRZ[1:0] - Background Debug Freeze Enable (Finish current converison, then freeze)
  
  ATDCTL4 = 0B01000100;
    //SMP[2:0] - Sample Time Select (8)
    //PRS[4:0] - ATD Clock Prescaler (4 => ATD clock 0.625MHz)
    //           fATDCLK=fBUS/(2*(PRS+1)) ; fATDCLK=<0.25MHz;8MHz>           
}


//==============================================================================
// Main
//==============================================================================
void main(void) {

    DDRT = 0xF0;  //PT4..7 as LED output
    
    //at PAD4..7 are connected buttons, at PAD0 is connected potentiometer.
    DDR1AD = 0x0E;  //PAD0 input, PAD1..3 outputs, PAD4..7 inputs
    PER1AD = 0xF0;  //PAD4..7 enable pull device
    PPS1AD = 0x00;  //PAD4..7 pullup device selected
    ATDDIENL = 0xF0;  //PAD4..7 digital buffer enable
    //note:
    //Setting this bit will enable the corresponding digital input buffer continuously. 
    //If this bit is set while simultaneously using it as an analog port, there is 
    //potentially increased power consumption because the digital input buffer maybe 
    //in the linear region.  
    
    
    ATD_Init();

    for(;;) {
        
        if (!PT1AD_PT1AD4)  //SW5
          {
          ATDCTL5 = 0B00000000;//start single conversion on AN0
          //Reserved
          //SC - Special Channel Conversion Bit (no)
          //SCAN - Continuous or Single conversion sequence (Single)
          //MULT - Multi-Channel Sample Mode (one channel)
          //CD, CC, CB, CA - Analog Input Channel Select Code (channel AN0)
               
          while(ATDSTAT0_SCF == 0);   //wait for end of conversion
        
          //we can do average of all four values (length of sequence is 4 and only one channel is scanned)
          result = (ATDDR0L+ATDDR1L+ATDDR2L+ATDDR3L)/4;
          PTT = (unsigned char) ~result << 4; //and show lover 4 bits from result on LEDs (result is inverted, therefore logic 1 = LED on)
          
          PT1AD_PT1AD3 = ~PT1AD_PT1AD3; //toggle output pin PAD3
          }
        if (!PT1AD_PT1AD5)   //SW4
          {
          PT1AD_PT1AD1 = PT1AD_PT1AD6;  //copy the state of PAD6(digital input, SW3) to PAD1(digital output)
          PT1AD_PT1AD2 = PT1AD_PT1AD7;  //copy the state of PAD7(digital input, SW2) to PAD2(digital output)
          PTT = 0xFF; //clear LEDs                  
          PTT_PTT6 = PT1AD_PT1AD1; //show PAD1 value on LEDs (pushed button SW3 = LED on)
          PTT_PTT7 = PT1AD_PT1AD2; //show PAD2 value on LEDs (pushed button SW2 = LED on)
          }
    } /* work forever */
}
