/*******************************************************************************
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
********************************************************************************
Services performed by FREESCALE in this matter are performed AS IS and without
any warranty. CUSTOMER retains the final decision relative to the total design
and functionality of the end product. FREESCALE neither guarantees nor will be
held liable by CUSTOMER for the success of this project.
FREESCALE DISCLAIMS ALL WARRANTIES, EXPRESSED, IMPLIED OR STATUTORY INCLUDING,
BUT NOT LIMITED TO, IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR
A PARTICULAR PURPOSE ON ANY HARDWARE, SOFTWARE ORE ADVISE SUPPLIED TO A PROJECT
BY FREESCALE, AND OR NAY PRODUCT RESULTING FROM FREESCALE SERVICES. IN NO EVENT
SHALL FREESCALE BE LIABLE FOR INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF
THIS AGREEMENT.
CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or
actions by anyone on account of any damage, or injury, whether commercial,
contractual, or tortuous, rising directly or indirectly as a result of an advise
or assistance supplied CUSTOMER in connection with product, services or goods
supplied under this Agreement.
********************************************************************************
* File main.c
* Owner b34874
* Version 1.0 // version 0.x is reserved for development phase and
// should not be placed in the repository
* Date June-15-2012
* Classification General Business Information/Internal Use Only/Confidential Proprietary
* Brief Brief description of the file
********************************************************************************
* Detailed Description:
* ATD measures ATD channel 0 in continuous conversion sequence. Result is displayed on LEDs during ATD interrupt.  
* Tested on: PC9S12G240 0N95B, TWR-S12G240, 
* Clock source:1MHz IRC1M; BUSCLK:6.25MHz
********************************************************************************
Revision History:
Version Date Author Description of Changes
1.0 June/15/2012 b34874 Initial Version
*******************************************************************************/
#include <hidef.h>      /* common defines and macros */
#include "derivative.h"      /* derivative-specific definitions */

//==============================================================================
// Global variables
//==============================================================================
volatile unsigned int result;

//==============================================================================
// ATD_ISR
//==============================================================================
#pragma CODE_SEG NON_BANKED
interrupt 22 void ATD_ISR(void) 
{
  //we can do average of all four values (length of sequence is 4 and only one channel is scanned)
  result = (ATDDR0L+ATDDR1L+ATDDR2L+ATDDR3L)/4;
        
  PTT = (unsigned char) ~result << 4; //and show lover 4 bits from result on LEDs (result is inverted, therefore logic 1 = LED on)
}
#pragma CODE_SEG DEFAULT

//==============================================================================
// ATD_Init
//==============================================================================
void ATD_Init(void)
{
  ATDCTL1 = 0B00010000;
    //ETRIGSEL - External Trigger Source Select (without trigger)
    //SRES[1:0] - A/D Resolution Select (8 bit)
    //SMP_DIS - Discharge Before Sampling Bit 
    //ETRIGCH[3:0] - External Trigger Channel Select
  
  ATDCTL2 = 0B01000010;
    //Reserved
    //AFFC - ATD Fast Flag Clear All (yes)
    //Reserved
    //ETRIGLE - External Trigger Level/Edge Control
    //ETRIGP - External Trigger Polarity
    //ETRIGE - External Trigger Mode Enable
    //ASCIE - ATD Sequence Complete Interrupt Enable (Interrupt Enable)
    //ACMPIE - ATD Compare Interrupt Enable (no interrupt)
  
  ATDCTL3 = 0B10100010;
    //DJM - Result Register Data Justification (Right Justified)
    //S8C, S4C, S2C, S1C - Converison Sequence Length (4)
    //FIFO - Result Register FIFO Mode (no FIFO)
    //FRZ[1:0] - Background Debug Freeze Enable (Finish current converison, then freeze)
  
  ATDCTL4 = 0B01000100;
    //SMP[2:0] - Sample Time Select (8)
    //PRS[4:0] - ATD Clock Prescaler (4 => ATD clock 0.625MHz)
    //           fATDCLK=fBUS/(2*(PRS+1)) ; fATDCLK=<0.25MHz;8MHz>           
}


//==============================================================================
// Main
//==============================================================================
void main(void) {

    DDRT = 0xF0;  //PT4..7 as LED output
    
    ATD_Init();
    
    ATDCTL5 = 0B00100000;  //start continuous conversion
          //Reserved
          //SC - Special Channel Conversion Bit (no)
          //SCAN - Continuous or Single conversion sequence (Continuous)
          //MULT - Multi-Channel Sample Mode (one channel)
          //CD, CC, CB, CA - Analog Input Channel Select Code (channel AN0)
    
    EnableInterrupts;

    for(;;) {
    } /* wait forever */
}
