/*******************************************************************************
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
********************************************************************************
Services performed by FREESCALE in this matter are performed AS IS and without
any warranty. CUSTOMER retains the final decision relative to the total design
and functionality of the end product. FREESCALE neither guarantees nor will be
held liable by CUSTOMER for the success of this project.
FREESCALE DISCLAIMS ALL WARRANTIES, EXPRESSED, IMPLIED OR STATUTORY INCLUDING,
BUT NOT LIMITED TO, IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR
A PARTICULAR PURPOSE ON ANY HARDWARE, SOFTWARE ORE ADVISE SUPPLIED TO A PROJECT
BY FREESCALE, AND OR NAY PRODUCT RESULTING FROM FREESCALE SERVICES. IN NO EVENT
SHALL FREESCALE BE LIABLE FOR INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF
THIS AGREEMENT.
CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or
actions by anyone on account of any damage, or injury, whether commercial,
contractual, or tortuous, rising directly or indirectly as a result of an advise
or assistance supplied CUSTOMER in connection with product, services or goods
supplied under this Agreement.
********************************************************************************
* File main.c
* Owner b34874
* Version 1.0 // version 0.x is reserved for development phase and
// should not be placed in the repository
* Date June-15-2012
* Classification General Business Information/Internal Use Only/Confidential Proprietary
* Brief Brief description of the file
********************************************************************************
* Detailed Description:
* ATD measures ATD channel 4..7 in loop. Result of channel 4 is displayed on LEDs.
* TWR-S12G240 has connected bottons at ATD channel 4..7. So, we could read 0x00 or 0xFF.  
* Tested on: PC9S12G240 0N95B, TWR-S12G240, 
* Clock source:1MHz IRC1M; BUSCLK:6.25MHz
********************************************************************************
Revision History:
Version Date Author Description of Changes
1.0 June/15/2012 b34874 Initial Version
*******************************************************************************/
#include <hidef.h>      /* common defines and macros */
#include "derivative.h"      /* derivative-specific definitions */


//==============================================================================
// Global variables
//==============================================================================
volatile unsigned int result4, result5, result6, result7;

//==============================================================================
// ATD_Init
//==============================================================================
void ATD_Init(void)
{
  ATDCTL1 = 0B00010000;
    //ETRIGSEL - External Trigger Source Select (without trigger)
    //SRES[1:0] - A/D Resolution Select (8 bit)
    //SMP_DIS - Discharge Before Sampling Bit 
    //ETRIGCH[3:0] - External Trigger Channel Select
  
  ATDCTL2 = 0B01000000;
    //Reserved
    //AFFC - ATD Fast Flag Clear All (yes)
    //Reserved
    //ETRIGLE - External Trigger Level/Edge Control
    //ETRIGP - External Trigger Polarity
    //ETRIGE - External Trigger Mode Enable
    //ASCIE - ATD Sequence Complete Interrupt Enable (no interrupt)
    //ACMPIE - ATD Compare Interrupt Enable (no interrupt)
  
  ATDCTL3 = 0B10100010;
    //DJM - Result Register Data Justification (Right Justified)
    //S8C, S4C, S2C, S1C - Converison Sequence Length (4)
    //FIFO - Result Register FIFO Mode (no FIFO)
    //FRZ[1:0] - Background Debug Freeze Enable (Finish current converison, then freeze)
  
  ATDCTL4 = 0B01000100;
    //SMP[2:0] - Sample Time Select (8)
    //PRS[4:0] - ATD Clock Prescaler (4 => ATD clock 0.625MHz)
    //           fATDCLK=fBUS/(2*(PRS+1)) ; fATDCLK=<0.25MHz;8MHz>           
}


//==============================================================================
// Main
//==============================================================================
void main(void) {

    DDRT = 0xF0;  //PT4..7 as LED output
    
    //at PAD4..7 are connected buttons. So, we could read 0x00 or 0xFF.
    PER1AD = 0xF0;  //PAD4..7 enable pull device
    PPS1AD = 0x00;  //PAD4..7 pullup device selected
    
    ATD_Init();

    for(;;) {
    
        ATDCTL5 = 0B00010100;//start single conversion
          //Reserved
          //SC - Special Channel Conversion Bit (no)
          //SCAN - Continuous or Single conversion sequence (Single)
          //MULT - Multi-Channel Sample Mode (Multichannel)
          //CD, CC, CB, CA - Analog Input Channel Select Code (from channel AN4)
               
        while(ATDSTAT0_SCF == 0);   //wait for end of conversion
        
        //read values and clear flags
        //conversion results are always stored into ATDDR0, ATDDR1,... , unless you select FIFO mode
        result4 = ATDDR0;
        result5 = ATDDR1;
        result6 = ATDDR2;
        result7 = ATDDR3; 
        
        PTT = (unsigned char) result4 << 4; //and show lover 4 bits from result4 on LEDs
                
    } /* work forever */
}
