/*******************************************************************************
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
********************************************************************************
Services performed by FREESCALE in this matter are performed AS IS and without
any warranty. CUSTOMER retains the final decision relative to the total design
and functionality of the end product. FREESCALE neither guarantees nor will be
held liable by CUSTOMER for the success of this project.
FREESCALE DISCLAIMS ALL WARRANTIES, EXPRESSED, IMPLIED OR STATUTORY INCLUDING,
BUT NOT LIMITED TO, IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR
A PARTICULAR PURPOSE ON ANY HARDWARE, SOFTWARE ORE ADVISE SUPPLIED TO A PROJECT
BY FREESCALE, AND OR NAY PRODUCT RESULTING FROM FREESCALE SERVICES. IN NO EVENT
SHALL FREESCALE BE LIABLE FOR INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF
THIS AGREEMENT.
CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or
actions by anyone on account of any damage, or injury, whether commercial,
contractual, or tortuous, rising directly or indirectly as a result of an advise
or assistance supplied CUSTOMER in connection with product, services or goods
supplied under this Agreement.
********************************************************************************
* File main.c
* Owner b34874
* Version 1.0 // version 0.x is reserved for development phase and
// should not be placed in the repository
* Date Oct-25-2012
* Classification General Business Information/Internal Use Only/Confidential Proprietary
* Brief Brief description of the file
********************************************************************************
* Detailed Description:
* Software calculate CRC8 checsum of whole flash
* For calculation is used low level function from checsum.c file
*
* Original checsum value is defined by linker and it is stored in EEPROM
* Defintion for linker, you can find in *.prm file - section CHECKSUM
* 
* I add parameter -CpPPage=0x0015 into compiler command line adguments for deffine of far qualifier function 
*
* Tested on: S12G240, TWR-S12G240, 
* CLK source:1MHz IRCCLK; BUSCLK:6.25MHz
********************************************************************************
Revision History:
Version Date Author Description of Changes
1.0 Oct/25/2012 b34874 Initial Version
*******************************************************************************/
#include <hidef.h>      /* common defines and macros */
#include "derivative.h"      /* derivative-specific definitions */
#include "checksum.h"        /* checksum functions */


#define CHECKSUM_STORAGE_CRC8     (*(unsigned char*)0x0400)

unsigned char crc_sum; 
unsigned long j, ptr;
unsigned int k;

unsigned int result;

void main(void) {

PTT_PTT7 = 1;                                 //LED off
DDRT_DDRT7 = 1;                               //LED output

//*****************************************************************************
//CheckSum of whole flash                                                                              
//*****************************************************************************

crc_sum = 0xFF;                               //CRC initial value
            
    
for(j=0x010000;j<=0x0E0000;j=j+0x010000)      //PPAGE increment (except last page)
    {
      for(k=0x8000;k<=0xBFFF;k++)             //Address increment
      {
        ptr = j+k;                            //Complete address
        crc_sum= CheckSumByteCRC8(crc_sum, *((unsigned char *far)ptr) , DEFAULT_CRC8_CHECKSUM);
      }
    }

j=0x0F0000;                                   //last page
for(k=0x8000;k<=0xBEFF;k++)                   //Address increment - without reset vectors
  {                                           
    ptr = j+k;                                //Complete address
    crc_sum= CheckSumByteCRC8(crc_sum, *((unsigned char *far)ptr) , DEFAULT_CRC8_CHECKSUM);
  }
  
    
//*****************************************************************************
//CheckSums compare                                                                              
//*****************************************************************************
if (crc_sum == CHECKSUM_STORAGE_CRC8) PTT_PTT7 = 0;  //if checksum ok, LED on            


  
	EnableInterrupts;


  for(;;) {
    _FEED_COP(); /* feeds the dog */
  } /* loop forever */
  /* please make sure that you never leave main */
}
