#include <hidef.h>      /* common defines and macros */
#include "derivative.h"      /* derivative-specific definitions */

volatile unsigned int result;
//volatile unsigned int command = 0x0F00; //0x0F00 = SPI Check Command  MC33810
volatile unsigned int command = 0x0FFF; //0x0FFF = SPI Check Command  MC33813

void SPI0_Init(void)
{  
  SPI0CR2 = 0x50;  //16bit, SS pin used   
  SPI0BR = 0x00;   //25MHz bus clock -> 12.5Mbit/s
  SPI0CR1 = 0x52;  //enable, master, ...
}


void main(void) {
  /* put your own code here */
  
  CPMUSYNR = 0x58;
  CPMUREFDIV = 0x00;
  CPMUPOSTDIV = 0x00;
  while(!CPMUFLG_LOCK);     //PLL - PEI mode - 25MHz
  
  
  
  SPI0_Init();              //SPI0 Init



  for(;;) {
   
  while(!(SPI0SR_SPTEF));  //Tx buffer empty?
  
  SPI0DR = command; //All Status Command
  
  (void)SPI0SR;    //clearing SPIF flag
  (void)SPI0DR;    //
  
  while(!(SPI0SR_SPIF));  // wait for transfer done
  
  
  
  
  
  while(!(SPI0SR_SPTEF));  //Tx buffer empty?
  
  SPI0DR = 0x0000; //Dummy value - Transfer data back from Ignition driver

  (void)SPI0SR;    //clearing SPIF flag
  (void)SPI0DR;    //

  while(!(SPI0SR_SPIF));  //wait for data

  result = SPI0DR;
    
  } /* loop forever */
  /* please make sure that you never leave main */
}
