#include <hidef.h>      /* common defines and macros */
#include "derivative.h"      /* derivative-specific definitions */

//==============================================================================
//Delay
//==============================================================================
void Delay(void)
{
  unsigned int i;    
  
  for(i=0; i<7000; i++) asm nop;        
}

//==============================================================================
// PWM_Init, 8bit, channel PWM0
//==============================================================================
void PWM_Init(void)
{
  //6.25MHz bus clock
  //for example we want to generate initial PWM wave on PWM0 channel 244Hz with 50% duty cycle
                            
  PWMPOL = 0x01;    //polarity - PWM channel 0 is high at the beggining of period, then low
  
  PWMCLK = 0x00;    //select clock source A for channel 0
  
  PWMPRCLK = 0x07;  //prescaler for clock A -> BusClock/128 = 6.25MHz/128 = 47.851kHz
   
  PWMCAE = 0x00;    //channel 0 operate in left aligned output mode

  PWMCTL = 0x0C;    //we use 8bit PWM 0, disable clock in wait and freeze mode
  
  PWMCNT0 = 0x00;   //reset the counter of PWM0                      
  
  //PWME = 0x01;    //enable PWM0 before channel settings
  
  PWMPER0 = 196;     //PWMPER0 = clock / PWM0frek = 47851 / 196 = 244Hz
  
  PWMDTY0 = PWMPER0/2;    //ensure duty cycle 50% 
  
  PWME = 0x01;    //enable PWM0 after channel settings 
}


void main(void) {
  /* put your own code here */
  DDRT_DDRT0 = 1;
  PWM_Init();
  PTT_PTT0 = 1;     //PWM init end signal
  

	EnableInterrupts;


  for(;;) {
    _FEED_COP(); /* feeds the dog */
  } /* loop forever */
  /* please make sure that you never leave main */
}
