/*
It is possible to avoid to use the default crt0 by doing the following:
 - Write your own startup code. This can be written in C or in assembly.
   The entry point should be named _start.
 - Pass the -nostartfiles option to m6811-elf-gcc during the final link.
   This option suppresses the link with the crt0 file.

Startup code for M68HC11.
   Copyright (C) 1999, 2000, 2002 Free Software Foundation, Inc.

This file is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

In addition to the permissions in the GNU General Public License, the
Free Software Foundation gives you unlimited permission to link the
compiled version of this file with other programs, and to distribute
those programs without any restriction coming from the use of this
file.  (The General Public License restrictions do apply in other
respects; for example, they cover modification of the file, and
distribution when not linked into another program.)

This file is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

/* As a special exception, if you link this library with other files,
   some of which are compiled with GCC, to produce an executable,
   this library does not by itself cause the resulting executable
   to be covered by the GNU General Public License.
   This exception does not however invalidate any other reasons why
   the executable file might be covered by the GNU General Public License.  */
        
;-----------------------------------------
; startup code
;-----------------------------------------
        .file   "crt0.s"

        .mode mshort


;; 
;; 
;; The linker concatenates the .install* sections in the following order:
;; 
;; .install0    Setup the stack pointer
;; .install1    Place holder for applications
;; .install2    Optional installation of data section in memory
;; .install3    Place holder for applications
;; .install4    Invokes the main
;; 
;---------------------------------------------------------------------------
        .sect   .install0,"ax",@progbits
        .globl _start

_start:
;;
;; At this step, the stack is not initialized and interrupts are masked.
;; Applications only have 64 cycles to initialize some registers.
;;
;; To have a generic/configurable startup, initialize the stack to
;; the end of some memory region.  The _stack symbol is defined by
;; the linker.
;;

;       Custom startup code for the 9s12c32:
.equ REGBASE, 0x0
.equ RAMBASE, 0x3800
.equ INITRM,  0x0010     ; RAM Position
.equ INITRG,  0x0011     ; Register position
.equ SYNR,    0x34
.equ REFDV,   0x35
.equ CRGFLG,  0x37
.equ CLKSEL,  0x39
.equ PLLCTL,  0x3A



        sei                       ; Disable interrupts
        movb    #0,   INITRG      ; set INITRG to 0x0 (Registers at 0x0000)
        movb    #0x39, INITRM     ; set INITRM to 0x39 (RAM 0x3800 - 0x3fff)
        lds     #_stack           ; stack is normally 0x3fce (specified in memory.x file)
        
;;      The internal PLL clock lets us set the speed of the processor.
;;      If you do not set the speed of the PLL as we are doing here, the
;;      default bus speed speed will be 4 Mhz (half the OscFreq).
;;
;;      The math used to set the PLL frequency:
;;        OscFreq = 8Mhz
;;        initSYNR = 2      PLL multiplier
;;        initREFDV = 0     PLL divider - 1
;;        PLLCLK = 2 * OscFreq * (initSYNR+1) / (initREFDV+1)
;;      Usually the OscFreq is 8Mhz, so we have PLLCLK = 2*8*3/1 = 48Mhz
;;      The bus clock runs at half of the PLL speed:
;;        Bus Clock = PLLCLK / 2 = 24 Mhz (for an OscFreq of 8 Mhz)
;;
;;      The effective cycle clock you should use for timing instructions is the
;;      bus clock of 24 Mhz. This is currently the fastest speed this device
;;      can safely use. Overclocking is not recommended.
;;
;;      If you set a slower speed, it will reduce power consumption. If low
;;      power consumption is important (like for battery-powered circuits), you
;;      should also put the processor to sleep as often as possible.
;;
;;      Set the PLL speed:
;;
        bclr CLKSEL, #0x80        ; disengage PLL to system
        bset PLLCTL, #0x40        ; turn on PLL
        movb #0x2, SYNR           ; set PLL multiplier
        movb #0x0, REFDV          ; set PLL divider
        nop
        nop
 			          ; wait for the PLLCLK to stabalize
        brclr CRGFLG, #0x08, *+0  ; while (!(crg.crgflg.bit.lock==1))
        bset CLKSEL, #0x80        ; engage PLL to system
	cli                       ; enable interrupts


;---------------------------------------------------------------------------    
        .sect   .install2,"ax",@progbits
;;
;; Call a specific initialization operation.  The default is empty.
;; It can be overriden by applications.  It is intended to initialize
;; the 68hc11 registers.  Function prototype is:
;; 
;;      int __premain(void);
;; 
        jsr     __premain
        
;;
;; 
;;
;---------------------------------------------------------------------------
        .sect   .install4,"ax",@progbits
        jsr     main
fatal:
        jsr     exit
        bra fatal

;-----------------------------------------
; end startup code
;-----------------------------------------
;; Force loading of data section mapping and bss clear
        .2byte  __map_data_section
        .2byte  __init_bss_section
