 /* M68HCS12C32 Interrupt vectors table */

	.sect .text
	.globl _start

;; Default interrupt handler.
	.sect .text
def:
	rti

;;
;; Interrupt vectors are in a specific section that is
;; mapped at 0xff8a. For the example program, the reset handler
;; points to the generic crt0 entry point.
;;
	.sect .vectors
	.globl vectors
vectors:
   	.word def			; ff8a
	.word def			; ff8c
	.word def			; ff8e
	.word def			; ff90
	.word def			; ff92
	.word def			; ff94
   	.word def			; ff96
	.word def			; ff98
	.word def			; ff9a
	.word def			; ff9c
	.word def			; ff9e
   	.word def			; ffa0
	.word def			; ffa2
	.word def			; ffa4
	.word def			; ffa6
	.word def			; ffa8
	.word def			; ffaa
   	.word def			; ffac
	.word def			; ff9e
	.word def			; ffb0
	.word def			; ffb2
	.word def			; ffb4
	.word def			; ffb6
	.word def			; ffb8
	.word def			; ffba
	.word def			; ffbc
	.word def			; ffbe
	.word def			; ffc0
	.word def			; ffc2
	.word def			; ffc4
	.word def			; ffc6
	.word def			; ffc8
	.word def			; ffca
	.word def			; ffcc
	.word def			; ffce
	.word def			; ffd0
	.word def			; ffd2
	.word def			; ffd4

	;; SCI
	.word def			; ffd6

	;; SPI
	.word def			; ffd8
	.word def			; ffda (PAII)
	.word def			; ffdc (PAOVI)
	.word def			; ffde (TOI)

	;; Timer Output Compare
	.word def			; ffe0
	.word def			; ffe2
	.word def			; ffe4
	.word def			; ffe6
	.word def			; ffe8

	;; Timer Input compare
	.word def			; ffea
	.word def			; ffec
	.word def			; ffee

	;;  Misc
	.word def   		; fff0 (RTII)
	.word def			; fff2 (IRQ)
	.word def			; fff4 (XIRQ)
	.word def   		; fff6 (SWI)
	.word def			; fff8 (ILL)
	.word def    		; fffa (COP Failure)
	.word def			; fffc (COP Clock monitor)
	.word _start		; fffe (reset)


