// BugProps.cpp : implementation file
//

#include "stdafx.h"
#include "WinBug11.h"
#include "BugProps.h"
#include "CProgram.h"
#include "errcodes.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CProgram program;

/////////////////////////////////////////////////////////////////////////////
// CBugProps dialog


CBugProps::CBugProps(CWnd* pParent /*=NULL*/)
	: CDialog(CBugProps::IDD, pParent)
{
	//{{AFX_DATA_INIT(CBugProps)
	m_strPort = _T("COM1");
	m_nTalkerType = 0;
	m_strTalkerFileName = _T("wintalk.boo");
	m_flEeprom = FALSE;
	m_nMode = 1;
	m_uiDelayTime = 20;
	m_nDefaultBase = -1;
	//}}AFX_DATA_INIT
}


void CBugProps::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CBugProps)
	DDX_CBString(pDX, IDC_COMMPORT, m_strPort);
	DDV_MaxChars(pDX, m_strPort, 5);
	DDX_Radio(pDX, IDC_TALKER, m_nTalkerType);
	DDX_Text(pDX, IDC_TALKERNAME, m_strTalkerFileName);
	DDX_Check(pDX, IDC_EEPROM, m_flEeprom);
	DDX_CBIndex(pDX, IDC_CHIPMODE, m_nMode);
	DDX_Text(pDX, IDC_DELAY_TIME, m_uiDelayTime);
	DDX_Radio(pDX, IDC_DEFAULT_BASE, m_nDefaultBase);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CBugProps, CDialog)
	//{{AFX_MSG_MAP(CBugProps)
	ON_BN_CLICKED(IDC_TALKER_BROWSE, OnTalkerBrowse)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBugProps message handlers

void CBugProps::OnTalkerBrowse() 
{
	char szFilters[] = "Bootloader Files (.boo)|*.boo|All Files (*.*)|*.*||";
	CFileDialog filedlg(TRUE, "boo", "*.boo",
						OFN_FILEMUSTEXIST | OFN_HIDEREADONLY,
						szFilters, this);
	if(filedlg.DoModal() == IDOK)
	{
		m_strTalkerFileName = filedlg.GetPathName();
		SetDlgItemText(IDC_TALKERNAME, m_strTalkerFileName);
	}
}

BOOL CBugProps::OnInitDialog() 
{
	m_flEeprom = (BOOL)AfxGetApp()->GetProfileInt("Startup", "EEPROM", FALSE);
	m_nMode = AfxGetApp()->GetProfileInt("Startup", "Mode", 0);
	m_nTalkerType = AfxGetApp()->GetProfileInt("Startup", "Talker", 0);
	m_strPort = AfxGetApp()->GetProfileString("Startup", "Port", "COM1");
	m_strTalkerFileName = AfxGetApp()->GetProfileString("Startup", "Talker Filename", "wintalk.boo");
	m_uiDelayTime = (UINT)AfxGetApp()->GetProfileInt("Startup", "EEPROM", 20);	
	m_nDefaultBase = (UINT)AfxGetApp()->GetProfileInt("Startup", "Default Base", DEFAULT_BASE_DEC);	

	CDialog::OnInitDialog();
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CBugProps::OnOK() 
{
	CDialog::OnOK();		// Allow data exchange to occur
	UpdateData(TRUE);
	AfxGetApp()->WriteProfileInt("Startup", "EEPROM", (int)m_flEeprom);
	AfxGetApp()->WriteProfileInt("Startup", "Mode", m_nMode);
	AfxGetApp()->WriteProfileInt("Startup", "Talker", m_nTalkerType);
	AfxGetApp()->WriteProfileString("Startup", "Port", m_strPort);
	AfxGetApp()->WriteProfileString("Startup", "Talker Filename", m_strTalkerFileName);
	AfxGetApp()->WriteProfileInt("Startup", "EEPROM", (int)m_uiDelayTime);
	AfxGetApp()->WriteProfileInt("Startup", "Default Base", m_nDefaultBase);
}
