// Definition of CRegisters (68HC11 Register Operations Class)
//
// Authors: Jason Gaedtke
// Code Review: Matt Vandenbush
// Date: 12/12/96

// Include files
#include "CRegisters.h"

CRegisters::CRegisters(const CTalker* talkerObject)
{
	m_talker = (CTalker*) talkerObject;	// talker object
}

////////////////////////////////////////////////////////////
// Read: reads control registers on 68HC11 
//		and updates public data members
//
// Arguments:
//		none
//
// Return Value:
//		SUCCESS if successful, otherwise error code
//
// Example Usage:
//		registers.Read();

UINT CRegisters::Read()
{
	return (m_talker->ReadRegisters(m_uiStackPointer,		// Stack Pointer
								    m_byCCR,				// CCR register
								    m_byACCB,				// Accumulator B
								    m_byACCA,				// Accumulator A
								    m_uiIX,					// Index Register X
								    m_uiIY,					// Index Register Y
								    m_uiProgramCounter));	// Program Counter
}

////////////////////////////////////////////////////////////
// Write: modifies control registers on 68HC11 
//		to reflect the current state of the public
//		data members
//
// Arguments:
//		none
//
// Return Value:
//		SUCCESS if successful, otherwise error code
//
// Example Usage:
//		registers.Write();

UINT CRegisters::Write()
{

	return (m_talker->WriteRegisters(m_uiStackPointer,		// Stack Pointer
							  	     m_byCCR,				// CCR register
									 m_byACCB,				// Accumulator B
									 m_byACCA,				// Accumulator A
									 m_uiIX,				// Index Register X	
									 m_uiIY,				// Index Register Y
									 m_uiProgramCounter));	// Program Counter
}