// Header file for CRegisters (68HC11 Register Operations Class)
//
// Authors: Jason Gaedtke
// Code Review: Matt Vandenbush
// Date: 12/12/96

// Include files
#include "CTalker.h"

class CRegisters
{
private:
	CTalker*	m_talker;

public:
	UINT		m_uiStackPointer;
	BYTE		m_byCCR;
	BYTE		m_byACCB;
	BYTE		m_byACCA;
	UINT		m_uiIX;
	UINT		m_uiIY;
	UINT		m_uiProgramCounter;

	CRegisters(const CTalker* talkerObject);
	
////////////////////////////////////////////////////////////
// Read: reads control registers on 68HC11 
//		and updates public data members
//
// Arguments:
//		none
//
// Return Value:
//		SUCCESS if successful, otherwise error code
//
// Example Usage:
//		registers.Read();

	UINT Read();

////////////////////////////////////////////////////////////
// Write: modifies control registers on 68HC11 
//		to reflect the current state of the public
//		data members
//
// Arguments:
//		none
//
// Return Value:
//		SUCCESS if successful, otherwise error code
//
// Example Usage:
//		registers.Write();

	UINT Write();

};