// CSerial Serial Communications Class
//
// Version 1.0 : 12/9/96
// Version 1.1 : 12/14/96
// Author: Phil VanHelden
// Code Review: Jason Gaedtke, Matt Vandenbush, Phil VanHelden

#ifndef CSERIAL_H
#define CSERIAL_H

#include <windows.h>
#include <string.h>
#include <iostream.h>

#define COMTIMEOUT  20
#define COMERROR    1
#define PARSEERROR  2
#define MAXRXSIZE   1024
#define MAXTXSIZE   512
#define LOWWATER    10
#define COMMPORTSIZE	5

class CSerial
{
private:
    HANDLE m_hComPort;        // Windows handle to communications port
    BOOL m_fActive;           // flag: Is the port in use?
    char m_szComPort[COMMPORTSIZE]; // communications port name (COM1)
    UINT m_uiBaud;            // baud rate
    BYTE m_byByteSize;        // word length (4 to 8 bytes)
    BYTE m_byParity;          // parity (none (n); even (e); odd (o))
    BYTE m_byStopBits;        // stop bits (1; 1.5; 2)

public:
	UINT m_uiDelay;			// How long to delay
    
	CSerial();
    ~CSerial();

////////////////////////////////////////////////////////////
// Open:  opens the communications port
//
// Arguments:
//      cpComString : communications paramaters
//          format: "COMport:baud,parity,length,stop"
//
// Return Value:
//      0 if successful, otherwise an error structure
//
// Example Usage:
//      serial.Open("com2:9600,n,8,1");
//
// Note: STRING MUST NOT CONTAIN SPACES

    DWORD Open(const char* pszComString);

////////////////////////////////////////////////////////////
// IsPortOpen:  Boolean test: Is communications port open?
//
// Arguments:
//      none
//
// Return value:
//      TRUE if open, else FALSE
//
// Example usage:
//      serial.IsPortOpen();

    BOOL IsPortOpen();

////////////////////////////////////////////////////////////
// IsDataWaiting:  Boolean test: Is data waiting to be read?
//
// Arguments:
//      none
//
// Return value:
//      TRUE if data is available, else FALSE
//
// Example usage:
//      serial.IsDataWaiting();

    BOOL IsDataWaiting();

////////////////////////////////////////////////////////////
// GetReadLength:  returns number of bytes available on the 
//      communications port
//
// Arguments:
//      none
//
// Return value:
//      number of bytes available in input queue
//
// Example usage:
//      serial.GetReadLength();

    UINT GetReadLength();

////////////////////////////////////////////////////////////
// Read:  reads specified number of bytes from the communications
//      port
//
// Arguments:
//      bpData : pointer to BYTE array to receive data
//      uiMax : maximum number of bytes to read
//
// Return value:
//      number of bytes read
//
// Example usage:
//      serial.Read(&buffer, maxBytes);

    UINT Read(const BYTE* bypData, const UINT uiMax);

////////////////////////////////////////////////////////////
// Write:  writes specified number of bytes to the communications
//      port
//
// Arguments:
//    bpData : pointer to BYTE array of data
//    uiCount : number of bytes to write
//
// Return value:
//    0 if successful, otherwise an error structure
//
// Example usage:
//    serial.Write(&bpData, uiCount);

    DWORD Write(const BYTE* bypData, const UINT uiCount);

////////////////////////////////////////////////////////////
// Close:  closes the communications port
//
// Arguments:
//      none
//
// Return value:
//      none
//
// Example usage:
//      serial.Close();

    void Close();

};
#endif