// CSerial Serial Communications Class
//
// Designed for Win32 based software development
//
// (c) Copyright 1996 Phil VanHelden
// Permission is granted to redistribute this
// class as long as this message and copyright
// information is kept with the file and is
// left intact.
//
// Version 1.0 : 12/9/96
// Version 1.1 : 12/14/96
//
////////////////////////////////////////////////////////////////
// Revisions
//
// 12/9/96 Matt Vandenbush - Changed error return values for the
//                           member functions to a constant declared
//                           in the header, COMERROR, which is set
//                           to 1.
// 12/14/96 Phil VanHelden - Renamed private member variables to
//							 have the prefix m_, enclosed main() in
//							 #ifdef / #endif blocks
//
////////////////////////////////////////////////////////////////

#include "CSerial11.h"
#include "CSerial.h"

#define COMTIMEOUT 3

CSerial11::CSerial11() : CSerial()
{
}

CSerial11::~CSerial11()
{
}

////////////////////////////////////////////////////////////
// Read:  reads specified number of bytes from the communications
//      port
//
// Arguments:
//      bpData : pointer to BYTE array to receive data
//      uiMax : maximum number of bytes to read
//
// Return value:
//      number of bytes read
//
// Example usage:
//      serial.Read(&buffer, maxBytes);

UINT CSerial::Read(const BYTE* pbyData, const UINT uiCount)
{
    DWORD dwErrorMask;
    COMSTAT comstat;
    DWORD dwNumberToRead;
    UINT uiMaxBytes = uiCount;
    UINT uiByteCount = 0;

    if(!m_fActive)     
        return 0;           // return 0 if port is not open

    // read number of bytes available
    ClearCommError(m_hComPort, &dwErrorMask, &comstat);
    if(dwErrorMask)
        return 0;           // return 0 on error

    // set read limit
    if(uiMaxBytes > MAXRXSIZE)
        uiMaxBytes = MAXRXSIZE;
    
    // set actual read count
    if(comstat.cbInQue > uiMaxBytes)
        dwNumberToRead = uiMaxBytes;
    else
        dwNumberToRead = comstat.cbInQue;

    if(dwNumberToRead == 0)
    {
		Sleep(COMTIMEOUT);  // If no reply, wait
		
		ClearCommError(m_hComPort, &dwErrorMask, &comstat);
		if(dwErrorMask)
			return 0; // return False on comm error
		
		// set actual read count
		if(comstat.cbInQue > uiMaxBytes)
			dwNumberToRead = uiMaxBytes;
		else
			dwNumberToRead = comstat.cbInQue;

		if(dwNumberToRead == 0)
			return 0;
	}

    if(!ReadFile(m_hComPort, (BYTE*) pbyData, dwNumberToRead,
                (ULONG*) &uiByteCount, NULL))
    {
        return 0;           // return 0 on error
    }

    return uiByteCount;
}

