/////////////////////////////////////////////////
//
// ConvToULong:  Convert NULL terminated strings to unsigned longs.
//
// Arguments:
//				pszString -	pointer to NULL terminated string
//							containing the data to convert.
//							Refer to the NOTES section below.
//
// Return Value:
//				The data as a ULONG if successful, 0 otherwise.
//				This may cause some problems if the string passed.
//				converts to a 0 normally.
//
// Example Usage:
//				ulData = ConvToULong(pszData);
//
// Notes:
//				The first character of the string determines
//				the conversion type.  $ converts from hex,
//				% converts from binary, and # converts
//				from decimal.
//
// Author:		Phil VanHelden
// Reviewer:
//
// Version 1.0 - 12/15/96
//

#include <stdlib.h>
#include <string.h>
#include "stdafx.h"
#include "winbug11.h"
#include "ConvToULong.h"

unsigned long ConvToULong(const char* pszData)
{
	unsigned long ulResult = 0;
	char* cpEndPos = NULL;
	char cInvalidData = 0;
	CWinBug11App* pApp = NULL;

	switch(pszData[0])
	{
	case '$':
		if(strlen(pszData) < 6)		// Max HEX is 5 chars
			ulResult = strtoul(&pszData[1], &cpEndPos, 16);
		else
			cInvalidData = 1;
		break;
	case '%':
		if(strlen(pszData) < 17)		// Max BIN is 17 chars
			ulResult = strtoul(&pszData[1], &cpEndPos, 2);
		else
			cInvalidData = 1;
		break;
	case '#':
		if(strlen(pszData) < 5)		// Max DEC is 65535 (5 chars)
			ulResult = strtoul(pszData, &cpEndPos, 10);
		else
			cInvalidData = 1;
		break;
	default:
		pApp = (CWinBug11App*)AfxGetApp();
		switch(pApp->GetDefaultBase())
		{
		case DEFAULT_BASE_HEX:
			if(strlen(pszData) < 6)		// Max HEX is 5 chars
				ulResult = strtoul(pszData, &cpEndPos, 16);
			else
				cInvalidData = 1;
			break;
		case DEFAULT_BASE_BIN:
			if(strlen(pszData) < 17)		// Max BIN is 17 chars
				ulResult = strtoul(pszData, &cpEndPos, 2);
			else
				cInvalidData = 1;
			break;
		case DEFAULT_BASE_DEC:
			if(strlen(pszData) < 5)		// Max DEC is 65535 (5 chars)
				ulResult = strtoul(pszData, &cpEndPos, 10);
			else
				cInvalidData = 1;
			break;
		default:
			if(strlen(pszData) < 5)		// Max DEC is 65535 (5 chars)
				ulResult = strtoul(pszData, &cpEndPos, 10);
			else
				cInvalidData = 1;
			break;
		}
	}
	if((cInvalidData != 0) || (*cpEndPos != NULL))
		return 0L;
	if(ulResult > 65535)			// Max 16-bit value is 65535
		return 65535L;				// Return max value
	return ulResult;
}