/////////////////////////////////////////////////
//
// ConvToULong:  Convert NULL terminated strings to unsigned longs.
//
// Arguments:
//				pszString -	pointer to NULL terminated string
//							containing the data to convert.
//							Refer to the NOTES section below.
//
// Return Value:
//				The data as a ULONG if successful, 0 otherwise.
//				This may cause some problems if the string passed.
//				converts to a 0 normally.
//
// Example Usage:
//				ulData = ConvToULong(pszData);
//
// Notes:
//				The first character of the string determines
//				the conversion type.  $ converts from hex,
//				% converts from binary, and no prefix converts
//				from decimal.
//
// Author:		Phil VanHelden
// Reviewer:
//
// Version 1.0 - 12/15/96
//

#ifndef CONVTOULONG_H
#define CONVTOULONG_H 1

unsigned long ConvToULong(const char* pszData);

#endif