// This is the error define include file

#ifndef ERRCODES_H
#define ERRCODES_H

#define SUCCESS 0
#define COMM_ERROR 1			// Comm port not operating correctly
#define PORT_NOT_OPEN 2			// The comm port is not open
#define OPEN_PORT_FAIL 3		// Opening comm port failed
#define OPEN_TALKER_FAIL 4		// Opening talker file failed
#define INVALID_TALKER 5		// Invalid talker file detected
#define INVALID_TALKER_TYPE 6	// Invalid talker type specified
#define READ_TALKER_FAIL 7		// Reading talker failed
#define READ_MAP_FAIL 8			// Reading map file failed
#define READ_S19_FAIL 9			// Reading S19 failed
#define TALKER_TIMEOUT 10		// Talker did not respond
#define TALKER_ECHO_ERROR 11	// Echo not received properly from talker
#define RESET_FAIL 12			// Reset operation unsuccessful
#define REGISTER_WRITE_FAIL 13	// Register write failed
#define FIND_BYTE_FAIL 14		// The search byte was not found in the range
#define EEPROGRAM_FAIL 15		// Programming EEPROM failed
#define OPEN_S19_FAIL 16		// Opening S19 file failed
#define INVALID_S19 17			// Invalid S19 file
#define INVALID_S19_MEMORY 18	// S19 file does not match memory
#define BREAKPOINT_LIMIT 19		// Breakpoint limit already met
#define BREAKPOINT_SET 20		// Breakpoint set at location
#define BREAKPOINT_NOT_FOUND 21	// Breakpoint not in table
#define INVALID_OPCODE 22		// Invalid opcode found at specified address
#define TRACE_FAILED 23			// Trace instruction command failed

#endif