// MemoryDump.cpp : implementation file
//

#include "stdafx.h"
#include "assert.h"
#include "WinBug11Doc.h"
#include "WinBug11.h"
#include "MemoryDump.h"
#include "ConvToULong.h"
#include "CMemory.h"
#include "errcodes.h"
#include <ctype.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CMemory memory;

/////////////////////////////////////////////////////////////////////////////
// CMemoryDump dialog


CMemoryDump::CMemoryDump(CWnd* pParent /*=NULL*/)
	: CDialog(CMemoryDump::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMemoryDump)
	m_strEndAddress = _T("");
	m_strStartAddress = _T("");
	//}}AFX_DATA_INIT
}


void CMemoryDump::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMemoryDump)
	DDX_Text(pDX, IDC_END_ADDRESS, m_strEndAddress);
	DDX_Text(pDX, IDC_START_ADDRESS, m_strStartAddress);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMemoryDump, CDialog)
	//{{AFX_MSG_MAP(CMemoryDump)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMemoryDump message handlers

void CMemoryDump::OnOK() 
{
	CString str;
	char szData[4];
	UINT uiStartAddress = 0;
	UINT uiEndAddress = 0;
	UINT uiByteCount = 0;
	BYTE* bypReadBuffer = NULL;
	BYTE* bypReadPtr = NULL;
	int iCounter;
	UINT rc;

	UpdateData(TRUE);
	//
	// Easter Egg...
	//

	if(m_strStartAddress == "Mulder" &&
		m_strEndAddress == "Scully")
	{
		AfxMessageBox("The truth is out there...");
		return;
	}

	// OK was selected
	BeginWaitCursor();
	Sleep(0);

	// Convert the values

	uiStartAddress = (UINT)ConvToULong(m_strStartAddress);
	uiEndAddress = (UINT)ConvToULong(m_strEndAddress);

	if(uiEndAddress == 0)
		uiEndAddress = uiStartAddress + 16;


	// Align the values

	pDoc->AlignMemoryValues(&uiStartAddress, &uiEndAddress);

	m_strStartAddress.Format("$%04x", uiStartAddress);
	m_strEndAddress.Format("$%04x", uiEndAddress);

	UpdateData(FALSE);

	str.Format("Retrieving memory block $%04x-$%04x", uiStartAddress, uiEndAddress);
	pDoc->pStatus->SetPaneText(0, str);

	// Sanity check:  End must be greater than Start
	if(uiStartAddress > uiEndAddress)
	{
		AfxMessageBox("Ending Address must be larger than the Starting Address");
		return;
	}

	uiByteCount = uiEndAddress - uiStartAddress + 1;

  	bypReadBuffer = new BYTE [uiByteCount];
	ASSERT(bypReadBuffer);
	rc = memory.DisplayMemory(uiStartAddress, uiByteCount, bypReadBuffer);
	if(rc == SUCCESS)
		pDoc->SetStatusMessage("Memory Read Successful");
	else
	{
		pDoc->SetStatusMessage(rc);
		return;
	}

	// First get the document

	bypReadPtr = bypReadBuffer;
	//  Add the new string into the array
	pDoc->uiNumScroll = 2;
	str.Empty();
	str="       .00.01.02.03.04.05.06.07.08.09.0A.0B.0C.0D.0E.0F\n";
	pDoc->straMemory.Add( str );
	for(UINT uiLoopCtr = uiStartAddress; uiLoopCtr < uiEndAddress; uiLoopCtr += 16)
	{
		str.Empty();
		str.Format("$%04x - ", uiLoopCtr);
		for(iCounter = 0; iCounter < 16; iCounter++)
		{
			sprintf(szData, "%02x ", bypReadPtr[iCounter]);
			str += szData;
		}
		for(iCounter = 0; iCounter < 16; iCounter++)
			str += isprint(bypReadPtr[iCounter]) ? bypReadPtr[iCounter] : '.';

		pDoc->straMemory.Add( str );
		pDoc->uiNumScroll++;
		bypReadPtr += 16;
	}
		
	// Update the view
	pDoc->UpdateAllViews(NULL);
	pDoc->SetStatusMessage("Memory dump successful");
	delete[] bypReadBuffer;
	EndWaitCursor();
}

void CMemoryDump::OnCancel() 
{
	ShowWindow(SW_HIDE);
}
