// RegistersDlg.cpp : implementation file
//

#include "stdafx.h"
#include "WinBug11.h"
#include "RegistersDlg.h"
#include "CRegisters.h"
#include "ConvToULong.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CRegisters registers;

/////////////////////////////////////////////////////////////////////////////
// CRegistersDlg dialog


CRegistersDlg::CRegistersDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CRegistersDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CRegistersDlg)
	m_strAccA = _T("$00");
	m_strAccB = _T("$00");
	m_strCCR = _T("%00000000");
	m_strIndexX = _T("$0000");
	m_strIndexY = _T("$0000");
	m_strProgCntr = _T("$0000");
	m_strStackPtr = _T("$0000");
	//}}AFX_DATA_INIT
	m_pView = NULL;
}

void CRegistersDlg::OnCancel()
{
	ShowWindow(SW_HIDE);
}

void CRegistersDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRegistersDlg)
	DDX_Text(pDX, IDC_ACCA, m_strAccA);
	DDV_MaxChars(pDX, m_strAccA, 9);
	DDX_Text(pDX, IDC_ACCB, m_strAccB);
	DDV_MaxChars(pDX, m_strAccB, 9);
	DDX_Text(pDX, IDC_CCR, m_strCCR);
	DDV_MaxChars(pDX, m_strCCR, 9);
	DDX_Text(pDX, IDC_INDEXX, m_strIndexX);
	DDV_MaxChars(pDX, m_strIndexX, 17);
	DDX_Text(pDX, IDC_INDEXY, m_strIndexY);
	DDV_MaxChars(pDX, m_strIndexY, 17);
	DDX_Text(pDX, IDC_PC, m_strProgCntr);
	DDV_MaxChars(pDX, m_strProgCntr, 9);
	DDX_Text(pDX, IDC_STACK_PTR, m_strStackPtr);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CRegistersDlg, CDialog)
	//{{AFX_MSG_MAP(CRegistersDlg)
	ON_BN_CLICKED(IDC_READ_REGS, OnReadRegs)
	ON_BN_CLICKED(IDC_WRITE_REGS, OnWriteRegs)
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRegistersDlg message handlers

void CRegistersDlg::OnReadRegs() 
{
	char pszBuffer[9];		// For conversion of data

	if(registers.Read() != SUCCESS)
	{
		AfxMessageBox("Register Read Failed!", MB_OK | MB_ICONEXCLAMATION, 0);
		return;
	}

	// Convert the BYTE and UINTS to strings, place in the member variables

	wsprintf(pszBuffer, "$%02x", (UINT)registers.m_byACCA);
	m_strAccA.Empty();
	m_strAccA = pszBuffer;
	wsprintf(pszBuffer, "$%02x", (UINT)registers.m_byACCB);
	m_strAccB.Empty();
	m_strAccB = pszBuffer;
	wsprintf(pszBuffer, "$%04x", (UINT)registers.m_uiIX);
	m_strIndexX.Empty();
	m_strIndexX = pszBuffer;
	wsprintf(pszBuffer, "$%04x", (UINT)registers.m_uiIY);
	m_strIndexY.Empty();
	m_strIndexY = pszBuffer;
	wsprintf(pszBuffer, "$%04x", (UINT)registers.m_uiProgramCounter);
	m_strProgCntr.Empty();
	m_strProgCntr = pszBuffer;

	// Stack pointer from talker is below 9-byte interrupt frame.
	// In addition, it was incremented by the TSX instruction in the talker,
	// so we add "9-1".
	wsprintf(pszBuffer, "$%04x", (UINT)(registers.m_uiStackPointer)+(9-1));
	m_strStackPtr.Empty();
	m_strStackPtr = pszBuffer;

	// Converting the binary value is trickier...first convert to a hex string
	wsprintf(pszBuffer, "%02x", (UINT)registers.m_byCCR);
	m_strCCR.Empty();
	m_strCCR += '%';
	// Now convert each one to a binary value, placing in the string.
	for (int iCounter = 0; iCounter < 2; iCounter++)
	{
		switch(pszBuffer[iCounter])
		{
		case '0':
			m_strCCR+= "0000";
			break;
		case '1':
			m_strCCR+= "0001";
			break;
		case '2':
			m_strCCR+= "0010";
			break;
		case '3':
			m_strCCR+= "0011";
			break;
		case '4':
			m_strCCR+= "0100";
			break;
		case '5':
			m_strCCR+= "0101";
			break;
		case '6':
			m_strCCR+= "0110";
			break;
		case '7':
			m_strCCR+= "0111";
			break;
		case '8':
			m_strCCR+= "1000";
			break;
		case '9':
			m_strCCR+= "1001";
			break;
		case 'a':
		case 'A':
			m_strCCR+= "1010";
			break;
		case 'b':
		case 'B':
			m_strCCR+= "1011";
			break;
		case 'c':
		case 'C':
			m_strCCR+= "1100";
			break;
		case 'd':
		case 'D':
			m_strCCR+= "1101";
			break;
		case 'e':
		case 'E':
			m_strCCR+= "1110";
			break;
		case 'f':
		case 'F':
			m_strCCR+= "1111";
			break;
		default:
			AfxMessageBox("Unexpected value encountered in converting CCR");
		}
	}
	UpdateData(FALSE);		// Update the data in the dialog
}

void CRegistersDlg::OnWriteRegs() 
{
	UpdateData(TRUE);		// Update the class member variables

	// Convert the new data to the right format

	registers.m_byACCA = (BYTE)ConvToULong(m_strAccA);
	registers.m_byACCB = (BYTE)ConvToULong(m_strAccB);
	registers.m_uiIX = (UINT)ConvToULong(m_strIndexX);
	registers.m_uiIY = (UINT)ConvToULong(m_strIndexY);
	registers.m_byCCR = (BYTE)ConvToULong(m_strCCR);
	registers.m_uiProgramCounter = (UINT)ConvToULong(m_strProgCntr);

	// Can't allow SP to be written this way, since the displayed
	// value was modified above to take the talker interrupt frame
	// into account. In any case, there's really no good way to load
	// a stack pointer value directly.
//	registers.m_uiStackPointer = (UINT)ConvToULong(m_strStackPtr);
	
	// Write the registers out to the HC11

	if(registers.Write() != SUCCESS)
		AfxMessageBox("Error while writing registers");
}

void CRegistersDlg::OnClose() 
{
	ShowWindow(SW_HIDE);	
}
