// WinBug11.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "WinBug11.h"

#include "MainFrm.h"
#include "ChildFrm.h"
#include "MemChildFrame.h"
#include "AsmChildFrame.h"
#include "WinBug11Doc.h"
#include "WinBug11View.h"
#include "CProgram.h"
#include "CRegisters.h"
#include "RegistersDlg.h"
#include "BreakList.h"
#include "WinBugAsmView.h"
#include "CMemory.h"
#include "Splash.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CWinBug11App

BEGIN_MESSAGE_MAP(CWinBug11App, CWinApp)
	//{{AFX_MSG_MAP(CWinBug11App)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_COMMAND(ID_HELP, OnHelp)
	ON_COMMAND(ID_HELP_INDEX, OnHelpIndex)
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	// Standard print setup command
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWinBug11App construction

CWinBug11App::CWinBug11App()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CWinBug11App object

CWinBug11App theApp;

CSerial serial;
CTalker talker(&serial);
CProgram program(&talker);
CRegisters registers(&talker);
CMemory memory(&talker);

/////////////////////////////////////////////////////////////////////////////
// CWinBug11App initialization

BOOL CWinBug11App::InitInstance()
{
	// CG: The following block was added by the Splash Screen component.
	{
		CCommandLineInfo cmdInfo;
		ParseCommandLine(cmdInfo);

		CSplashWnd::EnableSplashScreen(cmdInfo.m_bShowSplash);
	}
	// Initialize OLE libraries
	if (!AfxOleInit())
	{
		AfxMessageBox(IDP_OLE_INIT_FAILED);
		return FALSE;
	}
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	SetRegistryKey("WinBug11");

	CMultiDocTemplate* pDocTemplate;
	pDocTemplate = new CMultiDocTemplate(
		IDR_WINBUGTYPE,
		RUNTIME_CLASS(CWinBug11Doc),
		RUNTIME_CLASS(CMemChildFrame), // custom MDI child frame
		RUNTIME_CLASS(CWinBug11View));
	pDocTemplate->SetContainerInfo(IDR_WINBUGTYPE_CNTR_IP);
	AddDocTemplate(pDocTemplate);

	m_pAsmTemplate = new CMultiDocTemplate(
		IDR_WINBUGTYPE,
		RUNTIME_CLASS(CWinBug11Doc),
		RUNTIME_CLASS(CAsmChildFrame), // custom MDI child frame
		RUNTIME_CLASS(CWinBugAsmView));
	pDocTemplate->SetContainerInfo(IDR_WINBUGTYPE_CNTR_IP);

	// create main MDI Frame window
	CMainFrame* pMainFrame = new CMainFrame;
	if (!pMainFrame->LoadFrame(IDR_MAINFRAME))
		return FALSE;
	m_pMainWnd = pMainFrame;
	m_pMainWindow = pMainFrame;

	// Parse command line for standard shell commands, DDE, file open
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	// Dispatch commands specified on the command line
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;

	// The main window has been initialized, so show and update it.
	pMainFrame->ShowWindow(m_nCmdShow);
	pMainFrame->UpdateWindow();

	return TRUE;
}

int CWinBug11App::ExitInstance()
{
	delete m_pAsmTemplate;
	return CWinApp::ExitInstance();
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CWinBug11App::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CWinBug11App commands

BOOL CWinBug11App::OnIdle(LONG lCount) 
{
    CString str;
	CStatusBar* pStatus = NULL;
	CListBox* pList = NULL;
	int iListIndex = 0;
	BYTE byData = 0;        // single byte buffer
    BOOL fReturn;           // nonzero = request more time

    // call parent function
    fReturn = CWinApp::OnIdle(lCount);
    
    // test execution flag
    if(program.m_fRunning)
    {
        // test for SWI signal
        if(talker.CheckSWI())
        {
            // acknowledge SWI signal and receive control registers
            if(talker.ProcessSWI(registers.m_uiProgramCounter,
                                 registers.m_uiStackPointer,
                                 registers.m_byCCR,
                                 registers.m_byACCB,
                                 registers.m_byACCA,
                                 registers.m_uiIX,
                                 registers.m_uiIY) != SUCCESS)
            {
                AfxMessageBox("SWI confirmation failed.");
                return FALSE;
            }

            // remove SWI opcodes from 68HC11 memory
            if(program.ClearBreakpoints() != SUCCESS)
            {
                AfxMessageBox("Error: unable to remove all breakpoints.");
                return FALSE;
            }

            // remove current breakpoint from breakpoint table
            if(program.RemoveBreakpoint(registers.m_uiProgramCounter) != SUCCESS)
                AfxMessageBox("Unable to remove current breakpoint from table.");
                // MAY ADD CODE TO CALL USER SWI ROUTINE HERE
            else
            {
                UINT uiPC = registers.m_uiProgramCounter;
				str.Format("Breakpoint reached at $%04x", uiPC);
				CMainFrame* pFrame = (CMainFrame*)AfxGetApp()->m_pMainWnd;
				pStatus = &pFrame->m_wndStatusBar;
				pStatus->SetPaneText(0, str);

				// Update the registers

				m_pDoc->m_pRegDlg->OnReadRegs();
				m_pDoc->m_pRegDlg->m_strProgCntr.Empty();
				m_pDoc->m_pRegDlg->m_strProgCntr.Format("$%04x", uiPC);
				m_pDoc->m_pRegDlg->UpdateData(FALSE);

				// Remove the breakpoint from the list window

				str.Empty();
				str.Format("$%04x", uiPC);
				pList = (CListBox*)m_pDoc->m_pBreakList->GetDlgItem(IDC_BREAKLIST);
				iListIndex = pList->FindString(-1, str);
				if(iListIndex != LB_ERR)
					pList->DeleteString(iListIndex);

				fReturn = FALSE;    // no more time needed
            }
        }
        else
            // request more processing time
            fReturn = TRUE;    
    }
    return fReturn;
}

BOOL CWinBug11App::PreTranslateMessage(MSG* pMsg)
{
	// CG: The following line was added by the Splash Screen component.
	CSplashWnd::PreTranslateAppMessage(pMsg);

	return CWinApp::PreTranslateMessage(pMsg);
}

void CWinBug11App::OnHelp() 
{
	WinHelp(0, HELP_CONTENTS);
}

void CWinBug11App::OnHelpIndex() 
{
	char cSearchKey = '\0';

	WinHelp((DWORD)&cSearchKey, HELP_PARTIALKEY);
}

void CWinBug11App::WinHelp(DWORD dwData, UINT nCmd) 
{
	CWinApp::WinHelp(dwData, nCmd);
}

void CWinBug11App::SetDefaultBase(UINT uiBase)
{
	m_uiDefaultBase = uiBase;
}

UINT CWinBug11App::GetDefaultBase(void)
{
	return m_uiDefaultBase;
}
