// WinBug11Doc.cpp : implementation of the CWinBug11Doc class
//

#include "stdafx.h"
#include "WinBug11.h"

#include "MemoryDump.h"
#include "TraceDlg.h"
#include "SetBreak.h"
#include "BreakList.h"
#include "RegistersDlg.h"
#include "WinBug11Doc.h"
#include "CntrItem.h"
#include "ExecuteProgram.h"
#include "ExecSub.h"
#include "CProgram.h"
#include "CMemory.h"
#include "CSerial.h"
#include "ConvToULong.h"
#include "errcodes.h"
#include "BugProps.h"
#include "FindByte.h"
#include "MoveMemory.h"
#include "BlockFill.h"
#include "MemorySet.h"
#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CProgram program;
extern CSerial serial;
extern CMemory memory;

/////////////////////////////////////////////////////////////////////////////
// CWinBug11Doc

IMPLEMENT_DYNCREATE(CWinBug11Doc, CRichEditDoc)

BEGIN_MESSAGE_MAP(CWinBug11Doc, CRichEditDoc)
	//{{AFX_MSG_MAP(CWinBug11Doc)
	ON_COMMAND(ID_PROGRAM_EXECUTE, OnProgramExecute)
	ON_COMMAND(ID_PROGRAM_STOP, OnProgramStop)
	ON_COMMAND(ID_PROGRAM_CALL_SUB, OnProgramCallSub)
	ON_COMMAND(ID_FILE_PROPS, OnFileProps)
	ON_COMMAND(ID_MEMORY_FIND_BYTE, OnMemoryFindByte)
	ON_COMMAND(ID_MEMORY_MOVE_MEMORY, OnMemoryMoveMemory)
	ON_COMMAND(ID_FILE_VERIFY, OnFileVerify)
	ON_COMMAND(ID_MEMORY_REGISTERS, OnMemoryRegisters)
	ON_UPDATE_COMMAND_UI(ID_MEMORY_REGISTERS, OnUpdateMemoryRegisters)
	ON_COMMAND(ID_MEMORY_BLOCK_FILL, OnMemoryBlockFill)
	ON_COMMAND(ID_MEMORY_SET_MEMORY, OnMemorySetMemory)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	ON_COMMAND(ID_MEMORY_MEMORY_DISPLAY, OnMemoryMemoryDisplay)
	ON_COMMAND(ID_MEMORY_CLEAR, OnMemoryClear)
	ON_COMMAND(ID_BREAKPOINT_LIST, OnBreakpointList)
	ON_UPDATE_COMMAND_UI(ID_BREAKPOINT_LIST, OnUpdateBreakpointList)
	ON_COMMAND(ID_BREAKPOINT_CLEAR, OnBreakpointClear)
	ON_COMMAND(ID_BREAKPOINT_SET, OnBreakpointSet)
	ON_COMMAND(ID_BREAKPOINT_CLEAR_ALL, OnBreakpointClearAll)
	ON_UPDATE_COMMAND_UI(ID_BREAKPOINT_CLEAR, OnUpdateBreakpointClear)
	ON_COMMAND(ID_BREAKPOINT_TRACE, OnBreakpointTrace)
	ON_COMMAND(ID_BREAKPOINT_CONTTRACE, OnBreakpointConttrace)
	ON_UPDATE_COMMAND_UI(ID_MEMORY_MEMORY_DISPLAY, OnUpdateMemoryMemoryDisplay)
	//}}AFX_MSG_MAP
	// Enable default OLE container implementation
	ON_UPDATE_COMMAND_UI(ID_OLE_EDIT_LINKS, CRichEditDoc::OnUpdateEditLinksMenu)
	ON_COMMAND(ID_OLE_EDIT_LINKS, CRichEditDoc::OnEditLinks)
	ON_UPDATE_COMMAND_UI(ID_OLE_VERB_FIRST, CRichEditDoc::OnUpdateObjectVerbMenu)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWinBug11Doc construction/destruction

extern CWinBug11App theApp;

CWinBug11Doc::CWinBug11Doc()
{
	m_pRegDlg = new CRegistersDlg;
	m_pBreakList = new CBreakList;
	m_pMemDlg = new CMemoryDump;

	m_pRegDlg->Create(IDD_REGISTERS);
	m_pRegDlg->ShowWindow(SW_HIDE);

	m_pBreakList->Create(IDD_BREAK_LIST);
	m_pBreakList->ShowWindow(SW_HIDE);

	m_pMemDlg->Create(IDD_DUMP_MEMORY);
	m_pMemDlg->ShowWindow(SW_HIDE);
	m_pMemDlg->pDoc = this;

	CMainFrame* pFrame = (CMainFrame*)AfxGetApp()->m_pMainWnd;
	pStatus = &pFrame->m_wndStatusBar;
	bAsmViewCreated = FALSE;
	theApp.m_pDoc = this;
}

CWinBug11Doc::~CWinBug11Doc()
{
	m_pRegDlg->DestroyWindow();
	m_pBreakList->DestroyWindow();
	m_pMemDlg->DestroyWindow();
	
	delete m_pMemDlg;
	delete m_pRegDlg;
	delete m_pBreakList;
	
	// Clean up the CStringArray straMemory

	straMemory.RemoveAt(0, straMemory.GetSize());

	// Clean up the CStringArray straAsmFile
	straAsmFile.RemoveAt(0, straAsmFile.GetSize());
}

BOOL CWinBug11Doc::OnNewDocument()
{
	if (!CRichEditDoc::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)

	return TRUE;
}

CRichEditCntrItem* CWinBug11Doc::CreateClientItem(REOBJECT* preo) const
{
	// cast away constness of this
	return new CWinBug11CntrItem(preo, (CWinBug11Doc*) this);
}

/////////////////////////////////////////////////////////////////////////////
// CWinBug11Doc serialization

void CWinBug11Doc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}

	// Calling the base class CRichEditDoc enables serialization
	//  of the container document's COleClientItem objects.
	CRichEditDoc::Serialize(ar);
}

/////////////////////////////////////////////////////////////////////////////
// CWinBug11Doc diagnostics

#ifdef _DEBUG
void CWinBug11Doc::AssertValid() const
{
	CRichEditDoc::AssertValid();
}

void CWinBug11Doc::Dump(CDumpContext& dc) const
{
	CRichEditDoc::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CWinBug11Doc commands

void CWinBug11Doc::OnProgramExecute() 
{
	CExecuteProgram dlg;
	UINT uiAddress;
	UINT rc;
	
	dlg.m_strAddress.Format("$%04x", program.m_uiProgramExecution);

	if(dlg.DoModal() == IDOK)
	{
		BeginWaitCursor();
		Sleep(0);

		SetStatusMessage("Beginning program execution");
		uiAddress = (UINT)ConvToULong(dlg.m_strAddress);
		rc = program.ExecuteProgram(uiAddress, TRUE);
		if(rc == SUCCESS)
			SetStatusMessage("Executing program");
		else
			SetStatusMessage(rc);
		EndWaitCursor();
	}
}

void CWinBug11Doc::OnProgramStop() 
{
	UINT rc;
	
	BeginWaitCursor();
	Sleep(0);

	SetStatusMessage("Stopping execution");
	rc = program.StopExecution();
	if(rc == SUCCESS)
		SetStatusMessage("Execution stopped");
	else
		SetStatusMessage(rc);
	EndWaitCursor();

}

void CWinBug11Doc::OnProgramCallSub() 
{
	CExecSub dlg;
	UINT uiAddress;
	UINT rc;
	
	dlg.m_strAddress.Format("$%04x", program.m_uiProgramExecution);

	if(dlg.DoModal() == IDOK)
	{
		BeginWaitCursor();
		Sleep(0);

		SetStatusMessage("Calling Subroutine");
		uiAddress = (UINT)ConvToULong(dlg.m_strAddress);
		rc = program.ExecuteSubroutine(uiAddress);
		if(rc == SUCCESS)
			SetStatusMessage("Calling Subroutine");
		else
			SetStatusMessage(rc);
		EndWaitCursor();
	}
}

void CWinBug11Doc::OnFileProps() 
{
	CBugProps dlg;
	UINT rc;
	CWinBug11App* pApp;

	if(dlg.DoModal() == IDOK)
	{
		AfxMessageBox("Please press the 68HC11 RESET button...");
		BeginWaitCursor();
		serial.m_uiDelay = dlg.m_uiDelayTime;
		pApp = (CWinBug11App*)AfxGetApp();
		pApp->SetDefaultBase(dlg.m_nDefaultBase);
		rc = program.Init(dlg.m_strPort, dlg.m_nTalkerType,
					 dlg.m_strTalkerFileName,
					 dlg.m_nMode, dlg.m_flEeprom);
		if(rc == SUCCESS)
			SetStatusMessage("Talker download successful");
		else
			SetStatusMessage(rc);
		EndWaitCursor();

	}
}

void CWinBug11Doc::OnMemoryFindByte() 
{
	CFindByte dlg;
	UINT uiStartAddr = 0;
	UINT uiEndAddr = 0;
	UINT uiValue = 0;
	UINT uiByteCount = 0;
	UINT uiSearchLocation = 0;
	unsigned int & uiLocation = uiSearchLocation;
	CString str;
	UINT rc;

	if(dlg.DoModal() == IDOK)
	{
		BeginWaitCursor();
		Sleep(0);

		uiStartAddr = (UINT)ConvToULong(dlg.m_strStartAddr);
		uiEndAddr = (UINT)ConvToULong(dlg.m_strEndAddr);
		uiValue = (UINT)ConvToULong(dlg.m_strValue);

		str.Format("Searching for $%02x starting at $%04x...", uiValue, uiStartAddr);
		SetStatusMessage(str);

		uiByteCount = (uiEndAddr - uiStartAddr) + 1;

		rc = memory.FindFirstByte(uiStartAddr,
								uiByteCount,
								uiValue,
								uiLocation);
		if(rc == SUCCESS)
		{
			str.Empty();
			str.Format("Value %02x found at location $%04x", uiValue, uiLocation);
			SetStatusMessage(str);
		}
		else
			SetStatusMessage(rc);
		EndWaitCursor();

	}
}

void CWinBug11Doc::OnMemoryMoveMemory() 
{
	CMoveMemory dlg;
	UINT uiSrcStartAddr = 0;
	UINT uiSrcEndAddr = 0;
	UINT uiDestAddr = 0;
	UINT uiByteCount = 0;
	UINT rc;
	CString str;

	if(dlg.DoModal() == IDOK)
	{
		BeginWaitCursor();
		Sleep(0);

		uiSrcStartAddr = (UINT)ConvToULong(dlg.m_strSrcStartAddr);
		uiSrcEndAddr = (UINT)ConvToULong(dlg.m_strSrcEndAddr);
		uiDestAddr = (UINT)ConvToULong(dlg.m_strDestAddr);

		str.Format("Moving block - source $%04x-$%04x - dest $%04x\n", uiSrcStartAddr, uiSrcEndAddr, uiDestAddr);
		SetStatusMessage(str);

		uiByteCount = (uiSrcEndAddr - uiSrcStartAddr) + 1;

		rc = memory.MoveBlock(uiSrcStartAddr,
							uiByteCount,
							uiDestAddr);
		if(rc == SUCCESS)
			SetStatusMessage("Memory move successful.");
		else
			SetStatusMessage(rc);
		EndWaitCursor();
	}
}

void CWinBug11Doc::OnFileVerify() 
{
	CString strS19FileName;
	CString str;
	CStdioFile sfilLstFile;
	UINT rc;

	char szFilters[] = "S19 Records (.S19)|*.S19|All Files (*.*)|*.*||";
	CFileDialog filedlg(TRUE, "S19", "*.s19",
						OFN_FILEMUSTEXIST | OFN_HIDEREADONLY,
						szFilters);
	if(filedlg.DoModal() == IDOK)
	{
		BeginWaitCursor();
		Sleep(0);

		strS19FileName = filedlg.GetPathName();
		str.Format("Verifying S19 File: %s", strS19FileName);
		SetStatusMessage(str);

		// Call routine to load the file on the HC11

		rc = program.VerifySRecordFile(strS19FileName);
		if(rc == SUCCESS)
			SetStatusMessage("S19 Memory Image Verified");
		else
			SetStatusMessage(rc);
		EndWaitCursor();
	}
}

void CWinBug11Doc::OnMemoryRegisters() 
{
	if(m_pRegDlg->IsWindowVisible())
		m_pRegDlg->ShowWindow(SW_HIDE);
	else
		m_pRegDlg->ShowWindow(SW_SHOW);
}

void CWinBug11Doc::OnUpdateMemoryRegisters(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck((int)m_pRegDlg->IsWindowVisible());
}

void CWinBug11Doc::OnMemoryBlockFill() 
{
	CBlockFill dlg;
	UINT  uiStartAddress = 0;
	UINT  uiEndAddress = 0;
	UINT  uiByteCount = 0;
	BYTE  byByte = 0;
	UINT rc;
	CString str;

	if(dlg.DoModal() == IDOK)
	{
		BeginWaitCursor();
		Sleep(0);

		uiStartAddress = ConvToULong(dlg.m_strStartAddress);
		uiEndAddress = ConvToULong(dlg.m_strEndAddress);
		byByte = (BYTE) ConvToULong(dlg.m_strValue);

		// Sanity check:  uiStartAddress < uiEndAddress
		if(uiStartAddress > uiEndAddress)
		{
			AfxMessageBox("Start Address cannot be greater than End Address");
			return;
		}
		str.Format("Filling block $%04x to $%04x with $%02x", uiStartAddress, uiEndAddress, byByte);
		SetStatusMessage(str);	
		uiByteCount = (uiEndAddress - uiStartAddress) + 1;
		rc = memory.FillBlock(uiStartAddress, uiByteCount, byByte);
		if(rc == SUCCESS)
			SetStatusMessage("Block Fill successful");
		else
			SetStatusMessage(rc);
		EndWaitCursor();
	}
}

void CWinBug11Doc::OnMemorySetMemory() 
{
	CMemorySet dlg;
	UINT uiAddress;
	BYTE byValue;
	UINT rc;
	CString str;

	if(dlg.DoModal() == IDOK)
	{
		BeginWaitCursor();
		Sleep(0);

		uiAddress = (UINT) ConvToULong(dlg.m_strAddress);
		byValue = (BYTE) ConvToULong(dlg.m_strValue);
		str.Format("Setting location $%04x to $%02x", uiAddress, byValue);
		rc = memory.WriteMemory(uiAddress, 1, &byValue);
		if(rc == SUCCESS)
			SetStatusMessage("Memory set successful");
		else
			SetStatusMessage(rc);
		EndWaitCursor();
	}
}

void CWinBug11Doc::OnFileOpen() 
{
	CString strS19FileName;
	CString strLstFileName;
	CString str;
	CMainFrame* pFrame;
	CStdioFile sfilLstFile;
	UINT rc;

	char szFilters[] = "S19 Records (.S19)|*.S19|All Files (*.*)|*.*||";
	CFileDialog filedlg(TRUE, "S19", "*.s19",
						OFN_FILEMUSTEXIST | OFN_HIDEREADONLY,
						szFilters);
	if(filedlg.DoModal() == IDOK)
	{
		BeginWaitCursor();
		Sleep(0);

		strS19FileName = filedlg.GetPathName();
		str.Format("Loading S19 record %s into memory...", strS19FileName);
		SetStatusMessage(str);
		// Call routine to load the file on the HC11
		rc = program.LoadSRecordFile(strS19FileName);
		if(rc != SUCCESS)
		{
			SetStatusMessage(rc);
			return;
		}
		rc = program.VerifySRecordFile(strS19FileName);
		if(rc != SUCCESS)
		{
			SetStatusMessage(rc);
			return;
		}

		// Build the filename for the .lst file

		if(strS19FileName.ReverseFind('.') != -1)
			strLstFileName = strS19FileName.Left(strS19FileName.ReverseFind('.'));
		else
			strLstFileName = strS19FileName;
		strLstFileName += ".lst";

		if(sfilLstFile.Open( strLstFileName, CFile::modeRead))
		{
			if(!bAsmViewCreated)
			{
				pFrame = ((CWinBug11App*)AfxGetApp())->m_pMainWindow;
				pFrame->AddAsmWindow();
				bAsmViewCreated = TRUE;
			}
			else
				straAsmFile.RemoveAll();

			// OK was selected.

			while(sfilLstFile.ReadString(str))
				straAsmFile.Add( str );
			sfilLstFile.Close();
		}
		else
			AfxMessageBox("Unable to open LST file, S19 loaded successfully");
		// Update the view
		SetStatusMessage("S19 record loaded successfully");
		UpdateAllViews(NULL);
		EndWaitCursor();
	}
}

void CWinBug11Doc::AlignMemoryValues(UINT* puiStart,
									  UINT* puiEnd)
{
	char szStart[6];
	char szEnd[6];

	// Alignment of the memory addresses on 16 byte boundaries
	// First, get the values into strings.

	sprintf(szStart, "$%04x", *puiStart);
	sprintf(szEnd, "$%04x", *puiEnd);

	// Now, convert the last character to 0 or f to align

	szStart[4] = '0';
	szEnd[4] = 'f';

	// Convert back

	*puiStart = (UINT)ConvToULong(szStart);
	*puiEnd = (UINT)ConvToULong(szEnd);
}

void CWinBug11Doc::OnMemoryMemoryDisplay() 
{
	if(m_pMemDlg->IsWindowVisible())
		m_pMemDlg->ShowWindow(SW_HIDE);
	else
		m_pMemDlg->ShowWindow(SW_SHOW);
}

void CWinBug11Doc::SetStatusMessage(UINT uiMessage)
{
	switch(uiMessage)
	{
	case SUCCESS:
		pStatus->SetPaneText(0, "Operation was successful");
		break;
	case COMM_ERROR:
		AfxMessageBox("Error - Unknown Comm Error");
		break;
	case PORT_NOT_OPEN:
		AfxMessageBox("Communications port is not open");
		break;
	case OPEN_PORT_FAIL:
		AfxMessageBox("Unable to open communications port");
		break;
	case OPEN_TALKER_FAIL:
		AfxMessageBox("Unable to open talker file");
		break;
	case INVALID_TALKER:
		AfxMessageBox("Invalid talker file detected");
		break;
	case INVALID_TALKER_TYPE:
		AfxMessageBox("Invalid talker type specified");
		break;
	case READ_TALKER_FAIL:
		AfxMessageBox("Reading talker failed");
		break;
	case READ_MAP_FAIL:
		AfxMessageBox("Reading map file failed");
		break;
	case READ_S19_FAIL:
		AfxMessageBox("Reading S19 failed");
		break;
	case TALKER_TIMEOUT:
		AfxMessageBox("Talker did not respond");
		break;
	case TALKER_ECHO_ERROR:
		AfxMessageBox("Echo not received properly from talker");
		break;
	case RESET_FAIL:
		AfxMessageBox("Reset operation unsuccessful");
		break;
	case REGISTER_WRITE_FAIL:
		AfxMessageBox("Register write failed");
		break;
	case FIND_BYTE_FAIL:
		AfxMessageBox("The search byte was not found in the range");
		break;
	case EEPROGRAM_FAIL:
		AfxMessageBox("Programming EEPROM failed");
		break;
	case OPEN_S19_FAIL:
		AfxMessageBox("Opening S19 file failed");
		break;
	case INVALID_S19:
		AfxMessageBox("Invalid S19 file");
		break;
	case INVALID_S19_MEMORY:
		AfxMessageBox("S19 file does not match memory");
		break;
	case BREAKPOINT_LIMIT:
		AfxMessageBox("Breakpoint limit already met");
		break;
	case BREAKPOINT_SET:
		AfxMessageBox("Breakpoint set at location");
		break;
	case BREAKPOINT_NOT_FOUND:
		AfxMessageBox("Breakpoint not in table");
		break;
	case INVALID_OPCODE:
		AfxMessageBox("Invalid opcode found at specified address");
		break;
	case TRACE_FAILED:
		AfxMessageBox("Trace instruction command failed");
		break;
	default:
		AfxMessageBox("Unknown Error");
	}

	MSG msg;
	while(::PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE))
		AfxGetApp()->PumpMessage();

}

void CWinBug11Doc::SetStatusMessage(const char* pszMessage)
{
	pStatus->SetPaneText(0, pszMessage);
	MSG msg;
	while(::PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE))
		AfxGetApp()->PumpMessage();

}

void CWinBug11Doc::OnMemoryClear() 
{
	BeginWaitCursor();
	Sleep(0);

	straMemory.RemoveAt(0, straMemory.GetSize());
	UpdateAllViews(NULL);
	EndWaitCursor();
}

void CWinBug11Doc::OnBreakpointList() 
{
	if(m_pBreakList->IsWindowVisible())
		m_pBreakList->ShowWindow(SW_HIDE);
	else
		m_pBreakList->ShowWindow(SW_SHOW);
}

void CWinBug11Doc::OnUpdateBreakpointList(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck((int)m_pBreakList->IsWindowVisible());
}

void CWinBug11Doc::OnBreakpointClear() 
{
	CListBox* listbox;
	int iItem;
	CString str;
	UINT uiAddress;

	BeginWaitCursor();
	Sleep(0);

	listbox = (CListBox*)m_pBreakList->GetDlgItem(IDC_BREAKLIST);
	iItem = listbox->GetCurSel();
	if(iItem != LB_ERR)
	{
		listbox->GetText(iItem, str);
		uiAddress = (UINT)ConvToULong(str);
		if(program.RemoveBreakpoint(uiAddress) == SUCCESS)
		{
			listbox->DeleteString(iItem);
			str.Empty();
			str.Format("Breakpoint $%04x Removed", uiAddress);
			SetStatusMessage(str);
		}
		else
		{
			str.Empty();
			str.Format("Unable to remove breakpoint $%04x", uiAddress);
			AfxMessageBox(str);
		}
	}
	EndWaitCursor();
}

void CWinBug11Doc::OnBreakpointSet() 
{
	UINT uiAddress;
	CSetBreak dlg;
	UINT rc;
	CListBox* listbox;
	CString str;

	if(dlg.DoModal() == IDOK)
	{
		BeginWaitCursor();
		Sleep(0);

		uiAddress = (UINT)ConvToULong(dlg.m_strAddress);
		rc = program.SetBreakpoint(uiAddress);
		if(rc == SUCCESS)
		{
			str.Format("$%04x", uiAddress);
			listbox = (CListBox*)m_pBreakList->GetDlgItem(IDC_BREAKLIST);
			listbox->AddString(str);
			str.Empty();
			str.Format("Breakpoint set at $%04x", uiAddress);
			SetStatusMessage(str);
		}
		else
			SetStatusMessage(rc);

		EndWaitCursor();
	}
}

void CWinBug11Doc::OnBreakpointClearAll() 
{
	UINT uiBreakpoints[MAXBREAKPOINTS];
	int iNumBreaks;
	CListBox* listbox;
	listbox = (CListBox*)m_pBreakList->GetDlgItem(IDC_BREAKLIST);
	
	BeginWaitCursor();
	Sleep(0);

	SetStatusMessage("Removing all breakpoints");	
	iNumBreaks = (int)program.ListBreakpoints(uiBreakpoints);
	for(int iCounter = 0; iCounter < iNumBreaks; iCounter++)
		if(uiBreakpoints[iCounter] != 0)
			program.RemoveBreakpoint(uiBreakpoints[iCounter]);

	listbox->ResetContent();
	SetStatusMessage("Breakpoint list cleared");
	EndWaitCursor();

}

void CWinBug11Doc::OnUpdateBreakpointClear(CCmdUI* pCmdUI) 
{
	CListBox* listbox;
	listbox = (CListBox*)m_pBreakList->GetDlgItem(IDC_BREAKLIST);

	pCmdUI->Enable((int)listbox->GetCurSel() != LB_ERR);	
}

void CWinBug11Doc::OnBreakpointTrace() 
{
	CTraceDlg dlg;
	UINT uiAddress;
	UINT rc;
	CString str;

	dlg.m_strAddress.Format("$%04x", program.m_uiProgramExecution);

	if(dlg.DoModal() == IDOK)
	{
		BeginWaitCursor();
		Sleep(0);

		uiAddress = (UINT)ConvToULong(dlg.m_strAddress);
		str.Format("Beginning trace at $%04x", uiAddress);
		SetStatusMessage(str);
		rc = program.TraceInstruction(uiAddress);
		if(rc == SUCCESS)
		{
			m_pRegDlg->OnReadRegs();
			m_pRegDlg->m_strProgCntr.Empty();
			m_pRegDlg->m_strProgCntr.Format("$%04x", program.m_uiProgramExecution);
			m_pRegDlg->UpdateData(FALSE);
			str.Empty();
			str.Format("Trace completed at $%04x", program.m_uiProgramExecution);
			SetStatusMessage(str);
		}
		else
			SetStatusMessage(rc);
		EndWaitCursor();
	}
}

void CWinBug11Doc::OnBreakpointConttrace() 
{
	UINT rc;
	CString str;

	BeginWaitCursor();
	Sleep(0);

	str.Format("Continuing trace at $%04x", program.m_uiProgramExecution);
	SetStatusMessage(str);
	rc = program.TraceInstruction(program.m_uiProgramExecution);
	if(rc == SUCCESS)
	{
		m_pRegDlg->OnReadRegs();
		m_pRegDlg->m_strProgCntr.Empty();
		m_pRegDlg->m_strProgCntr.Format("$%04x", program.m_uiProgramExecution);
		m_pRegDlg->UpdateData(FALSE);
		str.Empty();
		str.Format("Trace completed at $%04x", program.m_uiProgramExecution);
		SetStatusMessage(str);
	}
	else
		SetStatusMessage(rc);
	EndWaitCursor();
}

void CWinBug11Doc::OnUpdateMemoryMemoryDisplay(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck((int)m_pMemDlg->IsWindowVisible());
}
